*******************************************************************************
*
*       Program Used to Create Clipper Source Code for Database Creation
*
* The S&S Computing Group, Copyright (c) 1995.
*
*
*  Description:  Use this utility to generate source code for DBF Databases.
*                The utility allows for Function Names to be specified.
*                Multiple Functions (databases) can be appended to the same
*                file.  DOS Wildcard File specifications can be used for the
*                Database Name.  For Wildcards, a function that creates all
*                the databases can be specified.  If left blank, then it is
*                not created.
*
*
* This source code and executable may be freely used or distributed as long
* as this header remnains intact.  The source code cannot be distributed
* as a stand-alone utility for a profit, but can be incorporated in your
* applications.
*
*      Compile:   Clipper dbfsrc
* Blinker Link:   Blinker fi dbfsrc
*  RTLink Link:   RtLink fi dbfsrc
*
*******************************************************************************

#define B_SINGLE      (CHR(218)+CHR(196)+CHR(191)+CHR(179)+CHR(217)+CHR(196)+CHR(192)+CHR(179)   )

Local cDbfFile      := ""
Local cSourceFile   := "DATABASE.PRG"
Local cFunctionName
Local cALLFuncName  := "DBF_All"
Local cOldCursor, cOldColor, lAppend := .F.
Local lWildCard := .F.
Local lAddBlankLines := .F.
Local aFunc := {}
Local nI, nJ

Cls
Readexit(.F.)
Set ScoreBoard Off
Set Confirm On

SetColor("GR+/N")
@7, 7, 15,73 BOX B_SINGLE
@7,20  Say "Clipper Database Source Code Generator"
SetColor("B/W,GR+/GB,,,R/W")
@8, 8 Clear To 14,72

Do While LastKey() != 27
  cDbfFile      := MyPadRight(cDbfFile,8)
  cSourceFile   := MyPadRight(cSourceFile,30)
  cFunctionName := Space(30)
  cALLFuncName  := MyPadRight(cAllFuncName,30)
  Set Cursor On
  SetColor("B/W,GR+/GB,,,R/W")
  @9,10 Say "Enter Database File Name:" Get cDbfFile  Picture "@K!" Valid(!Empty(cDbfFile) .and. ValDbfFile(cDbfFile,@cFunctionName,@lWildCard))
  @9,45 Say "e.g. Rates, Ra*, Ra???"
  @10,10 Say "     Name of Source File:" Get cSourceFile   Picture "@K!" Valid(LastKey() = 5 .or. (!Empty(cSourceFile) .and. ValSourceFile(cSourceFile,@lAppend)))
  @11,10 Say "Create DBF Function Name:" Get cFunctionName Picture "@K"  When !lWildCard Valid(LastKey() = 5 .or.!Empty(cFunctionName))
  @13,10 Say "Create ALL Function Name:" Get cAllFuncName  Picture "@K"  When lWildCard
  @9,45 Say "Leave Blank for None"
  Read
  SetColor("G/N")
  Set Cursor Off

  If LastKey() != 27
    cSourceFile := Alltrim(cSourceFile)
    If At(".",cSourceFile) <= 0 .and. Left(cSourceFile,3) != "LPT" .and. !IsDigit(Substr(cSourceFile,4,1));
       .and. Left(cSourceFile,3) != "COM" .and. !IsDigit(Substr(cSourceFile,4,1))
       cSourceFile := cSourceFile+".PRG"
    Endif

    If At(".",cDbfFile) > 0
       cDbfFile := Left(cDbfFile,At(".",cDbfFile)-1)
    Endif
    aFile := Directory(Alltrim(cDbfFile)+".Dbf" )
    If Len(aFile) > 1 .and. !lAppend
       FErase(cSourceFile)
       lAppend := .T.
    Endif

    If lWildCard
       If !Empty(cAllFuncName)
          cAllFuncName := StrTran(StrTran(Alltrim(cAllFuncName),"(",""),")","")
       Endif
    Endif

    For nI = 1 To Len(aFile)
       cDbfFile := Alltrim(aFile[nI,1])
       cDbfFile := MyPadRight(Left(cDbfFile,At(".",cDbfFile)-1),8)
       @24,20 Say "Generating Source For Database: "+cDbfFile

       If lWildCard
          cFunctionName := "DBF_"+Upper(Left(Alltrim(cDbfFile),1))+Lower(Substr(Alltrim(cDbfFile),2))
       Else
          cFunctionName := StrTran(StrTran(Alltrim(cFunctionName),"(",""),")","")
       Endif
       Aadd(aFunc,cFunctionName)

       Use &cDbfFile Alias DbfFile New
       Copy Structure Extended To D_B_F
       Close DbfFile

       If File(cSourceFile) .and. lAppend
          lAddBlankLines := .T.
       Endif

       Set Device to Printer
       If At(".",cSourceFile) > 0 .or. (!(Left(cSourceFile,3) = "LPT" .and. IsDigit(Substr(cSourceFile,4,1)));
          .and. !(Left(cSourceFile,3) = "COM" .and. IsDigit(Substr(cSourceFile,4,1))))
          If File(cSourceFile) .and. lAppend
             Set Printer To &cSourceFile ADDITIVE
          Else
             Set Printer To &cSourceFile
          Endif
       Endif
       Set Printer On
       Set Console Off
       Set Alternate On

       If lAddBlankLines
          ? " "
          ? " "
       Endif
       lAddBlankLines := .T.

       ? "*******************************************************************************"
       ? MyPadRight("*   Create Database Structure for "+aLLTRIM(cDbfFile)+".DBF",79)
       ? "*******************************************************************************"
       ? " "
       ? "Function "+cFunctionName+"(cDbfName,cTempFile)"
       ? " "
       ? "Local nRecNo ,cFilter ,nIndexOrd ,nSelect"
       ? " "
       ? 'cDbfName := If(ValType(cDbfName)  != "C","'+Alltrim(cDbfFile)+'",AllTrim(cDbfName))'
       ? 'cDbfName := If(Rat(".",cDbfName)  <= 0,Upper(Left(cDbFile,8)+".DBF"),Upper(cDbfFile))'
       ? 'cTempFile:= If(ValType(cTempFile) != "C","TEMPSTRU.DBF",AllTrim(cTempFile))'
       ? 'cTempFile:= If(Rat(".",cTempFile) <= 0,Upper(Left(cTempFile,8)+".DBF"),Upper(cTempFile))'
       ? " "
       ? "If Used()"
       ? "   nRecNo    := RecNo()"
       ? "   cFilter   := DbFilter()"
       ? "   nIndexOrd := IndexOrd()"
       ? "   nSelect   := Select()"
       ? "Else"
       ? "   nRecNo    := 0 "
       ? '   cFilter   := ""'
       ? "   nIndexOrd := 0"
       ? "   nSelect   := 0"
       ? "Endif"
       ? " "
       ? 'FErase(cTempFile)'
       ? "Select 0"
       ? "Create (cTempFile)"
       Use D_B_F New
       Go Top
       Do While !Eof()
         ? "Append Blank"
         ? 'Replace Field_Name With "'+MyPadRight(Field_Name,10)+'", Field_Type With "'+Field_Type+'", '+;
                   'Field_Len With '+Str(Field_Len)+IIf(Field_type = "N",', Field_Dec With '+Str(Field_Dec,2),"")
         Skip
       Enddo
       Close D_B_F
       ? "Use"
       ? "Create (cDbfName) From (cTempFile) New"
       ? "Use"
       ? 'FErase(cTempFile)'
       ? "If Select(Alias(nSelect)) > 0"
       ? "   Select(Alias(nSelect))"
       ? "   DbSetOrder(nIndexOrd)"
       ? "   Set Filter To "+Chr(38)+"cFilter"
       ? "   Go (Min(nRecNo,LastRec()))"
       ? "Endif"
       ? "Return NIL"

       If nI = Len(aFile) .and. !Empty(cAllFuncName) .and. Len(aFunc) > 0
          ? " "
          ? " "
          ? "*******************************************************************************"
          ? "*                     Create All Database Structures                           "
          ? "*******************************************************************************"
          ? " "
          ? "Function "+cAllFuncName+"()"
          ? " "
          For nJ = 1 To Len(aFunc)
             ? aFunc[nJ]+"()"
          Next
          ? "Return NIL"
       Endif

       If At(".",cSourceFile) <= 0 .and. ((Left(cSourceFile,3) = "LPT" .and. IsDigit(Substr(cSourceFile,4,1)));
          .or. (Left(cSourceFile,3) = "COM" .and. IsDigit(Substr(cSourceFile,4,1))))
          Eject
       Endif
       Set Printer Off
       Set Device To Screen
       Set Console On
       Set Alternate Off

       If nI = Len(aFile)

         Tone(200,1)
         @24,0 Say Space(80)
         If At(".",cSourceFile) <= 0 .and. ((Left(cSourceFile,3) = "LPT" .and. IsDigit(Substr(cSourceFile,4,1)));
            .or. (Left(cSourceFile,3) = "COM" .and. IsDigit(Substr(cSourceFile,4,1))))
            @24,20 Say "Source File "+cSourceFile+" Was Sent To Printer."
         Else
            If lAppend
               @24,25 Say "Source File "+cSourceFile+" Was Appended."
            Else
               @24,25 Say "Source File "+cSourceFile+" Was Created."
            Endif
         Endif
         Inkey(1.5)
         @24,0 Say Space(80)
       Endif
    Next
  Endif
Enddo
Close All
Cls
FErase("D_B_F.DBF")
SetColor("W/N")
Cls
Set Cursor On
Quit


*******************************************************************************

Function ValDbfFile(cDbfFile,cFunctionName,lWildCard)

Local aFile := {}

If At(".",cDbfFile) > 0
   cDbfFile := Left(cDbfFile,At(".",cDbfFile)-1)
Endif

aFile := Directory(Alltrim(cDbfFile)+".Dbf" )

If Len(aFile) = 0
  Alert("Database File(s) Do Not Exist",{"Return"})
  Return .F.
Endif
If Empty(cFunctionName)
  cFunctionName := MyPadRight("Create"+Upper(Left(cDbfFile,1))+Lower(Substr(cDbfFile,2)),30)
Endif
If Len(aFile) > 1 .and. (At("*",cDbfFile) > 0 .or. At("?",cDbfFile) > 0)
   cFunctionName := Space(30)
   lWildCard := .T.
Endif
Return .T.


*******************************************************************************

Function ValSourceFile(cSourceFile,lAppend)

Local nRet

lAppend := .F.
If File(Alltrim(cSourceFile)+".Dbf" ) .and. Left(cSourceFile,3) != "LPT" .and. !IsDigit(Substr(cSourceFile,4,1));
   .and. Left(cSourceFile,3) != "COM" .and. !IsDigit(Substr(cSourceFile,4,1))
  nRet :=  Alert("Source File Exist",{"Replace","Append","Return"})
  If nRet = 1 .or. nRet = 2
     If nRet = 2
        lAppend := .T.
     Endif
     Return .T.
  Else
     Return .F.
  Endif
Endif
Return .T.


*******************************************************************************

Function MyPadRight(cString,nLen)

Return Left(Alltrim(cString)+Space(nLen),nLen)

