*\////////////////////////////////////////////////////*
*\                                                   /*
*\   MAKEDBFS.PRG                                    /*
*\                                                   /*
*\   Written by Larry Bauder  CIS 71320,2707         /*
*\   Released to the Public Domain   11-20-88        /*
*\   I hope someone will find the concept useful.    /*
*\---------------------------------------------------/*
*\   Compile with CLIPPER Summer 87  2:00 am Version /*
*\---------------------------------------------------/*
*\   Creates dbf file for use by     Creator()       /*
*\   which can be found in the file  testdbf.prg     /*
*\                                                   /*
*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\/*

screen()
if isdbfs()
  scandir()
endif
  

*-------------------------
func isdbfs
*-------------------------
* checks for the existence of DBFS.DBF
priv z_choice,n
save screen to temp
if file('DBFS.DBF')
  z_choice = " "
  @ 22,15 say "Zap DBFS file or Add to it? (Z/A)" get z_choice pict "!"
  do while .not. z_choice $"ZA"
    set confirm off
    read
    set confirm on
  enddo
  if z_choice = "Z"
    use dbfs
    zap
    close data
  endif
else
  * dbfs.dbf does NOT exist, so must create it
  centerme("Creating DBFS.DBF file first",22)
  declare f_name[7],f_type[7],f_len[7]
  f_name[1] = "FILE_NAME"
  f_name[2] = "FIELD_NUM"
  f_name[3] = "FIELD_NAME"
  f_name[4] = "FIELD_TYPE"
  f_name[5] = "FIELD_LEN"
  f_name[6] = "FIELD_DEC"
  f_name[7] = "TOTAL_FLDS"
  f_type[1] = "C"
  f_type[2] = "C"
  f_type[3] = "C"
  f_type[4] = "C"
  f_type[5] = "N"
  f_type[6] = "N"
  f_type[7] = "N"
  f_len[1] = 8
  f_len[2] = 2
  f_len[3] = 10 
  f_len[4] = 1
  f_len[5] = 3
  f_len[6] = 3
  f_len[7] = 2
  create temp
  use temp
  for n = 1 to 7
    append blank
    repl field_name with f_name[n], field_type with f_type[n],;
      field_len with f_len[n], field_dec with 0
  next
  use
  create dbfs from temp
  erase temp.dbf
endif
restore screen from temp
return(.T.)


*-------------------------
func scandir
*-------------------------
* procedure scans directory for all dbf's
* and includes the file structure information in
* the special dbf - DBFS.DBF
save screen to temp
kcount = adir("*.dbf")
declare dbf_files[kcount]
if kcount <= 1
  centerme("Sorry, cannot work on one or less data files.",21)
  centerme("Try another subdirectory.",22)
  return(.F.)
endif

adir("*.dbf",dbf_files)

for n = 1 to kcount
  file_1 = dbf_files[n]
  * don't include DBFS.DBF inside itself
  if file_1 = "DBFS.DBF"
    loop
  endif
  use &file_1
  centerme("FILLING DBFS.DBF",21)
  centerme(replicate("",24),22)
  centerme("Working on &file_1.",22)
  max = fcount()
  declare fname[max], ftype[max], fwidth[max],fdec[max]
  afields(fname,ftype,fwidth,fdec)
  use dbfs
  for y = 1 to max
    append blank
    repl FILE_NAME with substr(file_1,1,AT(".",file_1)-1),; 
      FIELD_NUM with iif(y<10,"0","")+str(y,iif(y<10,1,2),0),;
      FIELD_NAME with fname[y], FIELD_TYPE with ftype[y]
    repl FIELD_LEN with fwidth[y], FIELD_DEC with fdec[y],;
      TOTAL_FLDS with max
  next
  use
next
close data
restore screen from temp
return(.T.)

*-------------------------
func centerme
*-------------------------
para c_string,c_line
priv length
length = len(c_string)
@ c_line, 40-int(length/2) say c_string
return("")
  

*-------------------------
func screen
*-------------------------
priv n
clear
for n = 2 to 23
  @ n,1 say replicate("",78)
next
stretch("MAKEDBFS",10,32)
centerme("writtenbyLarryBauder",13)
centerme("71320,2707",14)
return("")

*-------------------------
func stretch
*-------------------------
para string,row_,col_
priv n
for n = 1 to len(string)
  @ row_,(n+col_) say substr(string,n,1)
  col_ = col_+1
next
return("")
