/* DbDef.H - Defines data structures used to read Dbase files */

/* structure for .dbf header record */
struct dbf_header {
    unsigned char
                id,                     /* Dbase version */
                year,                   /* date of last update */
                month,
                day;
    long        nrecs;                  /* number of records in file */
    unsigned    header_len,             /* number of bytes in header */
                record_len;             /* number of bytes per record */
    unsigned char
                reserved[20];           /* reserved bytes */
};

/* structure for field descriptor records */
struct dbf_record {
    unsigned char
                name[11],               /* field name */
                type,                   /* field type: C,N,L,D,M */
                res1[4],                /* reserved bytes */
                length,                 /* field length */
                decimals,               /* number of decimals */
                res2[14];               /* reserved bytes */
};

