/*Ŀ
 ݳ                                                                      
 ݳ Program Name: MAKEZIP.PRG       Copyright: Gallagher Computing Corp. 
 ݳ     Language: Clipper 5.2                                            
 ݳ       Author: Kevin S Gallagher                                      
 Ĵ
 ݳ Comments:                                                            
 ݳ This utility is a remake of one that i created sometime ago. In this 
 ݳ version I'am playing with TinitFile class (c) RUNsoft, created by    
 ݳ Antonio Linares.                                                     
 ݳ                                                                      
 ݳ There may be sections of code that may appear to need more safety    
 ݳ features/error checking, but we are all smart enough (i hope) to not 
 ݳ need them - feel free to add um if so desired..                      
 Ĵ
 ݳ History:                                                             
 ݳ 06/93 - recoded for trying out TiniFile Class (c)                    
 
            */

#include "init.h"

static LISTFILE, ZIPFILE
static nHandle, aFiles, Stable := {} 

function DoBackups()
    local nAsk, i, cZipName := GET_ZIP_NAME(), nCount:=0, aArr_ := {}
    local NoteFile := GET_COMMENT_FILE()

    LISTFILE := GET_LIST_FILE() 
    ZIPFILE  := GET_ZIP_FILE()
    aFiles   := ListAsArray( GET_LOCAL_FILES() )

    aArr_ :=  ListAsArray( GET_OBJ_FILE() )
    if ( nCount := len( aArr_) ) <> 0
        aeval( aArr_, {|a| aadd( Stable, a)})
    endif

    aArr_ :=  ListAsArray( GET_LIB_FILE() )
    if ( nCount := len( aArr_) ) <> 0
        aeval( aArr_, {|a| aadd( Stable, a)})
    endif
    
    if file(ZIPFILE)
        scroll()
        nAsk := alert( ASK_USER_METHOD, {" Update ", " Delete ", " Quit "} )
        do case
            case nAsk == 1
                @ROW(),0 SAY PADR(" FRESHEN "+ZIPFILE,80)
                SwpRunCmd( cZipName + " -f "+ZIPFILE, 0, "")
                QUIT
            case nAsk == 2
                if alert( ASK_OK_TO_DELETE,{ " No ", " Yes "}) == 2
                    ferase( ZIPFILE )
                else
                    // let um restart utility!
                    alert("ABONDONING DELETE;AND QUITING PROGRAM",{" QUIT "})
                    quit
                endif
            case nAsk == 3
                @0,0 SAY PADR(" OPERATION ABORTED",80) color "W+/R"
                QUIT
        endcase
    endif

    nHandle:= fcreate(LISTFILE,FC_NORMAL)
    aeval( aFiles, {|v| aeval( asort( directory("*."+v),,,aBlock),bBlock) } )
    aeval( Stable, {|v| ShowIt(v) } )
    fclose(nHandle)
    nAsk:=alert("Edit list file",{" Yes ", " No "})
    if nAsk = 1
        EditText(LISTFILE, .T.)
    endif

    if file( NoteFile )
        nAsk := alert("Edit comments for;"+GET_TITLE(), {" Yes ", " No "} )
        if nAsk = 1
            EditText( NoteFile, .T.)
        endif
    else
        nAsk := alert("Create comments for;"+GET_TITLE(), {" Yes ", " No "} )
        if nAsk = 1
            if ( nHandle:= fcreate(NoteFile,FC_NORMAL)) =-1
                ALERT("ERROR CREATING "+NoteFile)
                quit
            endif
            nHandle := fcreate(NoteFile,FC_NORMAL)
            EditText(NoteFile, .T.)
        endif
    endif

    dispbox(1,0,MR,MAXCOL(),SPACE(9),"W/N")
    SwpRunCmd( cZipName + " "+ZIPFILE+" @"+LISTFILE, 0, "")

    if file(NoteFile)
        nHandle:= fopen(NoteFile,0)
        if ferror() == 0 .AND. fseek(nHandle,0,2) > 3
            fclose(nHandle)
        endif
        // add comment to zipfile
        SwpRunCmd( cZipName + " " + ZIPFILE + " -z < " + NoteFile,0)
    endif
    // erase pkzip list file
    if FERASE(LISTFILE)== -1
        alert(LSTRINT( ferror() ) )
    endif
    // you may want to erase the comment file also?
    scroll()
return nil

function ShowIt(cFile)
    FWriteLine(nHandle,cFile)
return nil

function EditText(cFileName, lEditMode)
   local cContents, lWrite := .F., cClr, nCurs, oldins
   lEditMode :=.T.
   cContents := memoread(cFileName)
   cClr      := setcolor("bg+/b")
   nCurs     := setcursor(1)
   @00,00 say replicate(" ",80)                      color "gr+/bg"
   @MR,00 say padr(" ",80)                           color "bg /bg"
   @00,00 say "Edit: "+ cFileName                    color "w+ /bg"
   @MR,60 say "Line:"                                color "gr+/bg"
   @MR,72 say "Col:"                                 color "gr+/bg"
   @MR,00 say " F2 = Save/Exit   F10 = Abort/Exit"   color "n  /bg"
   oldins:=readinsert(.T.)
   cContents:=memoedit(cContents,1,0,MR-1,79,lEditMode, "MemoUDF", 250)
   if lastkey() = K_F2
      lWrite:=memowrit( rtrim(cFileName), cContents )
   endif
   readinsert(oldins)
   SETCOLOR(cClr)
   IF lEditMode
      setcursor(nCurs)
   ENDIF
return nil

function MemoUDF( nMode, nLin, nCol )
   local nKey, nRval
   nRval := 0
   nKey  := lastkey()
   if nMode == 0
      @MR,66 say nLin picture "9999" color "w+/bg"
      @MR,77 say nCol picture "999"  color "w+/bg"
   elseif nMode == 1 .OR. nMode == 2
      do case
          case nKey == K_F10
              nRval := 27
          case nKey == K_F2
              nRval := 23
      endcase
   endif
return (nRval)


