#define WIN_WANT_PRO
#define MB_ICONHAND           16 // 0x0010
#include "CRYSTAL.CH"
STATIC hLibCRPE
*************************
***** Load CRPE DLL *****
** CRPE(.t.) loads library 
** CRPE(.f.) frees library 
** CRPE(.t.) must be done prior to using any of these functions
** Just compile and link like any other .prg in CLIP4WIN.
** All functions are documented in Crystal Reports 3.0 Documentation
** If you are not using Pro version, the non-pro functions will still
** work. 
** These functions are not rigorously  tested. If you find any
** problems, please e-mail problems to Jason Massey 70363,2703.
** Since I'm not charging for these, I'm not obligated to fix
** anything, but most problems should be easy to fix.
**
** I don't have a SQL server, so those functions are completely
** untried.
*************************
Function CRPE(lOn)
	local hInst := _GetInstance()
	if lOn .and. hLibCRPE == nil
		hLibCRPE := LoadLibrary("CRPE.DLL")
		if hLibCRPE == nil .or. hLibCRPE < 32
			MessageBox( , "Unable to find CRPE.DLL", "Error", MB_ICONHAND)
			hLibCRPE := nil
		endif
	elseif !lOn .and. hLibCRPE != nil
		FreeLibrary(hLibCRPE)
		hLibCRPE := nil
	endif
RETURN hLibCRPE
***************************
***** Print Only Link *****
***************************
Function PEPrintReport(cReport,lToPrinter,lToWindow,cTitle,nLeft,;
					nTop,nWidth,nHeight,nlStyle,hWndDlg)
	local cDLL := GetProcAddress(hLibCRPE, "PEPrintReport", "Pascal", "int",;
											"str,log,log,str,int,int,int,int,long,HWND")
RETURN (CallDLL(cDLL,cReport,lToPrinter,lToWindow,cTitle,nLeft,;
					nTop,nWidth,nHeight,nlStyle,hWndDlg))

*********************************************
***** Print Engine Management Functions *****
*********************************************
Function PEOpenEngine()
	local cDLL := GetProcAddress(hLibCRPE, "PEOpenEngine", "Pascal", "bool", "")
RETURN (CallDLL(cDLL))

Function PECloseEngine()
	local cDLL := GetProcAddress(hLibCRPE, "PECloseEngine", "Pascal", "void", "")
RETURN (CallDLL(cDLL))

Function PEGetVersion(nRequest)
	local cDLL := GetProcAddress(hLibCRPE, "PEGetVersion", "Pascal", "long", "long")
RETURN (CallDLL(cDLL,nRequest))

*********************************************
***** Print Job Management Functions ********
*********************************************
Function PEOpenPrintJob(cRPT)
	local cDLL := GetProcAddress(hLibCRPE, "PEOpenPrintJob", "Pascal",; 
						"int", "str")
RETURN (CallDLL(cDLL,cRPT))

Function PEClosePrintJob(hPrintJob)
	local cDLL := GetProcAddress(hLibCRPE, "PEClosePrintJob", "Pascal",; 
						"void", "int")
RETURN (CallDLL(cDLL,hPrintJob))

Function PEStartPrintJob(hPrintJob,lWait)
	local cDLL := GetProcAddress(hLibCRPE, "PEStartPrintJob", "Pascal",; 
						"bool", "int,bool")
RETURN (CallDLL(cDLL,hPrintJob,lWait))

Function PEGetJobStatus(hPrintJob,cJobInfo)
	local cDLL := GetProcAddress(hLibCRPE, "PEGetJobStatus", "Pascal",; 
						"int", "int,str")
RETURN (CallDLL(cDLL,hPrintJob,cJobInfo))

************************************************
***** Print Window Management Functions ********
************************************************
Function PEGetWindowHandle(hPrintJob)
	local cDLL := GetProcAddress(hLibCRPE, "PEGetWindowHandle", "Pascal",; 
						"int", "int")
RETURN (CallDLL(cDLL,hPrintJob))

Function PEPrintWindow(hPrintJob,lWait)
	local cDLL := GetProcAddress(hLibCRPE, "PEPrintWindow", "Pascal",; 
						"bool", "int,bool")
RETURN (CallDLL(cDLL,hPrintJob,lWait))

Function PECloseWindow(hPrintJob)
	local cDLL := GetProcAddress(hLibCRPE, "PECloseWindow", "Pascal",; 
						"void", "int")
RETURN (CallDLL(cDLL,hPrintJob))

******************************************
***** Print Destination Functions ********
******************************************
Function PESelectPrinter(hPrintJob,cDriver,cPrinter,cPort,cDevMode)
	local cDLL := GetProcAddress(hLibCRPE, "PESelectPrinter", "Pascal",; 
						"bool", "int,str,str,str,str")
RETURN (CallDLL(cDLL,hPrintJob,cDriver,cPrinter,cPort,cDevMode))

Function PEOutputToPrinter(hPrintJob,nCopies)
	local cDLL := GetProcAddress(hLibCRPE, "PEOutputToPrinter", "Pascal",; 
						"bool", "int,int")
RETURN (CallDLL(cDLL,hPrintJob,nCopies))

Function PEOutputToWindow(hPrintJob,cTitle,nLeft,nTop,nWidth,nHeight,;
								nStyle,hWndDlg)
	local cDLL := GetProcAddress(hLibCRPE, "PEOutputToWindow", "Pascal",; 
						"int","int,str,int,int,int,int,long,HWND")
RETURN (CallDLL(cDLL,hPrintJob,cTitle,nLeft,nTop,nWidth,nHeight,nStyle,;
					hWndDlg))

Function PEOutputToFile(hPrintJob,cFile,nType,cOptions)
	local cDLL := GetProcAddress(hLibCRPE, "PEOutputToFile", "Pascal",; 
						"bool", "int,str,int,str")
RETURN (CallDLL(cDLL,hPrintJob,cFile,nType,cOptions))

********************************
***** Sorting Functions ********
********************************
Function PEGetNSortFields(hPrintJob)
	local cDLL := GetProcAddress(hLibCRPE, "PEGetNSortFields", "Pascal",; 
						"int", "int")
RETURN (CallDLL(cDLL,hPrintJob))

Function PEGetNthSortField(hPrintJob,nField,cField,nFieldLen,nDirection)
	local cDLL := GetProcAddress(hLibCRPE, "PEGetNthSortFields", "Pascal",; 
						"bool", "int,int,str,int,int")
RETURN (CallDLL(cDLL,hPrintJob,nField,cField,nFieldLen,nDirection))

Function PESetNthSortField(hPrintJob,nField,cField,nDirection)
	local cDLL := GetProcAddress(hLibCRPE, "PESetNthSortFields", "Pascal",; 
						"bool", "int,int,str,int")
RETURN (CallDLL(cDLL,hPrintJob,nField,cField,nDirection))

Function PEDeleteNthSortField(hPrintJob,nField)
	local cDLL := GetProcAddress(hLibCRPE, "PEDeleteNthSortFields", "Pascal",; 
						"bool", "int,int")
RETURN (CallDLL(cDLL,hPrintJob,nField))

Function PEGetNGroupSortFields(hPrintJob)
	local cDLL := GetProcAddress(hLibCRPE, "PEGetNGroupSortFields", "Pascal",; 
						"int", "int")
RETURN (CallDLL(cDLL,hPrintJob))

Function PEGetNthGroupSortField(hPrintJob,nField,cField,nFieldLen,nDirection)
	local cDLL := GetProcAddress(hLibCRPE, "PEGetNthGroupSortField", "Pascal",; 
						"bool", "int,int,str,int,int")
RETURN (CallDLL(cDLL,hPrintJob,nField,cField,nFieldLen,nDirection))

Function PESetNthGroupSortField(hPrintJob,nField,cField,nDirection)
	local cDLL := GetProcAddress(hLibCRPE, "PESetNthGroupSortField", "Pascal",; 
						"bool", "int,int,str,int")
RETURN (CallDLL(cDLL,hPrintJob,nField,cField,nDirection))

Function PEDeleteNthGroupSortField(hPrintJob,nField)
	local cDLL := GetProcAddress(hLibCRPE, "PEDeleteNthGroupSortField",; 
						"Pascal", "bool", "int,int")
RETURN (CallDLL(cDLL,hPrintJob,nField))

********************************
***** Formula Functions ********
********************************
Function PEGetFormula(hPrintJob,cFormName,cFormula,nFormula)
	local cDLL := GetProcAddress(hLibCRPE, "PEGetFormula", "Pascal",; 
						"bool", "int,str,int,int")
RETURN (CallDLL(cDLL,hPrintJob,cFormName,cFormula,nFormula))

Function PESetFormula(hPrintJob,cFormName,cFormula)
	local cDLL := GetProcAddress(hLibCRPE, "PESetFormula", "Pascal",; 
						"bool", "int,str,str")
RETURN (CallDLL(cDLL,hPrintJob,cFormName,cFormula))

******************************************
***** Selection Formula Functions ********
******************************************
Function PEGetSelectionFormula(hPrintJob,cFormula,nFormula)
	local cDLL := GetProcAddress(hLibCRPE, "PEGetSelectionFormula",; 
						"Pascal", "bool", "int,int,int")
RETURN (CallDLL(cDLL,hPrintJob,cFormula,nFormula))

Function PESetSelectionFormula(hPrintJob,cFormula)
	local cDLL := GetProcAddress(hLibCRPE, "PESetSelectionFormula",; 
						"Pascal", "bool", "int,str")
RETURN (CallDLL(cDLL,hPrintJob,cFormula))

Function PEGetGroupSelectionFormula(hPrintJob,cFormula,nFormula)
	local cDLL := GetProcAddress(hLibCRPE, "PEGetGroupSelectionFormula",; 
						"Pascal", "bool", "int,int,int")
RETURN (CallDLL(cDLL,hPrintJob,cFormula,nFormula))

Function PESetGroupSelectionFormula(hPrintJob,cFormula)
	local cDLL := GetProcAddress(hLibCRPE, "PESetGroupSelectionFormula",; 
						"Pascal", "bool", "int,str")
RETURN (CallDLL(cDLL,hPrintJob,cFormula))

******************************************
***** Error Management Functions *********
******************************************
Function PEGetErrorCode(hPrintJob)
	local cDLL := GetProcAddress(hLibCRPE, "PEGetErrorCode", "Pascal",; 
						"int", "int")
RETURN (CallDLL(cDLL,hPrintJob))

Function PEGetErrorText(hPrintJob,hError,nError)
	local cDLL := GetProcAddress(hLibCRPE, "PEGetErrorText", "Pascal",; 
						"bool", "int,int,int")
RETURN (CallDLL(cDLL,hPrintJob,hError,nError))

******************************************
****** Miscellaneous Functions ***********
******************************************
Function PEGetHandleString(hText,cBuffer,nBuffer)
	local cDLL := GetProcAddress(hLibCRPE, "PEGetHandleString", "Pascal",; 
						"bool", "int,str,int")
RETURN (CallDLL(cDLL,hText,cBuffer,nBuffer))

******************************************
****** Print Format Management ***********
******************************************
Function PEGetReportTitle(hPrintJob,hTitle,nTitle)
	local cDLL := GetProcAddress(hLibCRPE, "PEGetReportTitle", "Pascal",; 
						"bool", "int,int,int")
RETURN (CallDLL(cDLL,hPrintJob,hTitle,nTitle))

Function PESetReportTitle(hPrintJob,cTitle)
	local cDLL := GetProcAddress(hLibCRPE, "PESetReportTitle", "Pascal",; 
						"bool", "int,str")
RETURN (CallDLL(cDLL,hPrintJob,cTitle))

Function PESetMargins(hPrintJob,nLeft,nRight,nTop,nBottom)
	local cDLL := GetProcAddress(hLibCRPE, "PESetMargins", "Pascal",; 
						"bool", "int,int,int,int,int")
RETURN (CallDLL(cDLL,hPrintJob,nLeft,nRight,nTop,nBottom))

Function PESetPrintOptions(hPrintJob,cOptions)
	local cDLL := GetProcAddress(hLibCRPE, "PESetPrintOptions", "Pascal",; 
						"bool", "int,str")
RETURN (CallDLL(cDLL,hPrintJob,cOptions))

Function PESetSectionFormat(hPrintJob,nCode,cOptions)
	local cDLL := GetProcAddress(hLibCRPE, "PESetSectionFormat", "Pascal",; 
						"bool", "int,int,str")
RETURN (CallDLL(cDLL,hPrintJob,nCode,cOptions))

Function PESetMinimumSectionHeight(hPrintJob,nCode,nHeight)
	local cDLL := GetProcAddress(hLibCRPE, "PESetMinimumSectionHeight",; 
						"Pascal", "bool", "int,int,int")
RETURN (CallDLL(cDLL,hPrintJob,nCode,nHeight))

Function PESetLineHeight(hPrintJob,nCode,nLine,nHeight,nAscent)
	local cDLL := GetProcAddress(hLibCRPE, "PESetLineHeight", "Pascal",; 
						"bool", "int,int,int,int,int")
RETURN (CallDLL(cDLL,hPrintJob,nCode,nLine,nHeight,nAscent))

Function PESetFont(hPrintJob,nCode,nScope,cFont,nFamily,nPitch,;
						nSet,nPoint,lItalic,lUnderline,lStrike,nWeight)
	local cDLL := GetProcAddress(hLibCRPE, "PESetFont", "Pascal", "bool",;
						  "int,int,int,str,int,int,int,int,bool,bool,bool,int")
RETURN (CallDLL(cDLL,hPrintJob,nCode,nScope,cFont,nFamily,nPitch,;
					nSet,nPoint,lItalic,lUnderline,lStrike,nWeight))

Function PESetNDetailCopies(hPrintJob,nCopies)
	local cDLL := GetProcAddress(hLibCRPE, "PESetNDetailCopies", "Pascal",; 
						"bool", "int,int")
RETURN (CallDLL(cDLL,hPrintJob,nCopies))

Function PESetPrintDate(hPrintJob,nYear,nMonth,nDay)   //***A Clipper date field is acceptable***
	local cDLL := GetProcAddress(hLibCRPE, "PESetNDetailCopies", "Pascal",; 
					"bool", "int,int,int,int")
	if valtype(nYear)=="D"
		nYear:=val(left(dtos(nYear),4))
		nMonth:=val(right(dtos(nYear),2))
		nDay:=val(left(dtoc(nYear),2))
	endif
RETURN (CallDLL(cDLL,hPrintJob,nYear,nMonth,nDay))

Function PEExportTo(hPrintJob,cOption)
	local cDLL := GetProcAddress(hLibCRPE, "PEExportTo", "Pascal",; 
						"bool", "int,str")
RETURN (CallDLL(cDLL,hPrintJob,cOption))

**************************************
***** Print Window Customization *****
**************************************
Function PEShowNextPage(hPrintJob)
	local cDLL := GetProcAddress(hLibCRPE, "PEShowNextPage", "Pascal",; 
						"bool", "int")
RETURN (CallDLL(cDLL,hPrintJob))

Function PEShowFirstPage(hPrintJob)
	local cDLL := GetProcAddress(hLibCRPE, "PEShowFirstPage", "Pascal",; 
						"bool", "int")
RETURN (CallDLL(cDLL,hPrintJob))

Function PEShowPreviousPage(hPrintJob)
	local cDLL := GetProcAddress(hLibCRPE, "PEShowPreviousPage", "Pascal",; 
						"bool", "int")
RETURN (CallDLL(cDLL,hPrintJob))

Function PEShowLastPage(hPrintJob)
	local cDLL := GetProcAddress(hLibCRPE, "PEShowLastPage", "Pascal",; 
						"bool", "int")
RETURN (CallDLL(cDLL,hPrintJob))

Function PEShowPrintControls(hPrintJob,lControls)
	local cDLL := GetProcAddress(hLibCRPE, "PEShowPrintControls", "Pascal",; 
						"bool", "int,bool")
RETURN (CallDLL(cDLL,hPrintJob,lControls))

*****************************
***** Server Management *****
*****************************
Function PELogOnServer(cName,cLogonInfo)
	local cDLL := GetProcAddress(hLibCRPE, "PELogOnServer", "Pascal",; 
						"bool", "str,str")
RETURN (CallDLL(cDLL,cName,cLogonInfo))

Function PELogOffServer(cName,cLogonInfo)
	local cDLL := GetProcAddress(hLibCRPE, "PELogOffServer", "Pascal",; 
						"bool", "str,str")
RETURN (CallDLL(cDLL,cName,cLogonInfo))

****************************
***** Table Management *****
****************************
Function PEGetNTables(hPrintJob)
	local cDLL := GetProcAddress(hLibCRPE, "PEGetNTables", "Pascal",; 
						"int", "int")
RETURN (CallDLL(cDLL,hPrintJob))

Function PEGetNthTableType(hPrintJob,nTable,cTable)
	local cDLL := GetProcAddress(hLibCRPE, "PEGetNthTableType", "Pascal",; 
						"bool", "int,int,str")
RETURN (CallDLL(cDLL,hPrintJob,nTable,cTable))

Function PEGetNthTableLogOnInfo(hPrintJob,nTable,cLogon)
	local cDLL := GetProcAddress(hLibCRPE, "PEGetNthTableLogOnInfo",; 
						"Pascal", "bool", "int,int,str")
RETURN (CallDLL(cDLL,hPrintJob,nTable,cLogon))

Function PESetNthTableLogOnInfo(hPrintJob,nTable,cLogon,lProp)
	local cDLL := GetProcAddress(hLibCRPE, "PESetNthTableLogOnInfo",; 
						"Pascal", "bool", "int,int,str,bool")
RETURN (CallDLL(cDLL,hPrintJob,nTable,cLogon,lProp))

Function PEGetNthTableLocation(hPrintJob,nTable,cLocation)
	local cDLL := GetProcAddress(hLibCRPE, "PEGetNthTableLocation", "Pascal",; 
						"bool", "int,int,str")
RETURN (CallDLL(cDLL,hPrintJob,nTable,cLocation))

Function PESetNthTableLocation(hPrintJob,nTable,cLocation)
	local cDLL := GetProcAddress(hLibCRPE, "PESetNthTableLocation", "Pascal",; 
						"bool", "int,int,str")
RETURN (CallDLL(cDLL,hPrintJob,nTable,cLocation))

Function PETestNthTableConnectivity(hPrintJob,nTable)
	local cDLL := GetProcAddress(hLibCRPE, "PETestNthTableConnectivity",; 
						"Pascal", "bool", "int,int")
RETURN (CallDLL(cDLL,hPrintJob,nTable))

***********************************
**** Pro Version Miscellaneous ****
***********************************
Function PESetGroupCondition(hPrintJob,nCode,cField,nCondition,nSort)
	local cDLL := GetProcAddress(hLibCRPE, "PESetGroupCondition", "Pascal",; 
						"bool", "int,int,str,int,int")
RETURN (CallDLL(cDLL,hPrintJob,nCode,cField,nCondition,nSort))
