; ------------------------------------------------------------------------
; File........:    CPUTEST.ASM
; Author(s)...:    Pepijn Smits, Eric Givler and Intel!
; Date........:    December 1991.
; Assembler...:    Tested with Tasm 1.0 or Masm 5.10, both work.
; Notes.......:    Clipper Assembly code to test for CPU
; ------------------------------------------------------------------------
; Syntax in Clipper 5.01 or Clipper Summer '87:
;      
;    CPU()    -->    nCPU
;
;    nCPU can be one of: 86,286,386 or 486
;
; Note: Use at own risk
; ------------------------------------------------------------------------
PUBLIC    CPU
EXTRN    __RETNI:FAR
CPUTEST  segment 'CODE'
ASSUME   cs:CPUTEST

CPU     PROC    FAR
        push    bp        ; Preserve return address.
        mov     bp,sp        ; Not required, but safer
        push    ds        ; Push'Em in any case (safer).
        push    es
        push    si
        push    di
        call    GETCPU        ; Test the CPU.
        pop     di
        pop     si
        pop     es
        pop     ds
        pop     bp
        push    ax        ; Return AX: CPU number
        call    __RETNI
        pop     ax
        ret
CPU     ENDP

; CPUTYPE.ASM - Returns Intel CPU type.  Adapted from
;               source code distributed to ISVs by Intel Corp.
; Call with:    N/A
; Returns:      AX = CPU type 
;                    0086 = 8086 or 8088
;                    0286 = 80286
;                    0386 = 80386SX or 80386DX
;                    0486 = 80486SX or 80486DX
; Destroys:     upper 16-bits of EAX and ECX on 386/486

getcpu  proc    near
        pushf                           ; save copy of flags and
        push    bx                      ; other affected registers
        push    cx
        pushf                           ; now try to clear bits 12-15
        pop     ax                      ; of CPU flags
        and     ax,0fffh
        push    ax                      ; set modified CPU flags
        popf
        pushf
        pop     ax                      ; get flags again
        and     ax,0f000h               ; if bits 12-15 are still       
        cmp     ax,0f000h               ; set, this is 8086/88
        jne     cpu1                    ; jump, not 8086/88
        mov     ax,0086                 ; set AX = 86/88 CPU type
        jmp     cpux                    ; and exit

cpu1:   or      ax,0f000h               ; must be 286 or later, 
        push    ax                      ; now try to set bits 12-15
        popf                            ; of CPU flags
        pushf
        pop     ax                      ; if bits 12-15 can't be
        and     ax,0f000h               ; set, this is a 286
        jnz     cpu2                    ; jump, not 80286
        mov     ax,286                  ; set AX = 286 CPU type
        jmp     cpux                    ; and exit


; We've got to enable 386 instructions here!
; Is OK: as it is at least a 386 when we get here!

.386c    

cpu2:   mov     bx,sp                   ; 386 or later, save SP
        and     sp,not 3                ; avoid stack alignment fault
        pushfd                          ; get value of EFLAGS
        pop     eax
        mov     ecx,eax                 ; save copy of EFLAGS 
        xor     eax,40000h              ; flip AC bit in EFLAGS
        push    eax                     ; try and force EFLAGS
        popfd
        pushfd                          ; get back EFLAGS value
        pop     eax
        mov     sp,bx                   ; restore old stack pointer
        xor     eax,ecx                 ; can AC bit be changed?
        jnz     cpu3                    ; no, jump, not a 386
        mov     ax,0386                 ; set AX = 386 CPU type
        jmp     cpux                    ; and exit

cpu3:   mov     ax,0486                 ; set AX = 486 CPU type 

cpux:   pop     cx                      ; restore registers
        pop     bx
        popf                            ; restore original flags

        ret
getcpu  endp

CPUTEST ends
        end
