*****
* CPDEMO.PRG
*
* Terry Hackett              Ph : 207-345-3679
* 10 Yates St., Apt. 1       CIS: 76662,2035
* Mechanic Falls, ME
* 04256
*
* Copyright (C) 1992 New England Medical Services
* ALL RIGHTS RESERVED.
*
* Seriously Generic Clipper demo for cparse() and ctoken().
*****

PRIVATE pText, pDelims, pMinStr, pStart, pMinAsc, pMaxAsc, ;
        tText, tDelims, tStart,  choi,   retword, wcnt, R, C

SET SCOREBOARD OFF
CLEAR SCREEN

@0,15 SAY "C Parser and Tokenizer Function Demo/Test Program"

pText    = "This is some sample text for testing the parser, cparse()."
pDelims  = " .,:;/-?0123456789()\!~@#$%^&*_+`=<>{}[]|" + '"'
pMinStr  = 3
pStart   = 1
pMinAsc  = 32
pMaxAsc  = 126

tText    = "This is some sample text for testing the tokenizer, ctoken()"
tDelims  = "ô"
tStart   = 1

choi     = "P"

DO WHILE choi $ "PT"
   *****
   * Pop multiple exploding menus with sound and animation.
   *****

   @2,20 SAY "Press 'P' to Thrash on the Parser"
   @3,20 SAY "Press 'T' to Thrash on the Tokenizer"
   @5,20 SAY "Your Selection? "

   choi = UPPER(CHR( INKEY(0) ))

   @1,0 CLEAR TO 24,79

   IF choi == "P"
      *-------------------------------*
      * CPARSE() PARSER TEST
      *-------------------------------*

      pText   = PAD( pText, 250 )
      pDelims = PAD( pDelims, 60 )

      *****
      * Offer some description and GET test params from user
      *****

      @1,30 SAY                          "C Parser Test"
      @3,0  SAY "Enter some test text to parse out  (GET scrolls to 250 chars)..."
      @4,0  GET pText PICT "@KS80"

      @6,2  SAY   "The default delimiters will return ONLY alpha or alpha with"
      @7,0  SAY "embedded apostrophes.  Initial string IS the default."
      @8,0  SAY "Enter the delimiter string, or leave blank for defaults..."
      @9,0  SAY "TRIM(" GET pDelims
      ?? " )"

      @11,2 SAY   "The minimum return string length defaults to 3, i.e. the "
      @12,0 SAY "parser will continue until a 3-char or longer word is found."
      @13,0 SAY "Enter the minimum return string length: " GET pMinStr PICT "999" VALID (pMinStr > 0)

      @15,2 SAY   "The parser should be initialized whenever starting a new block"
      @16,0 SAY "of text.  It will default to start at the first char.  This "
      @17,0 SAY "feature can also be used to jump around a block of text without"
      @18,0 SAY "parsing every character.  Also, minimum and maximum ASCII limits"
      @19,0 SAY "can be set."
      @20,0 SAY "Enter parser starting position:      Min ASCII:      Max ASCII:"

      @20,32 GET pStart  PICT "999" RANGE 0, 999
      @20,48 GET pMinAsc PICT "999"
      @20,64 GET pMaxAsc PICT "999"

      READ
      IF LASTKEY() == 27
         EXIT
      ENDIF

      pDelims = TRIM(pDelims)
      pText   = TRIM(pText)

      @5,0 CLEAR TO 24,79
      @5,0 SAY "1234567890123456789012345678901234567890123456789012345678901234567890123456789"
      R = 6

      *****
      * Init parser starting position and ASCII limits.
      *****
      InitCparse(pStart, pMinAsc, pMaxAsc)

      DO WHILE .T.
         *****
         * Get first parsed word from cparse().
         *****
         retword = cparse( @pText, @pDelims, pMinstr )

         @R,0 SAY "->"+retword+"<-"

         *****
         * Demo the position functions, used for SUBS(), STUFF(), etc.
         *****
         @R,25 SAY "Start Pos:"  + LTRIM(STR( cp_StPos()  ))
         @R,40 SAY "Word Start:" + LTRIM(STR( cp_StWord() ))
         @R,58 SAY "End Pos:"    + LTRIM(STR( cp_EndPos() ))

         *****
         * Check ending-position tracker for eostr reset to 1.
         * Note - May be FASTER to check for null return for cparse().
         *        Null "" return also means cparse() hit eostr - exit loop.
         *        Example: if retword == ""
         *****
         IF cp_EndPos() == 1
            * Hit end of string and auto-reset to 1st char.
            @R+1,55 SAY "Note Reset"
            ?
            ? "This loop exits on RESET, Press a Key..."
            INKEY(0)
            EXIT                       && EXIT ------>
         ENDIF

         INKEY(0)

         R = R+1                       && Don't ya hate this syntax....

         IF R > 24                     && Just clear screen and start at the
            R = 6                      && top row again if still more words...
            @6,0 CLEAR TO 24,79
         ENDIF
      ENDDO

      *****
      * Parsed entire text.  Now create bigger blob of text for a timer test.
      * Change replicate(10) to 100 if you really want to beat up on it.
      *****

      SET CURSOR OFF
      @5,0 CLEAR TO 24,79

      @6,0 SAY "Now for the fun part - speed testing.  The test text entered"
      @7,0 SAY "will be REPLICATEd 10 times.    Press a key when ready..."

      INKEY(0)

      block = REPLICATE( pText, 10 )
      wcnt  = 0

      @9,0  SAY "Time test for " + LTRIM(STR(LEN(block))) + " characters..."
      @11,0 SAY ">"

      *****
      * ALWAYS reset parser for a new block of text.  Maintain ASCII limits.
      *****
      InitCparse(1, pMinAsc, pMaxAsc)

      @13,0 SAY TIME() + " ...Start"
      DO WHILE .T.
         retword = cparse( @block, @pDelims, pMinStr )

         *****
         * Note using null "" test to exit this loop.
         *****
         IF retword == ""
            EXIT                       && EXIT ------>
         ENDIF

         wcnt = wcnt + 1                               && Count total words.
         @11,1 SAY retword + "                   "     && Spaces just to clear.
      ENDDO

      @14,0 SAY TIME() + " ...Done  (Note: faster without @..SAY display)"

      @15,0 SAY LTRIM(STR(wcnt)) + " words."
      INKEY(0)
      SET CURSOR ON

   ELSEIF choi == "T"
      *-------------------------------*
      * CTOKEN() TOKENIZER TEST
      *-------------------------------*
      tText   = PAD( tText, 250 )
      tDelims = PAD( tDelims, 2 )

      *****
      * Offer some description and GET test params from user
      *****

      @1,28 SAY                         "C Tokenizer Test"
      @3,0  SAY "Enter some test text to extract tokens from (GET scrolls to 250 chars)..."
      @4,0  GET tText PICT "@KS80"

      @6,2  SAY   "The default delimiters for the tokenizer are 'ô', chr(195)"
      @7,0  SAY "for the L delim and chr(180) for the R delim.  Must be (at least) 2 chars."
      @8,0  SAY "Enter the delimiter string, or leave blank for defaults..."
      @9,5  GET tDelims

      @11,2 SAY   "There is no minimum return length for the tokenizer, and"
      @12,0 SAY "any ASCII char is valid."

      @15,2 SAY   "The tokenizer should be initialized whenever starting a new block"
      @16,0 SAY "of text.  It will default to start at the first char.  This "
      @17,0 SAY "feature can also be used to jump around a block of text without"
      @18,0 SAY "parsing every character."
      @19,0 SAY "Enter tokenizer starting position:" GET tStart PICT "999" VALID (tStart > 0)

      READ
      IF LASTKEY() == 27
         EXIT
      ENDIF

      tDelims = ALLTRIM(tDelims)
      tText   = ALLTRIM(tText)

      *****
      * Init tokenizer starting position for new block of text.
      *****
      InitCtoken(tStart)

      @5,0 CLEAR TO 24,79
      @5,0 SAY "1234567890123456789012345678901234567890123456789012345678901234567890123456789"

      R = 6
      DO WHILE .T.
         *****
         * Get first parsed token from ctoken().
         *****
         retword = ctoken( @tText, tDelims )

         @R,0 SAY "->"+retword+"<-"

         *****
         * Demo the position functions, used for SUBS(), STUFF(), etc.
         *****
         @R,25 SAY "Start Pos:"   + LTRIM(STR( ct_StPos()   ))
         @R,40 SAY "Token Start:" + LTRIM(STR( ct_StToken() ))
         @R,58 SAY "End Pos:"     + LTRIM(STR( ct_EndPos()  ))

         *****
         * Check ending-position tracker for eostr reset to 1.
         * Note - May be FASTER to check for null "" return.
         *        However, ctoken() can legitimately return nulls.  Beware
         *        unless you KNOW the input text won't have 2 delims together.
         *****
         IF ct_EndPos() == 1
            * Hit end of string and auto-reset to 1st char.
            @R+1,55 SAY "Note Reset"
            ?
            ? "This loop exits on RESET, Press a Key..."
            INKEY(0)
            EXIT                       && EXIT ------>
         ENDIF

         R = R+1

         INKEY(0)

         IF R > 24
            R = 6
            @6,0 CLEAR TO 24,79
         ENDIF
      ENDDO

      *****
      * Parsed entire text.  Now create bigger blob of text for a timer test.
      * Change replicate(10) to 100 if you really want to beat up on it.
      *****

      SET CURSOR OFF
      @5,0 CLEAR TO 24,79

      @6,0 SAY "Now for the fun part - speed testing.  The test text entered"
      @7,0 SAY "will be REPLICATEd 10 times.    Press a key when ready..."
      INKEY(0)

      block = REPLICATE( tText, 10 )
      wcnt  = 0
      @9,0  SAY "Time test for " + LTRIM(STR(LEN(block))) + " characters..."
      @11,0 SAY ">"

      *****
      * ALWAYS reset ctoken() for a new block of text.
      *****
      InitCtoken(1)

      @13,0 SAY TIME() + " ...Start"
      DO WHILE .T.
         retword = ctoken( @block, tDelims )

         IF ct_EndPos() == 1
            EXIT                       && EXIT ------>
         ENDIF

         wcnt = wcnt + 1
         @11,1 SAY retword + "                   "     && Spaces just to clear.
      ENDDO
      @14,0 SAY TIME() + " ...Done  (Note: faster without @..SAY display)"

      @15,0 SAY LTRIM(STR(wcnt)) + " tokens."
      INKEY(0)

      SET CURSOR ON
   ENDIF

   @1,0 CLEAR TO 24,79
ENDDO

?
? "Crash test: cparse() missing all parameters"
cparse()
?
? "Didn't crash cparse() if we got this far..."
?
?
? "Crash test: ctoken() missing all parameters"
ctoken()
?
? "Didn't crash ctoken() if we got this far..."
?
? "Last cparse() test...  Strike a key..."
?
INKEY(0)
? "(Slowed Down)"
?

byebye = "Have fun and HAPPY CLIPPING"

InitCparse(1)
retword = cparse(@byebye)

DO WHILE !(retword == "")

   ?? retword + " "

   *** Slowdown delay.
   INKEY(.01)
   ***

   retword = cparse( @byebye )
ENDDO
?


