*****
* CXDEMO.PRG
*
* Terry Hackett              Ph : 207-345-3679
* 10 Yates St., Apt. 1       CIS: 76662,2035
* Mechanic Falls, ME
* 04256
*
* Copyright (C) 1992 New England Medical Services
* ALL RIGHTS RESERVED.
*
* Seriously Generic Clipper demo for cxtrac().
*****

*****
* cxtrac( @cTxt, [cDelims] )
*****

PRIVATE cTxt, cDelims, nStart, retword, R, C

SET SCOREBOARD OFF
CLEAR SCREEN

@0,15 SAY "Cxtrac() - Parser and Tokenizer Demo/Test Program"

cTxt     = "This,is,some,sample,text,for,,testing,the,,,parser,cxtrac()"
cDelims  = ".,:;/-()\'" + `{}[]|"'
nStart   = 1

DO WHILE .T.
   @1,0 CLEAR TO 24,79

   cTxt    = PAD( cTxt, 250 )
   cDelims = PAD( cDelims, 60 )

   *****
   * Offer some description and GET test params from user
   *****

   @1,30 SAY                          "C Extractor Test"
   @3,3  SAY    "Enter some test text to parse out  (GET scrolls to 250 chars)..."
   @4,0  GET cTxt PICT "@S80"

   @7,3  SAY    "Initial string IS the default delimiter string.  Note any 2 delims"
   @8,0  SAY "together will return a null '' string.  Enter the delimiter string..."
   @9,0  SAY "TRIM(" GET cDelims
   ?? " )"

   @11,3 SAY    "The parser should be initialized whenever starting a new block"
   @12,0 SAY "of text.  It will default to start at the first char."
   @13,0 SAY "Enter parser starting position:"

   @13,32 GET nStart PICT "999"

   READ
   IF LASTKEY() == 27
      EXIT                             && EXIT ------>
   ENDIF

   cDelims = TRIM(cDelims)
   cTxt    = TRIM(cTxt)

   @5,0 CLEAR TO 24,79
   @5,0 SAY "1234567890123456789012345678901234567890123456789012345678901234567890123456789"
   R = 6

   *****
   * Init parser starting position.
   *****
   InitCxtrac(nStart)

   DO WHILE .T.
      *****
      * Get first parsed word from cxtrac().
      *****
      retword = cxtrac( @cTxt, @cDelims )

      @R,0 SAY "->"+retword+"<-"

      *****
      * Demo the position functions, used for SUBS(), STUFF(), etc.
      *****
      @R,25 SAY "Start Pos:"    + LTRIM(STR( cx_StPos()  ))
      @R,40 SAY "End Pos:"      + LTRIM(STR( cx_EndPos() ))
      @R,54 SAY "Total Tokens:" + LTRIM(STR( cx_WrdCnt() ))


      *****
      * Check ending-position tracker for eostr reset to 1.
      *****
      IF cx_EndPos() == 1
         * Hit end of string and auto-reset to 1st char.
         @R+1,37 SAY "Note Reset"
         ?
         ? "This loop exits on RESET, Press a Key..."
         INKEY(0)
         EXIT                          && EXIT ------>
      ENDIF

      R = R+1

      INKEY(0)

      IF R > 24
         R = 6
         @6,0 CLEAR TO 24,79
      ENDIF

   ENDDO

   *****
   * Parsed entire text.  Now create bigger blob of text for a timer test.
   * Change replicate(10) to 100 if you really want to beat up on it.
   *****

   SET CURSOR OFF
   @5,0 CLEAR TO 24,79

   @6,0 SAY "Now for the fun part - speed testing.  The test text entered"
   @7,0 SAY "will be REPLICATEd 10 times.    Press a key when ready..."

   INKEY(0)

   block = REPLICATE( cTxt, 10 )

   @9,0  SAY "Time test for " + LTRIM(STR(LEN(block))) + " characters..."
   @11,0 SAY ">"

   *****
   * ALWAYS reset parser for a new block of text.
   *****
   InitCxtrac(1)

   @13,0 SAY TIME() + " ...Start"

   retword = cxtrac( @block, @cDelims )

   DO WHILE cx_EndPos() != 1                        && Exit on a reset.
      @11,1 SAY retword + "                   "     && Spaces just to clear.

      retword = cxtrac( @block, @cDelims )
   ENDDO

   @14,0 SAY TIME() + " ...Done  (Note: faster without @..SAY display)"

   @15,0 SAY LTRIM(STR( cx_WrdCnt() )) + " tokens."

   INKEY(0)
   SET CURSOR ON
ENDDO

?
? "Crash test: cxtrac() missing all parameters"
cxtrac()
?
? "Didn't crash cxtrac() if we got this far..."
?
? "Last cxtrac() test...  Strike a key..."
?
INKEY(0)
? "(Slowed Down)"
?

byebye = "Have fun and HAPPY CLIPPING"

*****
* Using default init position to 1
*****
InitCxtrac()
retword = cxtrac(@byebye, " ")

DO WHILE cx_EndPos() != 1

   ?? retword + " "

   *** Slowdown delay.
   INKEY(.01)
   ***

   retword = cxtrac( @byebye, " " )
ENDDO
?

