******************************************************************
* This program allows you to convert any existing database file
* to one which includes a soundex field. The new database file is
* indexed on the soundex field to facilitate phonetic searches of
* alphabetic fields when other search methods have failed to     
* locate records. Try this program using the DEMO.dbf.
*                        Brian Corll 2/20/87       
******************************************************************

* Get name of file to convert

clear
set talk on
set conf on
set echo off
set scor on
set stat on
set safe off
load soundex
filename=space(8)
do while filename=space(8)
@ 1,0 say "Enter name of dBASE III Plus DBF to be converted:";
 get filename pict "!!!!!!!!"
read
filename=trim(filename)
if .not. file('&filename..dbf')
    ? chr(7)
    @ 2,0 say "INCORRECT FILE NAME! TRY AGAIN"
    wait "Press any key to start over."
    loop
else
exit
endif
enddo
* Open database file
use &filename
copy to temp                   && copy all records to a temporary file.
copy stru exte to convert      && copy the database structure 
use convert
appe blan                      && add the SOUNDEX field to the structure
repl field_name with "SOUNDEX"
repl field_type with "C"
repl field_len with 4
clos data
crea &filename from convert    && recreate the original DBF with new structure
use &filename
append from temp               && copy all records back from the temp file
clos data
clear
use convert
disp all field_name
fldnum=0
* Choose the alphabetic field to convert to SOUNDEX code
@ 24,0 say "Enter number of field to index on sound:";
 get fldnum picture "@Z 999"
read
fldnum=int(fldnum)
go fldnum
fldnam=field_name
clos data
use &filename
go top
* Do the conversion
do while .not. eof()
    sdxcode=&fldnam
    call soundex with sdxcode
    repl soundex with sdxcode
    skip
enddo
* Create the index
index on soundex to soundex
clos data
return
* To use the SOUNDEX index, create a program which does a find based
* on the key alphabetic field desired. If no record is found, use  
* the SOUNDEX code of the search string to find all phonetically
* similar records. DEMO.prg is a sample of such a program.
****************************************************************** 
    