* COLORSET.PRG					20-05-1995	A.A. Hogendorf
*								CIS 100105,3203
*
* Developed for CLIPPER 5.01 (c) Computer Associates
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Below you will find my little program for changing screen colors. See also
* COLDEMO.PRG that demonstrates it. I can't take any responsibilty for these
* programs. Use them on your own risk. Hereby I drop it into the Public Domain
* and hope you have some use for it. An E-mail with any comments, suggestions,
* improvements etc. will be appreciated. 
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* The theory of changing colors with SAVESCREEN() and RESTSCREEN() is simple:
*
*   1. Save a screen area with SAVESCREEN() in a variable
*   2. Replace the color attributes in the variable with another value
*   3. Rewrite the screen area with RESTSCREEN() and the changed attributes
*
* Practice is a little more complicated. Normally, one would use characters to
* denote a foreground/background combination, e.g. "GR+/R" would mean yellow
* characters on a red background. Replacing the color attribute in a string
* saved by SAVESCREEN() requires numeric translation. It is not that compli-
* cated though, because each color valid in CLIPPER has it's own value:
*
*	Char		Num		Description
*	 N		 0		Black
*	 B		 1		Blue
*	 G		 2		Green
*	 BG		 3		Cyan
*	 R		 4		Red
*	 RB		 5		Magenta
*	 GR		 6		Brown
*	 W		 7		Lightgrey
*	 N+		 8		Darkgrey
*	 B+		 9		Lightblue
*	 G+		10		Lightgreen
*	 BG+		11		Lightcyan
*	 R+		12		Lightred
*	 RB+		13		Lightmagenta
*	 GR+		14		Yellow
*	 W+		15		White
*
* All we have to do is translate a character color specification to numeric and
* replace it. A byte representing the color combination of fore- and background
* is defined as nForeGround+nBackground*16. Suppose we want to change to colors
* GR+/R (yellow on red), the numeric version would be 14+4*16=78.
* Now, what does the saved screen area contain? It's really simple. The text
* "Hello" looks byte-wise like this:
*
* 	72 30 101 30 108 30 108 30 111 30
*	H   |  e   |  l   |  l   |  o   |
*           |______|______|______|______|_______ yellow on blue
*					         = GR+/B
*						 = 14+1*16
*
* Replace every second character with 78 and you have yellow on red! Remember
* though that we are working with a string here, so you'll have to replace the
* color attribute with the character value of 78, so CHR(78).
* By default, the background can only be one of the first 8 colors (0-7). In
* numeric format this means that the background will be set with values below
* 128 (15+7*16). Above this value, the foreground will blink. To allow all
* 16 colors for the background as well, we must set the blinking off by using
* SETBLINK(.F.). Alas, we are not able to use a blinking foreground, but the
* screen will look prettier with more color combinations.
* So, I am happy with the fast SAVESCREEN() and RESTSCREEN() functions. But
* then, there is another speed problem: replacing the color attributes in the
* string variale saved by SAVESCREEN() can be a tedious process because every
* second byte has to be replaced. A classic method for this is the FOR-NEXT
* loop:
*
*	for i:=1 to len(cSavedScreen) step 2 --- change every second attrib
*		cNewScreen:=cNewScreen+substr(cSavedScreen,i,1)+;
*						|	cNewColorAttrib)
*	next					|	      |
*					        |             |
*					    character  color attribute
*
* This takes 'ages' to complete and kills the speed benefits of SAVESCREEN()
* and RESTSCREEN(). With larger screen areas it slows down to a crawl.
* There are however fast string replace routines like STUFF() and STRTRAN().
* The last one is preferable because it can replace all specified bytes in a
* string automatically. With STRTRAN() we have speed, but we also introduce
* another problem. Consider the following string, saved by SAVESCREEN():
*
*	
* 	80 80  65 80  80 80  69 80  82 80
*	P   |  A   |  P   |  E   |  R   |
*           |______|______|______|______|_______ black on cyan
*					         = N/RB
*						 = 0+5*16
*
* With STRTRAN() we would look for color attribute CHR(80) and replace it
* with something else and then restore it to screen:
*
*	cNewScreen:=savescreen(nTop,nLeft,nBottom,nRight)
*	cNewScreen:=strtran(cOldScreen,chr(80),chr(30))
*				         |        |
*                                   old attrib  new attrib
*
*	restscreen(nTop,nLeft,nBottom,nRight,cNewScreen)
*
* It's pretty fast as expected, but it replaces ALL CHR(80)'s including the two
* P's of 'PAPER'! The STRTRAN() function is fast indeed, mainly because it
* makes no distinction between text characters and color attributes.
*
* <to be continued>
*
* The program has one limitation: multiple colors in a single text line are
* not handled. With some more programming this can be done easily, though it
* it will decrease speed as each color attribute has to be evaluated.
* 
* Syntax:
*		ColorSet(nTop,nLeft,cColor) --> cString
*
* Input:
*
*	nTop		: top row    of screen area to be changed
*	nLeft		: top col	,,	  	,,
*	cColor		: new colorset in the form of e.g. "G/R" 
*
* Output:
*	Screen area with new foreground/background colors
*
/*****************************************************************************/
function ColorSet(nTop,nLeft,aText,cColor)

local i:=0

aeval(aText,{|cText| inkey(0),i++,setpos(nTop+i-1,nLeft),dispout(cText,cColor)})

return NIL
/*****************************************************************************/
