10  '**************************************************************************
20  '*****                 CODE 3-of-9 BAR CODE  GENERATOR                *****
30  '*****                 *******************************                *****
40  '*****      This program will generate standard 3-of-9 bar code       *****
50  '*****      on any dot matrix printer which is compatable with        *****
60  '*****      an Epson or IBM graphics printer.                         *****
70  '*****                 ******************************                 *****
80  '*****                      -  SPECIFICATIONS -                       *****
90  '**                                                                      **
100 '**                         W                                 N          **
110 '**                |  Nominal Width  | Nominal Width  | Nominal Ratio    **
120 '**     Density    |       of        |      of        |      of          **
130 '**   (Characters/ | Narrow Bars and | Wide Bars and  | Wide to Narrow   **
140 '**      Inch)     | Spaces (Inches) | Spaces (Inches)| Element Width    **
150 '**   -------------+-----------------+----------------+----------------  **
160 '**      5.730     |     0.0125      |     0.0315     |      2.52        **
170 '**   -------------+-----------------+----------------+----------------  **
180 '**                                                                      **
190 '*****                 ******************************                 *****
200 '*****  Code 3-of-9 was developed in 1974 by Dr. David C. Allais of   *****
210 '*****  Interface Mechanisms, Inc.  It has been adopted as the        *****
220 '*****  standard bar code symbology of the Department of Defence      *****
230 '*****  (MIL-STD-1189) and is the most widely used alphanumeric bar   *****
240 '*****  code in use.  Code 3-of-9 is so called because the original   *****
250 '*****  concept provided for 39 data characters.  The name also       *****
260 '*****  describes the structure of the code which has 3 wide elements *****
270 '*****  out of a total of 9.                                          *****
280 '*****                                                                *****
290 '*****  For best results use only even numbered values for height     *****
300 '*****  and use a height which is approx 15% of the total code        *****
310 '*****  length.                                                       *****
320 '*****                                                                *****
330 '*****  This program was written solely for information purposes to   *****
340 '*****  demonstrate the structure of code 3-of-9.  The author is      *****
350 '*****  not responsible for any damages incurred through the use of   *****
360 '*****  this program.                                                 *****
370 '*****                                                                *****
380 '*****                           Bill Wood  Milwaukee, WI   05/18/85  *****
390 '**************************************************************************
400 '
410  DIM X(30),M(30),P$(30),A$(30)
420  '
430  '*****  generate data entry screen
440  '
450  KEY OFF
460  CLS
470  COLOR 7
480  PRINT "ͻ"
490  FOR P=1 TO 3
500  PRINT "                                     "
510  NEXT P
520  PRINT "͹
530  FOR P=1 TO 5
540  PRINT "                                     "
550  NEXT P
560  PRINT "ͼ"
570  '
580  '*****  display menu and get input from user
590  '
600  LOCATE 3,5  :COLOR 4 :PRINT "CODE 3-OF-9 BAR CODE GENERATOR"
610  LOCATE 6,3  :COLOR 6 :PRINT "1  Print Data from CONSOLE"
620  LOCATE 7,3  :COLOR 6 :PRINT "2  Print Data from FILE   "
630  LOCATE 8,3  :COLOR 6 :PRINT "3  ADD Data to FILE  "
640  LOCATE 9,3  :COLOR 6 :PRINT "Q  QUIT              "
650  LOCATE 10,10:COLOR 6 :PRINT "==>"
660  LOCATE 10,14:COLOR 10:INPUT " ",SELECT$
670  IF SELECT$="Q" THEN GOTO 1900
680  GOSUB 2220
690  IF SELECT$="1" THEN GOTO 730
700  IF SELECT$="2" THEN GOTO 740
710  IF SELECT$="3" THEN GOTO 750
720  GOTO 450
730  GOSUB 1950 :GOSUB 790 :GOTO 450
740  OPEN "CODE39.DAT" FOR INPUT  AS #1 :GOTO 2030
750  OPEN "CODE39.DAT" FOR APPEND AS #1 :GOTO 2130
760  '
770  '*****  add start and stop characters to user message (*)
780  '
790  MSG$="*"+MSG$+"*" :S$=""
800  '
810  '*****  define print head pins to fire
820  '
830   NS$=CHR$(0)+CHR$(0)
840   WS$=CHR$(0)+CHR$(0)+CHR$(0)+CHR$(0)
850   NB$=CHR$(255)
860   WB$=CHR$(255)+CHR$(255)+CHR$(255)
870  '
880  '*****  decode message into bar code
890  '
900  L=LEN(MSG$)
910  FOR X=1 TO L
920  TEST$=MID$(MSG$,X,1)
930   IF TEST$="1" THEN L$=WB$+NS$+NB$+WS$+NB$+NS$+NB$+NS$+WB$ :GOTO 1430
940   IF TEST$="2" THEN L$=NB$+NS$+WB$+WS$+NB$+NS$+NB$+NS$+WB$ :GOTO 1430
950   IF TEST$="3" THEN L$=WB$+NS$+WB$+WS$+NB$+NS$+NB$+NS$+NB$ :GOTO 1430
960   IF TEST$="4" THEN L$=NB$+NS$+NB$+WS$+WB$+NS$+NB$+NS$+WB$ :GOTO 1430
970   IF TEST$="5" THEN L$=WB$+NS$+NB$+WS$+WB$+NS$+NB$+NS$+NB$ :GOTO 1430
980   IF TEST$="6" THEN L$=NB$+NS$+WB$+WS$+WB$+NS$+NB$+NS$+NB$ :GOTO 1430
990   IF TEST$="7" THEN L$=NB$+NS$+NB$+WS$+NB$+NS$+WB$+NS$+WB$ :GOTO 1430
1000  IF TEST$="8" THEN L$=WB$+NS$+NB$+WS$+NB$+NS$+WB$+NS$+NB$ :GOTO 1430
1010  IF TEST$="9" THEN L$=NB$+NS$+WB$+WS$+NB$+NS$+WB$+NS$+NB$ :GOTO 1430
1020  IF TEST$="0" THEN L$=NB$+NS$+NB$+WS$+WB$+NS$+WB$+NS$+NB$ :GOTO 1430
1030  IF TEST$="A" THEN L$=WB$+NS$+NB$+NS$+NB$+WS$+NB$+NS$+WB$ :GOTO 1430
1040  IF TEST$="B" THEN L$=NB$+NS$+WB$+NS$+NB$+WS$+NB$+NS$+WB$ :GOTO 1430
1050  IF TEST$="C" THEN L$=WB$+NS$+WB$+NS$+NB$+WS$+NB$+NS$+NB$ :GOTO 1430
1060  IF TEST$="D" THEN L$=NB$+NS$+NB$+NS$+WB$+WS$+NB$+NS$+WB$ :GOTO 1430
1070  IF TEST$="E" THEN L$=WB$+NS$+NB$+NS$+WB$+WS$+NB$+NS$+NB$ :GOTO 1430
1080  IF TEST$="F" THEN L$=NB$+NS$+WB$+NS$+WB$+WS$+NB$+NS$+NB$ :GOTO 1430
1090  IF TEST$="G" THEN L$=NB$+NS$+NB$+NS$+NB$+WS$+WB$+NS$+WB$ :GOTO 1430
1100  IF TEST$="H" THEN L$=WB$+NS$+NB$+NS$+NB$+WS$+WB$+NS$+NB$ :GOTO 1430
1110  IF TEST$="I" THEN L$=NB$+NS$+WB$+NS$+NB$+WS$+WB$+NS$+NB$ :GOTO 1430
1120  IF TEST$="J" THEN L$=NB$+NS$+NB$+NS$+WB$+WS$+WB$+NS$+NB$ :GOTO 1430
1130  IF TEST$="K" THEN L$=WB$+NS$+NB$+NS$+NB$+NS$+NB$+WS$+WB$ :GOTO 1430
1140  IF TEST$="L" THEN L$=NB$+NS$+WB$+NS$+NB$+NS$+NB$+WS$+WB$ :GOTO 1430
1150  IF TEST$="M" THEN L$=WB$+NS$+WB$+NS$+NB$+NS$+NB$+WS$+NB$ :GOTO 1430
1160  IF TEST$="N" THEN L$=NB$+NS$+NB$+NS$+WB$+NS$+NB$+WS$+WB$ :GOTO 1430
1170  IF TEST$="O" THEN L$=WB$+NS$+NB$+NS$+WB$+NS$+NB$+WS$+NB$ :GOTO 1430
1180  IF TEST$="P" THEN L$=NB$+NS$+WB$+NS$+WB$+NS$+NB$+WS$+NB$ :GOTO 1430
1190  IF TEST$="Q" THEN L$=NB$+NS$+NB$+NS$+NB$+NS$+WB$+WS$+WB$ :GOTO 1430
1200  IF TEST$="R" THEN L$=WB$+NS$+NB$+NS$+NB$+NS$+WB$+WS$+NB$ :GOTO 1430
1210  IF TEST$="S" THEN L$=NB$+NS$+WB$+NS$+NB$+NS$+WB$+WS$+NB$ :GOTO 1430
1220  IF TEST$="T" THEN L$=NB$+NS$+NB$+NS$+WB$+NS$+WB$+WS$+NB$ :GOTO 1430
1230  IF TEST$="U" THEN L$=WB$+WS$+NB$+NS$+NB$+NS$+NB$+NS$+WB$ :GOTO 1430
1240  IF TEST$="V" THEN L$=NB$+WS$+WB$+NS$+NB$+NS$+NB$+NS$+WB$ :GOTO 1430
1250  IF TEST$="W" THEN L$=WB$+WS$+WB$+NS$+NB$+NS$+NB$+NS$+NB$ :GOTO 1430
1260  IF TEST$="X" THEN L$=NB$+WS$+NB$+NS$+WB$+NS$+NB$+NS$+WB$ :GOTO 1430
1270  IF TEST$="Y" THEN L$=WB$+WS$+NB$+NS$+WB$+NS$+NB$+NS$+NB$ :GOTO 1430
1280  IF TEST$="Z" THEN L$=NB$+WS$+WB$+NS$+WB$+NS$+NB$+NS$+NB$ :GOTO 1430
1290  IF TEST$="-" THEN L$=NB$+WS$+NB$+NS$+NB$+NS$+WB$+NS$+WB$ :GOTO 1430
1300  IF TEST$="." THEN L$=WB$+WS$+NB$+NS$+NB$+NS$+WB$+NS$+NB$ :GOTO 1430
1310  IF TEST$=" " THEN L$=NB$+WS$+WB$+NS$+NB$+NS$+WB$+NS$+NB$ :GOTO 1430
1320  IF TEST$="*" THEN L$=NB$+WS$+NB$+NS$+WB$+NS$+WB$+NS$+NB$ :GOTO 1430
1330  IF TEST$="$" THEN L$=NB$+WS$+NB$+WS$+NB$+WS$+NB$+NS$+NB$ :GOTO 1430
1340  IF TEST$="/" THEN L$=NB$+WS$+NB$+WS$+NB$+NS$+NB$+WS$+NB$ :GOTO 1430
1350  IF TEST$="+" THEN L$=NB$+WS$+NB$+NS$+NB$+WS$+NB$+WS$+NB$ :GOTO 1430
1360  IF TEST$="%" THEN L$=NB$+NS$+NB$+WS$+NB$+WS$+NB$+WS$+NB$ :GOTO 1430
1370  '
1380  '*****  print error message if input is invalid
1390  '
1400  LOCATE 7,3  :COLOR 11 :PRINT "   INVALID CHARACTER DETECTED!!!    "
1410  LOCATE 9,3  :COLOR 28 :PRINT "                ";TEST$;"      "
1420  LOCATE 15,8 :COLOR 14 :PRINT "*** PROCESSING ABORTED ***":GOTO 1900
1430  P$(X)=L$
1440  '
1450  '*****  develop human readable text to be printed under bar code
1460  '
1470   A$(X)=TEST$
1480   IF X=15 OR X=25 THEN GOTO 1500
1490   IF X>2 AND (X MOD 2)>0 THEN S$=S$+" "
1500  NEXT X
1510  '
1520  '*****  set printer to 2/216 lines per inch
1530  '
1540  WIDTH "LPT1:",255
1550  LPRINT CHR$(27);CHR$(51);CHR$(2);
1560  '
1570  '*****  calculate N1 and N2 values for dot graphics command
1580  '
1590  COLS=21
1600  N1=COLS MOD 256
1610  N2=FIX(COLS/256)
1620  '
1630  '*****  print each character of bar code
1640  '
1650  LOCATE 7,3 :COLOR 1 :PRINT "PRINTING-                           "
1660  HIGH=ABS(HIGH):IF HIGH=0 THEN HIGH=2
1670  FOR H=1 TO HIGH
1680  FOR N=L TO 1 STEP -1
1690    LOCATE 7,(N+12) :PRINT " "
1700  NEXT N
1710    FOR M=1 TO L
1720     LOCATE 7,(M+11) :COLOR 11 :PRINT A$(M)
1730     LPRINT CHR$(27);CHR$(76);CHR$(N1);CHR$(N2);P$(M);NS$;
1740    NEXT M
1750  '
1760  '*****  set printer to 19/216 lines per inch every other line
1770  '
1780   IF (H MOD 2)=0 THEN LPRINT CHR$(27);CHR$(74);CHR$(19);
1790   LPRINT
1800   LOCATE 9,3  :COLOR 1  :PRINT "    PASS-"
1810   LOCATE 9,12 :COLOR 11 :PRINT H
1820   LOCATE 9,15 :COLOR 1  :PRINT " COMPLETE           "
1830  NEXT H
1840  '
1850  '*****  reset printer to default and print human readable text
1860  '
1870  LPRINT CHR$(27)"@"
1880  LPRINT S$;MSG$
1890 RETURN
1900  LOCATE 20,1 :COLOR 7,0,0 :PRINT
1910 END
1920  '
1930  '*****  enter data from console
1940  '
1950  LOCATE 7,3  :COLOR 6 :PRINT "ENTER MESSAGE:"
1960  LOCATE 7,17 :COLOR 10:INPUT " ",MSG$
1970  LOCATE 9,3  :COLOR 6 :PRINT " ENTER HEIGHT:"
1980  LOCATE 9,17 :COLOR 10:INPUT " ",HIGH
1990  RETURN
2000  '
2010  '*****  read data from file
2020  '
2030  LOCATE 9,3  :COLOR 6 :PRINT " ENTER HEIGHT:"
2040  LOCATE 9,17 :COLOR 10:INPUT " ",HIGH
2050  GOSUB 2220
2060  INPUT #1,MSG$
2070  GOSUB 790
2080  IF EOF(1) THEN CLOSE #1 :GOTO 450
2090  GOTO 2060
2100  '
2110  '*****  write data to file
2120  '
2130  LOCATE 7,3  :COLOR 6 :PRINT "ENTER MESSAGE (press enter to quit) "
2140  LOCATE 9,10 :COLOR 6 :PRINT "==> "
2150  LOCATE 9,14 :COLOR 10:INPUT " ",MSG$
2160  IF MSG$="" THEN CLOSE #1 :GOTO 450
2170  PRINT #1,MSG$ :GOSUB 2220
2180  GOTO 2130
2190  '
2200  '*****  clear data entry area
2210  '
2220  LOCATE 6,2  :PRINT "                                     "
2230  LOCATE 7,2  :PRINT "                                     "
2240  LOCATE 8,2  :PRINT "                                     "
2250  LOCATE 9,2  :PRINT "                                     "
2260  LOCATE 10,2 :PRINT "                                     "
2270  RETURN
                   
