*ͻ*
*   System Name:   CODE BLOCK DEMONSTRATION SUITE                            *
*   Module Name:   CBRESTOR.PRG                                              *
*   Description:   Shows how code blocks can be saved in a database in       *
*                  character format and then be retrieved and evaluated in   *
*                  another program.                                          *
*   Notes......:   Needs CBRESTOR.PRG to be executed first to save info in   *
*                  the database.  Then this program can be run.              *
*                  ***  Compile with the /N/W/A switches  ***                *
*   Author.....:   Micheal Todd Charron                                      *
*   Date.......:   Oct. 23, 1990                                             *
*   History....:   Thought up, on a Train to Montreal                        *
*ͼ*

FUNCTION Main()
     LOCAL bEvalBloc1, bEvalBloc2
     LOCAL cPhrase
     LOCAL nI

     CLS

     USE ROUTINES

     GOTO 1
     bEvalBloc1 := &( ROUTINES->CodeBlock )

     GOTO 2
     bEvalBloc2 := &( ROUTINES->CodeBlock )


     cPhrase := "The rain in spain falls mainly"

     FOR nI := 1 to MIN( LEN( cPhrase ), 23 )

          @nI, 0 SAY EVAL( bEvalBloc1, cPhrase, nI )

     NEXT nI

     INKEY( 0 )

     CLS

     ?
     ? EVAL( bEvalBloc2, "a" )
     ?
     ? EVAL( bEvalBloc2 )

RETURN Nil

/******************************************************************************
  FUNCTION MAIN()
*******************************************************************************
        ͸
Line 22    USE ROUTINES                                                      
Line 23                                                                      
           GOTO 1                                                            
Line 25    bEvalBloc1 := &( ROUTINES->CodeBlock )                            
Line 26                                                                      
           GOTO 2                                                            
Line 28    bEvalBloc2 := &( ROUTINES->CodeBlock )                            
        ;
The database that contains the character representation of the Code Block's
stored in CBSAVE.PRG, is opened.  The record pointer is placed at the first
record.  The Code Block string is macro expanded into a Code Block and the
reference to that Code Block is stored in the variable "bEvalBloc1".  The same
thing is repeated for the second record and the resulting Code Block reference
is stored in the variable "bEvalBloc2".

A good point to remember is that those fields need only be macro expanded once
to create the Code Blocks.  Once they are created they can be passed around and
evaluated throughout your program.

        ͸
Line 31    cPhrase := "The rain in spain falls mainly"                       
Line 32                                                                      
           FOR nI := 1 to MIN( LEN( cPhrase ), 23 )                          
Line 34                                                                      
Line 35         @nI, 0 SAY EVAL( bEvalBloc1, cPhrase, nI )                   
                                                                             
Line 36    NEXT nI                                                           
        ;
A string is stored in the variable "cPhrase".  The Code Block referenced by the
variable "bEvalBloc1" is passed into the EVAL() function along with the string
"cPhrase" and the iterator "nI".  The Code Block is then evaluated, about 23
times, with ""cPhrase" and "nI" as it's parameters.


        ͸
Line 43    ?                                                                 
Line 44    ? EVAL( bEvalBloc2, "a" )                                         
Line 45    ?                                                                 
Line 46    ? EVAL( bEvalBloc2 )                                              
        ;
The second Code Block is evaluated with the parameter "a" passed to it and
displayed  Then the Code Block is evaluated with no parameters passed to it.
In the Code Block character representation I created in CBSAVE.PRG, I checked
to see if a parameter was being passed to the Code Block and if not it would
display a message.

*******************************************************************************
`What is it all for?', you ask.  Well, one of the buzzwords in the programming
world is 'Data Driven Programming'.  The ability to create a small engine that
will interpret code stored in files outside of the program.  This makes it easy
to change the applications without recompiling the code.

In Summer of '87 the only way this could be done effectively was through the
use of Macros.  But there were the limitations to macros that I had discussed
in CBMULTI.PRG.  Now you can store character representations of Code Blocks in
either a database or a text file.  Your only limitation on the size of the
string is 64K.  After the Code Block is expanded it is available to be used
again and again whereas a macro string must be expanded everytime it is used.
You can use as many expressions as you want in a Code Block.  The possibilities
are limitless.  Go crazy.
*******************************************************************************

Do me a favour, read the release notes under 'Code Block Notes'.  They have a
couple of things that you should know.  Believe me, it will save you a lot of
headaches.

*******************************************************************************
                                                   HOPE IT HELPS!
                                                   Micheal Todd Charron
******************************************************************************/
