// Double-line top, single-line sides
#define	B_DOUBLE_SINGLE	( CHR(213) + CHR(205) + CHR(184) + CHR(179) + ;
                             CHR(190) + CHR(205) + CHR(212) + CHR(179)   )

// Single-line box
#define	B_SINGLE 		( CHR(218) + CHR(196) + CHR(191) + CHR(179) + ;
                          CHR(217) + CHR(196) + CHR(192) + CHR(179)   )



Function Main( cFile )
	LOCAL nHandle, cBuffer, cCompress, nLenComp, cExpand, nBytes

	if cFile == NIL
		cFile := "SAMPLE.PRG"
	endif

	CLS

	setcolor( "N/W" )
	@ 0,0,24,79 box B_DOUBLE_SINGLE +space(1)


	nHandle := fOpen( cFile, 2 )
	nBytes := fSeek( nHandle, 0, 2 )
	cBuffer := space(nBytes)
	fSeek( nHandle, 0, 0 )
	fRead( nHandle, @cBuffer, nBytes )
	fClose( nHandle )

	@ 2, 10, 8, 71 box B_SINGLE color "B/W"

	@ 3, 12 say "Compression:"
	@ 4, 12 say "Before - " +str( len( cBuffer ) )
	@ 5, 18 say replicate( "", 50 )

	setcolor( "B+/W" )              // optional code block gets processed
	cCompress := Compress( cBuffer, {|a| AtSay( 5, a, nBytes ) } )
	AtSay( 5, nBytes, nBytes )

	setcolor( "N/W" )
	@ 6, 12 say "After  - " +str( len( cCompress ) )
	@ 7, 12 say "Percent  " +str( ( len( cCompress ) / len( cBuffer ) ) *100 )

	nHandle := fCreate( "SAMPLE.CMP" )
	fWrite( nHandle, cCompress )
	fClose( nHandle )

	@ 9,2 say "Press any key..."
	inkey(0)

	@ 15, 10, 20, 71 box B_SINGLE color "B/W"

	@ 16, 12 say "Decompression:"
	@ 17, 12 say "Before - " +str( len( cCompress ) )
	@ 18, 18 say replicate( "", 50 )

	nLenComp := len( cCompress )

	setcolor( "B+/W" )
	cExpand := Expand( cCompress, {|a| AtSay( 18, a, nLenComp ) } )
	AtSay( 18, nLenComp, nLenComp )

	setcolor( "N/W" )
	@ 19, 12 say "After  - " +str( len( cExpand ) )

	@ 22, 3 say "The input and output strings are "+;
								iif( cExpand == cBuffer, "", "not " ) +"identical."

	setpos( 23, 0 )

return NIL


Function AtSay( nRow, nPos, nLength )

	if mod( nPos, int( nLength / 100 ) ) == 0
		@ nRow, 12 say str( ( nPos / nLength ) * 100, 5, 0 ) +"  " +;
				replicate( "", ( nPos / nLength ) * 50 )
	endif

return NIL
