*========================================================================*
*
* program:  clip.prg
*   dated:  02/23/90
*  author:  Steve Rice
*           3828 Country Creek Way
*           Eagan, MN  55122
*
*           Compuserve:  72427, 2777
*
*  notice:  Copyright (c) 1990 Steve Rice, All rights reserved
* purpose:  This Summer '87 Clipper program calls various C functions
*           to demonstrate how to use C with Clipper.
*
*              The routines contained in this program file (clip.prg)
*              are entered into the public domain.
*
* disclaimer:  These routines were developed solely for demonstration
*              purposes and are provided on an "as is" basis, with
*              no implied warranty regarding fitness for any particular
*              purpose.  I, Steve Rice (the author), will not be liable
*              for any damages, real, or imagined, direct or indirect 
*              resulting from the use of this software.
*
*========================================================================*

** private variable declarations

private curr_test, max_test, u_string, u_date,  u_int,    u_decimal,;
        u_logical, clr_temp, mscreen,  string,  mlastkey,           ;
        box_[4],   help_[4], mhelp,    mbottom, clr_dos

** save the original screen color
clr_dos= setcolor()

** set our desired Clipper Environment
Env_Init()

** clear the screen and display status

clear screen

** save screen and begin to draw our screen

mbottom= savescreen(23, 2, 23, 78)

Center(23,;
 "F10 to advance one test    Escape to go back one test   Alt-X to Quit")

** rows and columns for help box and test box

help_[1]=  4
help_[2]=  2
help_[3]=  6
help_[4]= 77

box_[1]=  10
box_[2]=  10
box_[3]=  15
box_[4]=  70

** curr_test is the test currently being done, max_test is maximum test

curr_test=  1
max_test=  15

** number of particular test (so you can run them in any order, F1 help
** will recognize correct number for each test

** text_ array contains text displayed in help window

private number_[max_test], text_[max_test]
   number_[1]= 1
   text_[1]=   "Enter a string to be sent to C to be reversed"

   number_[2]= 2
   text_[2]=   "Enter kilometers to be converted to miles"

   number_[3]= 3
   text_[3]=   "Enter decimal number to be converted to hexadecimal"

   number_[4]= 4
   text_[4]=   "Test array processing in Clipper and C"

   number_[5]= 5
   text_[5]=   "Enter environment variable name to return set value"

   number_[6]= 6
   text_[6]=   "Enter environment variable name and new setting"

   number_[7]= 7
   text_[7]=   "Enter the directory and prefix for a temporary file"

   number_[8]= 8
   text_[8]=   "Enter the name of a file to create (no wildcards accepted)"

   number_[9]= 9
   text_[9]=   "Enter the name of files to find (wildcards accepted)"

   number_[10]= 10
   text_[10]=   "Enter the name of files to delete (wildcards accepted)"

   number_[11]= 11
   text_[11]=   "This is the current amount in bytes of stack space available"

   number_[12]= 12
   text_[12]=  "Attempt to change current directory"

   number_[13]= 13
   text_[13]=  "Attempt to set on exit function"

   number_[14]= 14
   text_[14]=  "Get the month corresponding to a particular number"

   number_[15]= 15
   text_[15]=  "A test of heapwalk function"

set key f1 to Help

** and here we go

do while true

   setcolor(clr_inv)
   mhelp=   Box(help_[1], help_[2], help_[3], help_[4], clr_help)
   mscreen= Box(box_[1],  box_[2],  box_[3],  box_[4],  clr_inv)
   
   do case
   case curr_test == number_[1]

      ** send a string to C and have C return the string reversed

      Show_Help(curr_test, text_[1])

      @ box_[1]+2, 12 say "Enter a string: "

      u_string= space(20)
      clr_temp= setcolor(clr_gets)

      do while true
         @ box_[1]+2, 29 get u_string pict "@K"

         read
         mlastkey= lastkey()

			if Read_Func(mlastkey, @curr_test)
				exit
			endif

         Reverse_St(u_string)

      enddo  && do while true

   case curr_test == number_[2]

      ** send double to C

      Show_Help(curr_test, text_[2])
      
      @ box_[1]+2, 12 say "Enter Kilometers: "
      @ row()+1  , 12 say "       Miles are: "
      
      u_decimal= 0

      clr_temp= setcolor(clr_gets)
      string= space(128)
      
      do while true

         @ box_[1]+2, 31 get u_decimal pict "999999.99"

         read
         mlastkey= lastkey()

			if Read_Func(mlastkey, @curr_test)
				exit
			endif

         miles= ktom(u_decimal)
         clr_temp= setcolor(clr_inv)         
         @ box_[1]+3, 31 say transform(miles, "999999.99")
         setcolor(clr_temp)
         
      enddo  && do while true

   case curr_test == number_[3]

      ** convert a number to hexadecimal

      Show_Help(curr_test, text_[3])
      
      @ box_[1]+2, 12 say "Enter number: "
      @ row()+1  , 12 say " Hexadecimal: "
      
      u_int= 0

      clr_temp= setcolor(clr_gets)
      string= space(128)
      
      do while true

         @ box_[1]+2, 29 get u_int pict "9999"

         read
         mlastkey= lastkey()

			if Read_Func(mlastkey, @curr_test)
				exit
			endif

         string= alltrim(convdtoh(u_int))

         string= iif(len(string) < 4, space(4 -len(string)), []) +string
         
         clr_temp= setcolor(clr_inv)

         @ box_[1]+3, 29 say transform(string, "!!!!")
         setcolor(clr_temp)
         
      enddo  && do while true

   case curr_test == number_[4]

      ** test Clipper and C processing arrays
      
      Show_Help(curr_test, text_[4])
      
      @ box_[1]+2, 12 say "Clipper Average:            Time:"
      @ box_[1]+3, 12 say "      C Average:            Time:"

      clr_temp= setcolor(clr_gets)

      do while true

         private array_[1000]
         afill(array_, seconds()/10)

         start= seconds()
         number= Clip_Ave(array_)
         stop=  seconds()

         time= stop -start

         clr_temp= setcolor(clr_inv)
                  
         @ box_[1]+2, 29 say transform(number, "9999.99")
         @ box_[1]+2, 47 say transform(time,   "9999.99")

         start= seconds()
         number= c_ave(array_)
         stop=  seconds()

         time= stop -start

         @ box_[1]+3, 29 say transform(number, "9999.99")
         @ box_[1]+3, 47 say transform(time,   "9999.99")

         Center(box_[1]+4, "Press any key to continue.")
         
         setcolor(clr_temp)

         clear typeahead
         
         mlastkey= inkey(0)

			if Inkey_Func(mlastkey, @curr_test)
				exit
			endif
			         
      enddo  && do while true

      clear typeahead

   case curr_test == number_[5]

      ** show environment setting

      Show_Help(curr_test, text_[5])
      
      @ box_[1]+2, 12 say "Name of environment var: "
      @ row()+1  , 12 say "    Environment setting: "

      clr_temp= setcolor(clr_gets)
      u_string= space(8)
      
      do while true
         number= 0

         @ box_[1]+2, 38 get u_string pict "@K!"

         read
         mlastkey= lastkey()

			if Read_Func(mlastkey, @curr_test)
				exit
			endif

         string= getenvvar(alltrim(u_string))

         clr_temp= setcolor(clr_inv)

         string= substr(string,1,30) +;
                 iif(len(string) > 30, [], space(30 -len(string)))

         @ box_[1]+3, 38 say string
         
         setcolor(clr_temp)

      enddo  && do while true

   case curr_test == number_[6]

      ** change environment setting
      
      Show_Help(curr_test, text_[6])
      
      @ box_[1]+2, 12 say "Environment var & setting: "
      @ row()+1  , 12 say "           return message: "

      clr_temp= setcolor(clr_gets)
      u_string= space(30)
      
      do while true
         number= 0

         @ box_[1]+2, 38 get u_string pict "@K!"

         read
         mlastkey= lastkey()

			if Read_Func(mlastkey, @curr_test)
				exit
			endif

         string= putenvvar(alltrim(u_string))

         clr_temp= setcolor(clr_inv)

         string= substr(string,1,30) +;
                 iif(len(string) > 30, [], space(30 -len(string)))

         @ box_[1]+3, 38 say string
         
         setcolor(clr_temp)

      enddo  && do while true

   case curr_test == number_[7]

      ** return a temporary file name
      
      Show_Help(curr_test, text_[7])
      
      @ box_[1]+2, 12 say "Directory of temporary file: "
      @ row()+1  , 12 say "   Prefix of temporary file: "
      @ row()+1  , 12 say "     Name of temporary file: "

      clr_temp= setcolor(clr_gets)
      u_string= "\" +curdir()
      u_string= iif(len(u_string) > 20, substr(u_string,1,20), u_string +;
                   space(20 -len(u_string)))

      u_pre=    space(4)
      
      do while true
         number= 0

         @ box_[1]+2, 42 get u_string pict "@K"
         @ row()+1,   42 get u_pre    pict "@K"
         
         read
         mlastkey= lastkey()

			if Read_Func(mlastkey, @curr_test)
				exit
			endif

         u_filename= randfile(alltrim(u_string), alltrim(u_pre))

         clr_temp= setcolor(clr_inv)
                  
         @ box_[1]+4, 42 say u_filename
         
         setcolor(clr_temp)

      enddo  && do while true

   case curr_test == number_[8]

      ** create a file in C
      
      Show_Help(curr_test, text_[8])
      
      @ box_[1]+2, 12 say "Name of file to create: "
      @ row()+1  , 12 say "        Return message: "

      clr_temp= setcolor(clr_gets)
      u_string= space(8)
      
      do while true

         @ box_[1]+2, 36 get u_string pict "@K"

         read
         mlastkey= lastkey()

			if Read_Func(mlastkey, @curr_test)
				exit
			endif

         message= filecr(alltrim(u_string))

         clr_temp= setcolor(clr_inv)
                  
         @ box_[1]+3, 36 say message
         setcolor(clr_temp)

      enddo
      
   case curr_test == number_[9]

      ** search for files

      Show_Help(curr_test, text_[9])
      
      @ box_[1]+2, 12 say "Name of file to look for: "
      @ row()+1  , 12 say "   Number of files found: "

      clr_temp= setcolor(clr_gets)
      u_string= space(8)
      
      do while true
         number= 0

         @ box_[1]+2, 38 get u_string pict "@K"

         read
         mlastkey= lastkey()

			if Read_Func(mlastkey, @curr_test)
				exit
			endif

         number= filedir(alltrim(u_string))

         clr_temp= setcolor(clr_inv)
                  
         @ box_[1]+3, 38 say transform(number, "9999")
         setcolor(clr_temp)

      enddo
      
   case curr_test == number_[10]

      ** delete files

      Show_Help(curr_test, text_[10])
      
      @ box_[1]+2, 12 say " Name of file to delete: "
      @ row()+1  , 12 say "Number of files deleted: "

      clr_temp= setcolor(clr_gets)
      u_string= space(8)
      
      do while true
         number= 0

         @ box_[1]+2, 38 get u_string pict "@K"

         read
         mlastkey= lastkey()

			if Read_Func(mlastkey, @curr_test)
				exit
			endif

         number= filedel(alltrim(u_string))

         clr_temp= setcolor(clr_inv)
                  
         @ box_[1]+3, 38 say transform(number, "9999")
         setcolor(clr_temp)

      enddo  && do while true

   case curr_test == number_[11]

      ** Check the amount of stack availabe

      Show_Help(curr_test, text_[11])

      @ box_[1]+2, 12 say "Bytes of stack space available: "

      clr_temp= setcolor(clr_gets)

      do while true

         number= 0

         number= ret_stack()

         clr_temp= setcolor(clr_inv)
                  
         @ box_[1]+2, 45 say transform(number, "9999")

         Center(box_[1]+3, "Press any key to continue.")
         
         setcolor(clr_temp)

         clear typeahead
         
         mlastkey= inkey(0)
			if Inkey_Func(mlastkey, @curr_test)
				exit
			endif
         
      enddo  && do while true

      clear typeahead
      
   case curr_test == number_[12]

      ** change the current directory

      Show_Help(curr_test, text_[12])

      @ box_[1]+2, 12 say "Enter directory: "

      u_string= space(20)
      clr_temp= setcolor(clr_gets)

      do while true
         @ box_[1]+2, 29 get u_string pict "@K"

         read
         mlastkey= lastkey()

			if Read_Func(mlastkey, @curr_test)
				exit
			endif

         if change_dir(u_string)
            string= "Successful change of directory"
         else
            string= "Did not change directory      "
         endif
         @ box_[1]+3, 29 say string

      enddo  && do while true

   case curr_test == number_[13]

      ** set on exit function
      
      Show_Help(curr_test, text_[13])
      
      clr_temp= setcolor(clr_gets)

      do while true

         number= 0

         if on_exit()
            @ box_[1]+2, 12 say "Successful on exit functions set"

         else
            @ box_[1]+2, 12 say "Error: in setting exit functions"

         endif

         clr_temp= setcolor(clr_inv)

         Center(box_[1]+3, "Press any key to continue.")
         
         setcolor(clr_temp)

         clear typeahead
         
         mlastkey= inkey(0)

			if Inkey_Func(mlastkey, @curr_test)
				exit
			endif
         
      enddo  && do while true

      clear typeahead

   case curr_test == number_[14]

      ** return text for a given month

      Show_Help(curr_test, text_[14])
      
      @ box_[1]+2, 12 say "Enter number: "
      @ row()+1  , 12 say "       month: "
      
      u_int= 0

      clr_temp= setcolor(clr_gets)
      string= space(128)
      
      do while true

         @ box_[1]+2, 29 get u_int pict "9999"

         read
         mlastkey= lastkey()

			if Read_Func(mlastkey, @curr_test)
				exit
			endif
			
         string= alltrim(month_txt(u_int))

         string= string +iif(len(string) < 20, space(20 -len(string)), [])
         
         clr_temp= setcolor(clr_inv)

         @ box_[1]+3, 29 say string

         setcolor(clr_temp)
         
      enddo  && do while true

   case curr_test == number_[15]

      ** delete files
      Show_Help(curr_test, text_[15])
      
      @ box_[1]+1, 12 say "Heap Info: "

      clr_temp= setcolor(clr_gets)
      u_string= space(30)
      
      do while true
         string= "test" +space(50)
         do while !empty(string)

            for x= 0 to 3
               string= heapwalk()         
               @ box_[1]+1+x, 25 say string
            next
            
            mlastkey= inkey(3)

            if mlastkey == esc .or. mlastkey == 13     .or.;
				   mlastkey == f10 .or. mlastkey == ctrl_w
               exit
            endif
            if substr(string,1,1) == "F"  && this means we are finished
               exit
            endif
         enddo
            
         if mlastkey == esc
            curr_test= curr_test -1
            exit
         else
            curr_test= curr_test +1
         endif

         exit
         setcolor(clr_temp)

      enddo  && do while true

   endcase   && case for curr_test

   restscreen(help_[1], help_[2], help_[3], help_[4], mhelp)
   restscreen(box_[1],  box_[2],  box_[3],  box_[4],  mscreen)

   if curr_test < 1
      exit
   elseif curr_test > max_test
      curr_test= 1
   endif

enddo        && do while true

restscreen(23, 2, 23, 78, mbottom)

Shut_Down("C")

return

* end proc Clip
*========================================================================*

function Clip_Ave

parameters parray_

private x, mtotal, len_parray

mtotal= 0
len_parray= len(parray_)

for x= 1 to len_parray
   mtotal= mtotal +parray_[x]
next

return (mtotal/len_parray)

* end func Clip_Ave
*========================================================================*
*
*   function:  Show_Help
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  This function displays info in a box as the test is run
*
* parameters:  pnum     - the current test number
*              pmessage - the message for the current test
*
*========================================================================*

function Show_Help

parameters pnum, pmessage

private temp_string, clr_temp

if pcount() != 2
   temp_string= space(12) +"I called this Clipper function from C!" +;
                space(12)
   clr_temp= setcolor(clr_blink)
else
   temp_string= "Test #" +alltrim(str(pnum)) +" - " +pmessage
   clr_temp= setcolor(clr_help)
endif

Center(help_[1]+1, temp_string)

setcolor(clr_temp)

return ([])

* end func Show_Help
*========================================================================*
*
*   function:  Center
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  This function centers text on a particular row passesd as
*              a parameter.
*
* parameters:  prow    - which row to center pstring on
*              pstring - string to center on prow
*
*    returns:  NULL
*
*========================================================================*

function Center

parameters prow, pstring

private mcol

mcol= int((79 -len(pstring))/2)

@ prow, mcol say pstring

return ([])

* end func Center
*========================================================================*
*
*   function:  Box
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  This function saves an area of the screen, clears that
*              area to a particular color, draws a single box in that
*              area, and then returns the saved screen variable
*
* parameters:  prow1, pcol1, prow2, pcol2 - screen coordinates
*              pclr_var                   - color to use for box
*
*    returns:  mscreen - saved screen area
*
*========================================================================*

function Box

parameters prow1, pcol1, prow2, pcol2, pclr_var

private mscreen, clr_temp

if type("pclr_var") != "C"
   pclr_var= clr_norm
endif

mscreen= savescreen(prow1, pcol1, prow2, pcol2)

clr_temp= setcolor(pclr_var)
@ prow1, pcol1 clear to prow2, pcol2
@ prow1, pcol1, prow2, pcol2 box single
setcolor(clr_temp)

return (mscreen)

* end func Box
*========================================================================*
*
*   function:  Env_Init
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  This function calls other functions to set the Clipper
*              environment and declares a few public variables
*
* parameters:  none
*
*    returns:  NULL
*
*========================================================================*

function Env_Init

public true, false, single, double

true=  .t.
false= .f.

single= chr(218) +chr(196) +chr(191) +chr(179) +chr(217) +;
        chr(196) +chr(192) +chr(179)
double= chr(201) +chr(205) +chr(187) +chr(186) +chr(188) +;
        chr(205) +chr(200) +chr(186)


Set_Enviroment()

Define_Keys()
Define_Pictures()

Set_Keys()
Set_Colors()

return ([])

* end func Env_Init
*========================================================================*
*
*   function:  Env_Init
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  This function sets the Clipper environment
*
* parameters:  none
*
*    returns:  false
*
*========================================================================*

function Set_Enviroment

*
*  Setup On/Off Switches
*
set printer    off
set talk       off
set alternate  off
set debug      off
set echo       off
set escape     off
set exclusive  off
set bell       off
set century    off
set exact      off
set heading    off
set scoreboard off
set softseek   off
set safety     off

*setcancel(.f.)

set confirm    on
set intensity  on
set deleted    on
set console    on
set escape     on
set wrap       on

set color      to 
set margin     to 0
set decimal    to 8
set alternate  to
set device     to screen

return (false)

* end func Set_Enviroment
*========================================================================*
*
*  procedure:  Help
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  This procedure executes when the user types F1 at a
*              wait state
*
* parameters:  p1, p2, p3 - Clipper Hot Key vars
*
*    returns:  nothing
*
*========================================================================*

procedure Help

parameters p1, p2, p3
private mscreen, x

mscreen=   Box(0, 0, 24, 79, clr_help)

for x= 1 to len(number_)
   @ x+1, 4 say "Test #" +transform(number_[x], pict_n2) +;
                          space(3) +text_[x]
next

Center(row()+2, "Press any key to continue.")

inkey(0)

restscreen(0, 0, 24, 79, mscreen)

return

* end func Help
*========================================================================*
*
*   function:  Define_Keys
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  This function sets constant for key values
*
* parameters:  none
*
*    returns:  false
*
*========================================================================*

function Define_Keys

public f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12,;
       shift_f9,  shift_f10,;
       ctrl_f1,   ctrl_f9,   ctrl_f10,  ctrl_c,;
       esc,       enter,     ctrl_r,    ctrl_u,   ctrl_u,   ctrl_w,;
       ctrl_home, ctrl_end,  page_down, page_up,;
       up_arrow,  rt_arrow,  dn_arrow,  rt_arrow, lt_arrow,;
       spacebar,  backspace, homekey,   endkey,   insert,   del,;
       alt_x,     alt_f1,    alt_f2,    alt_f3,   key_qx,   alt_a,;
       alt_d,     alt_p,     alt_r,     alt_n,    alt_s


f1=       28
f2=       -1
f3=       -2
f4=       -3
f5=       -4
f6=       -5
f7=       -6
f8=       -7
f9=       -8
f10=      -9
f11=     -10
f12=     -11

shift_f9=  -18
shift_F10= -19

ctrl_f1=  -20
ctrl_f9=  -28
ctrl_f10= -29

ctrl_c=     3                        && CONTROL C
esc=       27                        && ESCAPE CHARACTER
enter=     13                        && CARRIAGE RETURN
ctrl_r=    18                        && CONTROL R
ctrl_u=    21                        && CONTROL U
ctrl_w=    23                        && CONTROL W
ctrl_home= 29
ctrl_end=  23

page_down= ctrl_C                    && PAGE DOWN KEY
page_up=   ctrl_R
up_arrow=   5                        && UP ARROW KEY
rt_arrow=   4                        && RIGHT ARROW KEY
dn_arrow=  24                        && DOWN ARROW KEY
rt_arrow=   4
lt_arrow=  19
spacebar=  32
backspace=  8
homekey=    1
endkey=     6
insert=    22
del=        7

alt_a=    286
alt_d=    288

alt_n=    305
alt_p=    281
alt_r=    275
alt_s=    287

alt_x=    301                       && Alt-X

key_qx=   alt_x

alt_f1=   -30 
alt_f2=   -31
alt_f3=   -32

return (false)

* end func Define_Keys
*========================================================================*
*
*   function:  Define_Pictures
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  This function sets constant for pictures
*
* parameters:  none
*
*    returns:  false
*
*========================================================================*

function Define_Pictures

public pict_phone, pict_zip, pict_u5,  pict_u4, pict_u3, pict_u2, pict_u1,;
       pict_s20,   pict_s25, pict_s40, pict_n2

*
*  Data Entry Pictures
*
pict_phone=  "@R (!!!) !!!-!!!!"
pict_zip=    "@R 99999-9999"

pict_s20=    "@S20"
pict_s25=    "@S25"
pict_s40=    "@S40"

pict_u5=     "!!!!!"
pict_u4=     "!!!!"
pict_u3=     "!!!"
pict_u2=     "!!"
pict_u1=     "!"

pict_n2=     "99"

return (false)

* end func Define_Pictures
*========================================================================*
*
*   function:  Set_Keys
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  This function sets particular Hot Keys that we want active
*
* parameters:  none
*
*    returns:  false
*
*========================================================================*

function Set_Keys

set key f10       to F10_Key_Hit
set key alt_x     to QuickX

return (false)

* end func Set_Keys
*========================================================================*
*
*   function:  Set_Colors
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  This function declares public variables used for consistent
*              color usage.  Then iscolor() is called to return the monitor
*              type.  The parameter pmono is used to force the use of the
*              monochrome colors.  If pmono is .f., monochrome colors will
*              be used.
*
* parameters:  pmono - logical variable (optional - defaults to .t.)
*
*    returns:  miscolor - current monitor setting
*
*========================================================================*

function Set_Colors

parameters pmono

public clr_norm, clr_inv, clr_binv, clr_blink, clr_text, clr_back, clr_err,;
       clr_high, clr_shadow, clr_yesno, clr_help, clr_gets, clr_border,;
       clr_dull

private miscolor

if type("pmono") != "L"
   pmono= .f.
endif

miscolor= iscolor()

if miscolor .and. !pmono  && set colors dependent on monitor type and pmono

   ** color monitor

   clr_shadow= "+N/N"

   clr_gets=   "+W/B,N/BG,,,N/W"

   clr_dull=   "W/B"         && normal dull color   
   clr_norm=   "+W/B"        && normal color
   clr_text=   "+W/N"        && used for memoedit field

   clr_back=   "+W/R"        && background color for memoedit
   clr_inv=    "B/W"         && inverser color
   clr_binv=   "N/W+*"       && blinking inverse

   clr_blink=  "W+*/R"       && normal blinking

   clr_err=    "+W/R"        && error color
   clr_yesno=  "W+/RB"       && yes no color

   clr_help=   clr_norm

   clr_high=   "N/W"       && "+GR/W"
   
   clr_border= clr_norm

else

   ** monochrome monitor

   clr_shadow= "+N/N"
   clr_norm=   "W/N"
   clr_text=   "+W/N"
   clr_back=   clr_norm
   clr_inv=    "N/W"
   clr_binv=   "N/W*"
   clr_blink=  "W+*/N"
   clr_err=    clr_text
   clr_high=   clr_inv
   clr_yesno=  clr_text
   clr_help=   clr_norm

   clr_dull=   clr_norm
   
   clr_gets=   clr_norm
   clr_border= clr_inv

endif

return (miscolor)           && return monitor setting

* end func Set_Colors
*========================================================================*
*
*  procedure:  QuickX    
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  This function quits to DOS from any wait state when the
*              alt-x combination is pressed.
*
* parameters:  p1, p2, p3 - Clipper Hot Key vars
*
*    returns:  nothing
*
*========================================================================*

procedure QuickX

parameters p1, p2, p3

Shut_Down("C")

return

* end proc QuickX
*========================================================================*
*
*  procedure:  Shut_Down
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  This function shuts down the clipper environment and calls
*              exit_0 to run our routines set by on_exit.
*
* parameters:  p1  - a string (either C for c shut down or CLIP for 
*                    clipper shut down)
*
*    returns:  false 
*
*========================================================================*

function Shut_Down

parameters p1

setcolor(clr_dos)
set cursor on

close databases
clear screen

if p1 == "CLIP"
   quit
else
   clear memory
   exit_0()
endif

return (false)

* end func Shut_Down
*========================================================================*
*
*  procedure:  F10_Key_Hit
*      dated:  02/23/90
*     author:  Steve Rice
*     notice:  Copyright (c) 1990 Steve Rice, All rights reserved
*    purpose:  This procedure is a Hot Key procedure to let us know that
*              the F10 key was pressed
*
* parameters:  p1, p2, p3 - Clipper Hot Key vars
*
*    returns:  nothing
*
*========================================================================*

procedure F10_Key_Hit

parameters p1, p2, p3

keyboard (chr(ctrl_w))

return 

* end proc F10_Key_Hit
*========================================================================*

function Read_Func

parameters plastkey, pcurr_num

do case
case plastkey == ctrl_w .or. plastkey == f10
   pcurr_num= pcurr_num +1
   return (true)
case plastkey == f1
	Help()
case plastkey == esc
   pcurr_num= pcurr_num -1
   return (true)
endcase


return (false)

* end func Read_Func
*========================================================================*

function Inkey_Func

parameters plastkey, pcurr_num

do case
case mlastkey == esc
   pcurr_num= pcurr_num -1
	return (true)
case mlastkey == f1
	Help()
case mlastkey == alt_x
	QuickX()
otherwise
   pcurr_num= pcurr_num +1
   return (true)
endcase


return (false)

* end func Inkey_Func
*========================================================================*
* eof clip.prg
