/*=======================================================================
    Program : testtag.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Wed  05-11-1994   17:43:56
     System : CLIX SAMPLE PROGRAM
    Compile : Use CLX testtag to compile

      Notes : Sample program for tag browse



    Contains:
=======================================================================*/
#include "clxcmd.ch"
#include "samples.ch"
#include "inkey.ch"

#define _CHK        ""
#define _STAR       "*"
#define K_PLUS      43

/*
    The tbrowse tags work by first defining a 'key' that will uniquely
    identify a record in a database browse (such as recno() or
    indexkey()), or the element number in an array tbrowse. This is passed
    as a codeblock to MarksNew(bKeyBlock).

    In the tbrowse, the first column should be set as a codeblock calling
    DispMark(). This will handle the displaying of the tag.

    Thirdly, a hotkey should be defined for the tbrowse which calls the
    function MarkIt(), which handles the toggling of the tag for that
    record. Typically the spacebar or ENTER is used as the key to toggle
    tags.

    Internally, an array is built containing the 'keys' to the records or
    elements that have been tagged. The DispMark() function scans the
    array to see if the key to the current record/element is in the array,
    and if so, displays the appropriate mark. You can define different
    types of tag marks to be activated by different hotkeys. In the
    example below, both checkmarks  and stars * are available by pressing
    the spacebar and the plus key.

    After exiting the tbrowse, the array of 'keys' is obtained with the
    ReturnMarks() function.

    Note that there is a limit on the number of records that can be tagged
    - 4096, which is Clipper's upper limit for array elements. These tag
    routines are really meant to handle only a few hundred tagged records
    with good performance (remember each time a row is refreshed,
    DispMark() must scan the array). Be careful if you have a 'Tag all
    records' key with a database > 4000 records. If you need to process
    large numbers of records, it would be better to have a flag field
    defined in the database (see the second example).

*/

FUNCTION Main()
LOCAL nOpt:=1
LOCAL aMnu:={ ;
               {"n/bg","+w/n","+gr/bg","w/bg","+w/b"},;
               {"~Multiple Tag types" ,;
                "Demo of Tag browse with two kinds of tag marks", {|| TagEm()}, .t.},;
               {"Tag with ~Flag in Field" ,;
                "Demo of Tag browse with a dedicated flag field in the database",;
                 {|| DbfFlag()}, .t.} ;
             }
             REQUEST DBFCDX
    set scoreboard off
    setblink(.f.)
    set message to 24 CENTER
    LoadCSet("DEFAULT",_DATAPATH)
    ScrHead("Tag Browse Examples",{"+w/b","+r/b","+b/*gr","n/w"},3,.f.)
    do while .t.
        if VertMenu(aMnu,10,20,.t.,"C",24) == 0
            exit
        endif
    enddo
    close data
RETURN nil



STATIC FUNCTION TagEm()
LOCAL cScr,aRecs,cW,i,aRC
LOCAL aFlds:={{|| DispMark()},"KEY","NAME","PHONE"}
LOCAL aHdrs:={_CHK,"Key","Name","Phone"}
LOCAL aKeys:={  ;
                { K_SPACE, {|oB| MarkIt(oB)}          },;
                { K_PLUS,  {|oB| MarkIt(oB, .f., _STAR)} },;
                { K_ALT_R, {|oB| MarkRange(oB)}       },;
                { K_ALT_U, {|oB| ToggleMarks(oB, .f.)}} ;
             }
    save screen to cScr
    setcolor("+bg/b")
    cls
    OpenDbf("CUSTOMER","CUSTKEY",,,_DATAPATH)
    // set the Tags codeblock to the index key
    MarksNew(COMPILE(indexkey()))
    BROWSE FROM 3,10 TO 18,70 FIELDS aFlds HEADERS aHdrs ;
    KEYS aKeys COLORS "S:8" LONGBAR ;
    CAPTION "Space to , (+) to *, Alt-R Toggle Range, Alt-U Untag All"
    close data
    cW:=PopWind(0,0,22,79,"n/*b",,.f.)
    setcolor("n/*b")
    aRecs:=ReturnMarks()
    if len(aRecs) > 0
        @ 1,2 say "You have "+dig2str(len(aRecs))+" tagged records:"
        n:=0
        m:=0
        @  2,2 say "Checks:" color "+w/*b"
        @ 13,2 say "Stars:" color "+g/*b"
        for i:=1 to len(aRecs)
            if aRecs[i,2]==_CHK
                n++
                aRC:=PosCell(1, 7, 10, n, 3, 2)
                @ aRC[1],aRC[2] say aRecs[i,1] color "+w/*b"
            else
                m++
                aRC:=PosCell(1, 7, 10, m, 14, 2)
                @ aRC[1],aRC[2] say aRecs[i,1] color "+g/*b"
            endif
        next
    else
        @ 1,0 say "No records tagged"
    endif
    Pause()
    UnPop(cW)
    popcolor()
    restore screen from cScr
    use
RETURN nil

STATIC FUNCTION MarkRange(oBr)
LOCAL cW:=PopWind(10,15,13,65,"w/b"),GetList:={}
LOCAL nRecNo:=recno(),cLoKey,cHiKey:=KEY,aMR:={}
    pushcolor("w/b,b/w")
    go top
    cLoKey:=KEY
    goto nRecNo
    @ 11,18 say "Lowest key to mark:" get cLoKey pict "@!"
    @ 12,17 say "Highest key to mark:" get cHiKey pict "@!"
    read
    if lastkey() <> K_ESC
        seek cLoKey SOFTSEEK
        dbeval({|| aadd(aMR, {KEY,_CHK})},,{|| KEY <= cHiKey})
        MergeMarks(oBr,aMR)
    endif
    popcolor()
    UnPop(cW)
RETURN nil

STATIC FUNCTION DbfFlag()
LOCAL aKeys,bFlag,cScr,aRC,n:=0
    save screen to cScr
    ScrHead("DBF field tag browse")
    OpenDbf("COUNTRY","CNTYCODE",.f.,.t.,_DATAPATH,.t.,"DBFCDX")
    aKeys:={  {K_SPACE, {|b| ToggleFlag(b,bFlag)}  },;
              {K_ENTER, {|| ExitBrowse()}          } ;
           }
    bFlag:=fieldblock("INCLUDE")
    go top
    BROWSE FROM 5,10 TO 18,70 ;
     FIELDS {{|| DbfFlagDisp(bFlag)},"COUNTRY","CNTRYNAME"} ;
     HEADERS {"","Cnty","Country"} ;
     KEYS aKeys COLORS "S:9" LONGBAR INCREMENTAL ;
     CAPTION "Space to , ENTER when finished"
    if lastkey()<>27
        go top
        do while !eof()
            if INCLUDE
                n++
                aRC:=PosCell(1, 3, 26, n, 5, 1)
                @ aRC[1],aRC[2] say left(CNTRYNAME,25) color "n/w"
            endif
            skip
        enddo
        Pause()
    endif
    use
    restore screen from cScr
RETURN nil



