/*=======================================================================
    Program : pulldown.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Wed  05-11-1994   17:48:15
     System : CLIX
    Compile : Clx PULLDOWN

      Notes : test program for pulldown menu system

  =======================================================================*/

#include "inkey.ch"
#include "clxcmd.ch"

FUNCTION Main()
LOCAL aCust_pdown,aRec_pdown,aPay_pdown,aMain_Menu,aExit_pdown,aDays,aMenu
LOCAL nButtons,nVal
    aDays := {  ;
                {"+w/n","n/*w","+b/n","+n/n","w/b"},;
                {"~Current","List for current age",     {|| RecCurr()},.t. },;
                {"> ~30 days","List for age > 30 days",   {|| Rec30()},.t.   },;
                {"> ~60 days","List for age > 60 days",   {|| Rec60()},.t.   } ;
             }

    aCust_pdown:= { ;
                    {"w/r","r/*w","+gr/r","gr/r","+w/b"},;
                    {"By ~Name","View Customer by Name",{|| CustByName()},.t. },;
                    {"By ~Key","View Customer by Key",{|| CustByKey()},.t.  },;
                    {"By ~City","View Customer by City",{|| CustByCity()},.t. } ;
                 }

    aRec_pdown:=  { ;
                    {"n/bg","+w/n","+gr/bg","w/bg","+w/b"},;
                    {"By ~Invoice#",, {|| RecByInv()},.t. },;
                    {"By Con~tact",,  {|| RecByContact()},.t. },;
                    {"-"},;
                    {"~Days Menu",, aDays,.t. };
                 }

    aPay_pdown:=  { ;
                    {"+w/g","+g/n","+gr/g","bg/g","+w/b"},;
                    {"By ~Company",, {|| PayByCompany()},.t. },;
                    {"By Con~tact",, {|| PayByContact()},.t. },;
                    {"~Current",,    {|| PayCurr()},.f. },;
                    {"> ~30 days",,   {|| Pay30()},.t.   },;
                    {"> ~60 days",,   {|| Pay60()},.t.   } ;
                 }

    aExit_pdown:= { ;
                    {"+w/rb","+rb/n","+gr/rb","r/rb","+w/b"},;
                    {"~Exit","Finis", {|| ExitMenu()},.t.   } ;
                 }

    aMain_Menu:=  { ;
                    {"w/b","b/w","+r/b","n/b","+gr/b"},;
                    {"~Customers","Customer file maintenance", aCust_pdown,.t.,K_ALT_C},;
                    {"~Receivables","Accounts Receivable Maintenance", aRec_pdown,.t.,K_ALT_D},;
                    {"~Payables","Accounts Payable Maintenance", aPay_pdown,.t.,K_ALT_P},;
                    {"~Quit","Exit the System",aExit_pdown,.t.,K_ALT_Q} ;
                 }

    aMenu:= { ;
              {"+n/g","+g/n","+gr/g","bg/g","w/b"},;
              {"The ~First Option","This is the first option",NIL,.t.},;
              {"Option Numero ~2","This is the the second option",NIL,.t.},;
              {"~Third time's a Charm","This is the third and last option",NIL,.t.};
            }

    setcolor("W/B")
    set message to 24 center
    MouseInit(@nButtons)
    MouseOn()
    cls
    setblink(.f.)
    setcancel(.f.)
    DoPullDown(aMain_Menu, 1,0, .t., "C")
    cls
    nVal:=VertMenu(aMenu,8,20,.t.,"L",20,"Test Menu")
    MouseOff()
    @ 5,10 say "You chose option "+str(nVal,1)
RETURN nil

STATIC FUNCTION Pay60()
    Dialog("PAY60()")
RETURN nil

STATIC FUNCTION Rec60()
    Dialog("REC60()")
RETURN nil

STATIC FUNCTION Pay30()
    Dialog("PAY30()")
RETURN nil

STATIC FUNCTION Rec30()
    Dialog("REC30()")
RETURN nil

STATIC FUNCTION PayCurr()
    Dialog("PAYCURR()")
RETURN nil

STATIC FUNCTION recCurr()
    Dialog("RECCURR()")
RETURN nil

STATIC FUNCTION PayByContact()
    Dialog("PAYBYCONTACT()")
RETURN nil

STATIC FUNCTION RecByContact()
    Dialog("RECBYCONTACT()")
RETURN nil

STATIC FUNCTION PayByCompany()
    Dialog("RECBYCOMPANY()")
RETURN nil

STATIC FUNCTION RecByInv()
    Dialog("RECBYINV()")
RETURN nil

STATIC FUNCTION CustByCity()
    Dialog("CUSTBYCITY()")
RETURN nil

STATIC FUNCTION CustByKey()
    Dialog("CUSTBYKEY()")
RETURN nil

STATIC FUNCTION CustByName()
    Dialog("CUSTBYNAME()")
RETURN nil

