/*=======================================================================
    Program : gettypes.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Wed  05-11-1994   17:47:37
     System : CLIX SAMPLE
    Compile : /m/n
              rtlink fi gettypes,getsyspp lib clix

      Notes : demo of different types of Gets

=======================================================================*/
#include "clxcmd.ch"
#include "samples.ch"

FUNCTION Main()
LOCAL cName:=padr("John Smith",24),cAddress:=padr("1234 Main Street",36),cCity:=padr("My Town",20),cState:="CA",cZip:="94722-    "
LOCAL cPhone:="510-555-1212",cSex:=" ",nButtn,dBDate:=date()-365*30,nPmtType:=2
LOCAL nBalDue:=nOrigDue:=250,nAmount:=50,lPrevSub:=.f.,cMag:="PC Network Journal       "
LOCAL nSex:=1,lEasy:=.f.
LOCAL aMags:={"C++ Developer's Journal  ",;
              "Get on my CASE           ",;
              "Object Oriented Othodoxy ",;
              "PC Network Journal       ",;
              "Visual Objects Newsletter",;
              "We Do Windows            "}
    setblink(.f.)
    ClixSet("SYSTITLE", _SYSTITLE)
    set message to 24 center style _MT_SWIN color "+w/br"
    set scoreboard off
    set confirm on
    ScrHead("Demo of different GET types", {"+w/br","+gr/br","+w/b","r/b"}, 2, .f.)
    setcolor("+w/br,+w/n,,,+br/*n")
    MouseInit(@nButtn)
    MouseOn()

    do while .t.
        @ 5,5 say "Name:   " get cName ;
          message "Enter Name"

        @ 6,5 say "Address:" get cAddress ;
          message "Enter Address"

        @ 7,5 say "City:   " get cCity ;
          message "Enter City"

        @ 7,38 say "State:" get cState pict "@!" ;
          message "Enter State -> Lookup validation" ;
          valid Lookup(_DATAPATH+"STATES","STATES",cState,,,{|| PutGet("cState",STATE_ABBR)},1,;
                  "Invalid State",{"STATE_ABBR", "STATE"}, {"Abbrv", "State"},;
                  /* bEA */,"w/b,b/w,+w/r,r/w,+gr/b")

        @ 7,50 say "Zip:" get cZip pict "99999-9999" ;
          message "Enter Zip Code"

        @ 8,5 say "Phone:  " get cPhone pict "999-999-9999" ;
          message "Enter phone number"

        @ 10,5 say "Birthdate:" get dBdate DATEINC ;
          message "Enter Birth date -> incremental date field"

        @ 12,5 say "Pmt type: " get nPmtType ;
          MESSAGE "Enter payment type -> radio buttons" ;
          COLOR "+gr/br" ;
          WITH RADIOBUTTONS {"Cash","Check","VISA","M/C","Amex"} ;
          SINGLE

        @ 10,40 say "Balance due:" get nBalDue pict "99999.99" ;
          when .f. color if(nBalDue<0,"+w/r","+br/*n")

        @ 11,40 say "Pmt Amount: " get nAmount pict "99999.99" ;
          message "Enter payment amount -> will update Balance due field" ;
          valid UpdBalDue(nAmount,nOrigDue)

        @ 13,40 get lPrevSub CHECKBOX "Previous Subscriber" ;
          message "Mark checkbox if subscribed previously"

        @ 14,40 say "Magazine:" get cMag COMBO aMags ;
          BOXCOLOR "n/bg,+bg/n" ;
          CAPTION "Choose Magazine" ;
          MESSAGE "Magazine subscription -> Listbox example"

        @ 15,40 get lEasy CHECKBOX "Easy Pmt Plan" ;
          message "Mark checkbox if paying with Easy Pay plan"
        @ 17,40 say "Sex:" get nSex ;
          MESSAGE "Enter sex"  COLOR "+gr/br"  ;
          WITH RADIOBUTTONS {"Male","Female"} DOUBLE
        read
        if StatPrompt("ACQ","OPTIONS - A TO ACCEPT, C TO CHANGE, Q TO QUIT","",.f.) <> "C"
            exit
        endif
    enddo
    MouseOff()

RETURN nil

/*-----------------------------------------------------------------------
   Function: UpdBalDue(nAmt,nOrigDue)
      Notes: used to update the nBalDue field when the payment amount
             is changed
-----------------------------------------------------------------------*/
STATIC FUNCTION UpdBalDue(nAmt,nOrigDue)
LOCAL aList:=ReadGetList(),oGet
    oGet:=aList[GetOrdinal("nBalDue")]
    nBD:=nOrigDue-nAmt
    oGet:varPut(nBD)
    oGet:colorDisp(if(nBD<0,"+w/r","+br/*n"))
RETURN(.t.)
