/*=======================================================================
    Program : gened.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Wed  05-11-1994   17:29:47
     System : CLIX sample
    Compile : /m/n
              Use rmake @gened

      Notes : Sample for GenericEd()


=======================================================================*/
#include "clxcmd.ch"
#include "samples.ch"

//      File CUSTOMER.DBF

#define CU_KEY                1
#define CU_NAME               2
#define CU_ADDRESS1           3
#define CU_ADDRESS2           4
#define CU_CITY               5
#define CU_STATE              6
#define CU_ZIP                7
#define CU_PHONE              8
#define CU_EXT                9
#define CU_COMPANY           10
#define CU_DIALECT           11
#define CU_SETUP             12
#define CU_SALES             13
#define CU_OTHERCHG          14
#define CU_PAYMENTS          15
#define CU_CODES             16
#define CU_HISTORY           17
#define CU_MAIL_ADDR         18
#define CU_FIRST_INV         19


/*
    This example demonstrates how to use the GenericEd() generic data entry
    module. It edits CUSTOMER.DBF. Note the UDF EditCust() which specifies
    the screen layout. The command form is used to invoke GenericEd().
    Note the Options menu defined by aaOpt.
*/


FUNCTION Main()

LOCAL bEB:={|aF, nEDMode, nScr| EdCust(aF, nEDMode, nScr) }
LOCAL aSRCH:={ {"Customer Key",space(8),"@!",{|| KEY } } }
LOCAL aKolors:={"n/bg","+w/n","+w/bg","w/bg","+gr/bg"}
LOCAL aaOpt:={{"~More", "More Options Menu"},;
              { ;
                {"+w/r","+r/w","+gr/r","gr/r","+gr/bg"},;
                {"Total ~Sales" ,"Calculate Total Sales", {|| CalcSales()}, .t.},;
                {"~List" ,"List Customers", {|| ListCust()}, .t.} ;
              } ;
             }
LOCAL nButton
    set scoreboard off
    set confirm on
    MouseInit(@nButton)
    // set application name  (for use by ScrHead())
    ClixSet("SYSTITLE", _SYSTITLE)

    select 0
    OpenDbf("CUSTOMER", "CUSTKEY",,,_DATAPATH)  // open CUSTOMER file
    go top
    MouseOn()

    // use command format for invoking GenericEd()
    EDIT WITH bEB ;
         TITLE "Customer File Maintenance" ;
         COLORS aKolors ;
         PAGES 2        ;
         OPTIONS aaOpt  ;
         LOCK 1         ;
         SEARCH {aSRCH}         // note that additional set of parens are placed
                                // around aSRCH
    close data
    MouseOff()
RETURN nil


/*-----------------------------------------------------------------------
   Function: EdCust(aF, nEDMode, nScr)
 Parameters: aF - scatter() array of fields
             nEdMode - 0=view, 1=add, 2=edit
    Returns: Key to the record
      Notes: UDF to define screen layout and GETS for CUSTOMER.DBF as
             called by GenericEd()

-----------------------------------------------------------------------*/
FUNCTION EdCust(aF, nEDMode, nScr)
LOCAL cKey:=NIL,GetList:={}
    do case
    case nScr == 1

        @  7,3 say "Key    :" get aF[CU_KEY] pict "@!" ;
          message "Key = 1st 5 letters of last name + 1st 2 letters of 1st name" ;
          valid NotEmpty(aF[CU_KEY],,"+gr/bg")

        @  7,30 say "Name:" get aF[CU_NAME] ;
          message "Contact Name"

        @  9,3 say "Address:" get aF[CU_ADDRESS1] ;
           message "Enter Address"

        @ 10,3 say "        " get aF[CU_ADDRESS2] ;
           message "Enter Address"

        @ 11,3 say "City   :" get aF[CU_CITY] ;
           message "Enter City"

        @ 11,35 say "State:" get aF[CU_STATE] pict "@!" ;
           message "Enter State"

        @ 11,45 say "Zip:" get aF[CU_ZIP] pict "99999-9999" ;
           message "Enter Zip Code" ;
           valid StripZip(aF[CU_ZIP])

        @ 12,3 say "Phone  :" get aF[CU_PHONE] pict "(999)999-9999" ;
          message "Enter Phone"

        @ 12,35 say "Ext:" get aF[CU_EXT] pict "9999" ;
          message "Enter Phone Extension"

        @ 14,3 say "Company:" get aF[CU_COMPANY] ;
          message "Enter Company Name, if applicable"

        @ 16,3 say "Codes"
        @ 17,3 get aF[CU_CODES] pict "@!"

        @ 18,3 say "History:" get aF[CU_HISTORY]

    case nScr == 2

        @  7,3 say "Key    :" get aF[CU_KEY] pict "@!" when .f.

        @  7,30 say "Name:" get aF[CU_NAME] when .f.

        @ 10,3 say "      SALES         OTHER        PAYMENTS"

        @ 11,6 get aF[CU_SALES] pict "99999.99" ;
          valid DispNet(aF)

        @ 11,20 get aF[CU_OTHERCHG] pict "99999.99" ;
          valid DispNet(aF)

        @ 11,36 get aF[CU_PAYMENTS] pict "99999.99" ;
          valid DispNet(aF)

        DispNet(aF)
        @ 11,50 say "Net: "
        @ 11,55 say transform(aF[CU_SALES]+aF[CU_OTHERCHG]+aF[CU_PAYMENTS],"99999.99") ;
                color if(aF[CU_SALES]+aF[CU_OTHERCHG]+aF[CU_PAYMENTS]<0,"r/bg","n/bg")
    endcase

    if nEDMode>0
        read
        if lastkey() <> 27
            cKey:=aF[CU_KEY]
        endif
    else
        clear gets
    endif
return(cKey)

// ======================================================================
//  Below are support functions called by the Options menu
// ======================================================================

/*-----------------------------------------------------------------------
   Function: CalcSales()
    Returns: nil
      Notes: sums the CUSTOMER->SALES field to get the total sales, and
             displays it in an Alert() box.
-----------------------------------------------------------------------*/
STATIC FUNCTION CalcSales()
LOCAL nRecNo:=recno(),nSales:=0
    go top
    SUM SALES to nSales
    Alert("Total sales are "+Currency(nSales))
    go nRecNo
RETURN nil

STATIC FUNCTION ListCust()
LOCAL cScr,nCurrRec:=recno(),cTemp,nLine:=99,nPg:=0
    save screen to cScr
    cTemp:=MakeTemp()
    set alternate to (cTemp)
    set alternate on
    set console off
    go top
    do while !eof()
        nLine := PgHead(nLine, @nPg, "List Customers")
        ?
        ? "["+KEY+"] "+NAME+if(!empty(COMPANY)," of "+COMPANY," ")
        ? space(11)+trim(ADDRESS1)+" "+trim(ADDRESS2)
        ? space(11)+trim(CITY)+", "+STATE+"  "+ZIP
        nLine += 4
        skip
    enddo
    set alternate off
    set alternate to
    set console on
    ViewFile(cTemp, "List Customers")
    erase (cTemp)
    goto nCurrRec
    restore screen from cScr
RETURN nil

STATIC FUNCTION DispNet(aF)
        @ 11,50 say "Net: "
        @ 11,55 say transform(aF[CU_SALES]+aF[CU_OTHERCHG]+aF[CU_PAYMENTS],"99999.99") ;
                color if(aF[CU_SALES]+aF[CU_OTHERCHG]+aF[CU_PAYMENTS]<0,"r/bg","n/bg")
RETURN(.t.)

STATIC FUNCTION StripZip(cZip)
LOCAL cRet:=cZip,oGet:=GetActive()
    if right(trim(cZip),1)=="-"
        cRet := padr(left(cZip,5),10)
    endif
    oGet:varPut(cRet)
    oGet:display()
RETURN(.t.)
