/*=======================================================================
    Program : dmopick.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Mon  12-06-1993   12:51:21
     System : CLIX DEMO
    Compile : /m/n

      Notes : picklists

    Contains: DoPopFlds(), DoPickList(), DoTagList()
=======================================================================*/
#include "clxcmd.ch"
#include "clxbox.ch"
#include "inkey.ch"

/*-----------------------------------------------------------------------
   Function: DoPopFlds()
      Notes: PopFields() and PickNOrder demo

-----------------------------------------------------------------------*/
FUNCTION DoPopFlds()
LOCAL cScr,aColor:={"+w/b","n/*w","+r/b","n/b","+w/b"},nOpt:=1,aFlds
    save screen to cScr
    ScrHead("PopFields() and PickNOrder()",{"+w/b","+r/b","+b/*gr","n/w"},3,.f.)
    pushcolor("+w/b")
    DrawBox(7,5,19,75,"+b/b",B_SINGLE_DOUBLE,.t.)
    @  8,7 say "CLIX provides two methods of choosing a list of database fields."
    @  9,7 say "The first, PopFields(), provides an ACHOICE() style list of fields"
    @ 10,7 say "from the current database, with the ability to single or multiple"
    @ 11,7 say "select a field. The function returns an array of the field name(s)"
    @ 12,7 say "chosen, or a dbstruct() style array."
    @ 13,7 say "The second, PickNOrder(), not only allows you to chose the fields,"
    @ 14,7 say "but also to determine the order of the fields. This function returns"
    @ 15,7 say "either an array of field names, or a dbstruct() style array."
    do while .t.
        @ 17,20 prompt "Pop~Fields"
        @ 17,30 prompt "PickN~Order"
        @ 17,42 prompt "~Exit"
        menu to nOpt color aColor
        do case
            case nOpt==0 .or. nOpt==3
                exit
            case nOpt==1
                NetUse("CUSTOMER")
                PopFields(.t.,.f.,10,35,,,"n/w,+w/n")
                close data
            case nOpt==2
                NetUse("CUSTOMER")
                aFlds := PickNOrder("Choose fields to Browse",.f., {"n/bg,+bg/n","+gr/bg","+w/bg"})
                if len(aFlds) > 0
                    BROWSE FROM 4,10 TO 18,70 FIELDS aFlds BOX B_DOUBLE SHADOW
                endif
                close data
        endcase
    enddo

    popcolor()
    restore screen from cScr
RETURN nil

/*-----------------------------------------------------------------------
   Function: DoPickList()
      Notes: Picklist() demo

-----------------------------------------------------------------------*/
FUNCTION DoPickList()
LOCAL cScr,aPL:={}
    save screen to cScr
    ScrHead("PickLists",{"+w/b","+r/b","+b/*gr","n/w"},3,.f.)
    pushcolor("+w/b")
    DrawBox(7,5,15,75,"+b/b",B_SINGLE_DOUBLE,.t.)
    @  8,7 say "A picklist provides a list of items from an array and allows the"
    @  9,7 say "user to make a selection from the list. The CLIX picklist is built" 
    @ 10,7 say "around the ACHOICE() function, and can operate in either single "
    @ 11,7 say "select or multiple tag mode. You can pick elements out of a multi-"
    @ 12,7 say "dimensional array without having to rebuild the array to single "
    @ 13,7 say "dimensional like ACHOICE(). Colors, frame type, titles, etc. are "
    @ 14,7 say "all definable."
    Pause()
    NetUse("CUSTOMER")
    set index to CUSTKEY
    dbeval({|| aadd(aPL, NAME)},,,40)
    use
    Ret := PickList(aPL,.f.,1,2,25,20,60,"+w/r,r/*w",B_SINGLE,.t.,"Make a Choice:")
    if Ret > 0
        dialog("You chose "+trim(aPL[Ret]))
    endif
    Ret:=max(Ret,1)
    Ret := PickList(aPL,.t.,Ret,2,25,20,60,"+gr/g,g/*gr",B_DOUBLE,.t.,{"Multiple Select:","Spacebar to Tag"})
    if len(Ret) > 0
    endif
    Pause()
    popcolor()
    restore screen from cScr
RETURN nil
/*-----------------------------------------------------------------------
   Function: DoTagList()
      Notes: tagging records in a tbrowse

-----------------------------------------------------------------------*/
#define _CHK        ""
#define _STAR       "*"
#define K_PLUS      43

FUNCTION DoTagList()
LOCAL cScr,aRecs,cW,i,aRC
LOCAL aFlds:={{|| DispMark()},"KEY","NAME","PHONE"}
LOCAL aHdrs:={_CHK,"Key","Name","Phone"}
LOCAL aKeys:={  ;
                { K_SPACE, {|oB| MarkIt(oB)}          },;
                { K_PLUS,  {|oB| MarkIt(oB, .f., _STAR)} },;
                { K_ALT_R, {|oB| MarkRange(oB)}       },;
                { K_ALT_U, {|oB| ToggleMarks(oB, .f.)}} ;
             }
    save screen to cScr
    ScrHead("Tag Lists",{"+w/b","+r/b","+b/*gr","n/w"},3,.f.)
    pushcolor("+w/b")
    DrawBox(7,5,19,72,"+b/b",B_SINGLE_DOUBLE,.t.)
    @  8,7 say "A taglist is similar to a picklist except it allows you to tag"
    @  9,7 say "database records in a tbrowse (although it can be used in an"
    @ 10,7 say "array tbrowse as well). As records are tagged, a check mark is"
    @ 11,7 say "displayed, an element is added to an array with a user defined"
    @ 12,7 say "'key' (which could be the indexkey() or recno(), for example."
    @ 13,7 say "Provision is also made to tag a range of records. When the "
    @ 14,7 say "the function is exited, the array of keys or pointers can be"
    @ 15,7 say "retrieved and used for processing."
    @ 16,7 say "CLIX' taglists can tag records with multiple tag characters; the"
    @ 17,7 say "checkmark  is the default, but any character can be used (see"
    @ 18,7 say "the following demo)."
    Pause()
    setcolor("+bg/b")
    @ 8,7 clear to 18,71
    @  9,10 say "MarksNew()    - initialize a tag browse"
    @ 10,10 say "DispMark()    - used to display the checkmark"
    @ 11,10 say "MarkIt()      - called to toggle the mark"
    @ 12,10 say "ReturnMarks() - retrieve array of pointers"
    @ 13,10 say "ToggleMarks() - set a range of marks"
    @ 14,10 say "MarkAllRecs() - tag all records"
    @ 15,10 say "MergeMarks()  - merge an array of marks into existing marks"
    @ 16,10 say "MarkCount()   - returns the number of tagged records"
    Pause()
    NetUse("CUSTOMER")
    set index to CUSTKEY
    MarksNew(COMPILE(indexkey()))
    BROWSE FROM 3,10 TO 18,70 FIELDS aFlds HEADERS aHdrs ;
    KEYS aKeys COLORS "S:8" LONGBAR ;
    CAPTION "Space to , (+) to *, Alt-R Toggle Range, Alt-U Untag All"
    close data
    cW:=PopWind(0,0,22,79,"n/*b",,.f.)
    setcolor("n/*b")
    aRecs:=ReturnMarks()
    if len(aRecs) > 0
        @ 1,2 say "You have "+dig2str(len(aRecs))+" tagged records:"
        n:=0
        m:=0
        @  2,2 say "Checks:" color "+w/*b"
        @ 13,2 say "Stars:" color "+g/*b"
        for i:=1 to len(aRecs)
            if aRecs[i,2]==_CHK
                n++
                aRC:=PosCell(1, 7, 10, n, 3, 2)
                @ aRC[1],aRC[2] say aRecs[i,1] color "+w/*b"
            else
                m++
                aRC:=PosCell(1, 7, 10, m, 14, 2)
                @ aRC[1],aRC[2] say aRecs[i,1] color "+g/*b"
            endif
        next
    else
        @ 1,0 say "No records tagged"
    endif
    Pause()
    UnPop(cW)
    popcolor()
    restore screen from cScr
RETURN nil

STATIC FUNCTION MarkRange(oBr)
LOCAL cW:=PopWind(10,15,13,65,"w/b"),GetList:={}
LOCAL nRecNo:=recno(),cLoKey,cHiKey:=KEY,aMR:={}
    pushcolor("w/b,b/w")
    go top
    cLoKey:=KEY
    goto nRecNo
    @ 11,18 say "Lowest key to mark:" get cLoKey pict "@!"
    @ 12,17 say "Highest key to mark:" get cHiKey pict "@!"
    read
    if lastkey() <> K_ESC
        seek cLoKey SOFTSEEK
        dbeval({|| aadd(aMR, {KEY,_CHK})},,{|| KEY <= cHiKey})
        MergeMarks(oBr,aMR)
    endif
    popcolor()
    UnPop(cW)
RETURN nil
