/*=======================================================================
    Program : dmomlti.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Mon  11-22-1993   05:56:01
     System : CLIX DEMO
    Compile : /m/n

      Notes : Demo program for MultiBrowse()

=======================================================================*/
#include "clxcmd.ch"
#include "inkey.ch"
#include "clxbox.ch"

FUNCTION DoMultiBr()
LOCAL aaFlds:={},aaHdr:={},aCaps:={},aaHot:={},aaFunc:={},aaInst:={}
LOCAL aKolors:={ "b/bg,+bg/b,+w/bg,+gr/bg,+bg/bg",;
                 "n/g,+gr/n,+gr/g,+w/g,+g/g"  }
LOCAL aaCoords:={},cScr

    save screen to cScr
    ScrHead("MultiBrowse()",{"+w/b","+r/b","+b/*gr","n/w"},3,.f.)
    pushcolor("+bg/b")
    DrawBox(8,10,18,70,"+gr/b",B_SINGLE_DOUBLE)
    @  9,12 say "MultiBrowse() permits the formulation of parent/child"
    @ 10,12 say "tbrowses, useful in displaying databases with a one-to-"
    @ 11,12 say "many relationships (ie, header and detail records)."
    @ 12,12 say "MultiBrowse() is not limited in how many related data-"
    @ 13,12 say "bases it can handle, although four is probably an upper"
    @ 14,12 say "limit for acceptable performance."
    @ 15,12 say "The Browse windows are mouseable, and most of the feat-"
    @ 16,12 say "ures from the BROWSE command are available."
                  
    aRel:={nil, "customer->KEY"}

    select 0
    NetUse("INVOICE")
    set index to INVCUST
    select 0
    NetUse("CUSTOMER")
    set index to CUSTKEY
    set relation to KEY into INVOICE
    // define parameters for top CUSTOMER box
    aadd(aaFlds, {"KEY","NAME",{|| padr(trim(ADDRESS1)+" "+trim(ADDRESS2),36)},{|| CSZ(CITY,STATE,ZIP)},"COMPANY"})
    aadd(aaHdr, {"Key", "Name", "Address", "City/State/Zip","Company"})
    aadd(aCaps, "ENTER to Edit")
    aadd(aaHot, {K_ENTER})
    aadd(aaFunc, { {|| Alert("You pressed ENTER")} } )
    aadd(aaCoords, {1,2,11,78})


    // define parameters for bottom INVOICE box
    aadd(aaFlds, {"INV_NO","TRAN_DATE","TRAN_DESC",{|| BlZero(QUANTITY,8)},{|| BlZero(UNIT_PRICE,10)},"AMOUNT"})
    aadd(aaHdr, {"Invoice#","Inv Date","Item Description","Quantity","Unit Price","Amount"})
    aadd(aCaps, "ENTER to Edit")
    aadd(aaHot, {K_ENTER})
    aadd(aaFunc, { {|| Alert("You pressed ENTER")} } )
    aadd(aaCoords, {12,2,24,78})
    setcolor("n/w")

    Pause()

    cls
    MultiBrowse(,{"CUSTOMER","INVOICE"},aaFlds,aaHdr,aKolors,aaCoords,;
      {"CUSTOMERS","INVOICES"},{.f.,.t.},,aaHot,aaFunc,aCaps,aRel,;
      {.t.,.f.},nil,{1,1})

    close data
    popcolor()
    restore screen from cScr
RETURN

// concatenate city, state, zip
STATIC FUNCTION CSZ(cCity, cState, cZip)
LOCAL cCSZ:=padr(trim(cCity)+", "+cState+" "+trim(if(right(cZip,5)=="-    ",left(cZip,5),cZip)), 36)
    if alltrim(cCSZ) == ","
        cCSZ := space(36)
    endif
RETURN(cCSZ)

STATIC FUNCTION BlZero(nVar,nW)
RETURN(if(nVar==0,space(nW),padl(str(nVar),nW)))
