/*=======================================================================
    Program : dmomouse.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Thu  10-21-1993   12:15:57
     System : CLIX DEMO
    Compile : /m/n

      Notes : demo low level mouse functions



    Contains:
=======================================================================*/
#include "clxcmd.ch"
#include "events.ch"
#include "hotspot.ch"
#include "clxbox.ch"
#include "mouse.ch"

#define K_ESC       27
#define K_F10       -9

STATIC lExitNow:=.f.


/*-----------------------------------------------------------------------
   Function: DoMouse()
-----------------------------------------------------------------------*/
FUNCTION DoMouse()
LOCAL cScr
LOCAL aMnu:={ ;
              {"+b/*w","+w/r","+r/*w","w/*w","+w/b"},;
              {"~WaitEvent()","Traps keystrokes or Mouse Clicks",{|| WE()},.t.},;
              {"Mouse~Area()","Restricts mouse movements to an area",{|| MA()},.t.},;
              {"Mouse~Read()","Read mouse row/column and button press status",{|| MR()},.t.},;
              {"Mouse~On/Off()","Toggle mouse cursor on/off",{|| MOnOff()},.t.} ;
            }
    save screen to cScr
    setblink(.f.)
    ScrHead("Low Level Mouse Functions",{"+w/b","+r/b","+b/*gr","n/w"},2,.t.)
    DrawBox(8,31,18,75,"n/*b",,.t.)
    pushcolor("n/*b")
    @  9,33 say "CLIX has integrated the mouse into the"
    @ 10,33 say "standard Clipper user interfaces such as"
    @ 11,33 say "the GET and tbrowse classes, achoices(),"
    @ 12,33 say "menus, alert boxes, plus new functions"
    @ 13,33 say "such as hotspots and buttons, picklists,"
    @ 14,33 say "etc. In addition, there are several low"
    @ 15,33 say "level mouse functions which permit you"
    @ 16,33 say "to integrate the mouse into your own user"
    @ 17,33 say "interfaces."
    popcolor()
    do while .t.
        if (VertMenu(aMnu,8,5,.t.,"L",24) == 0)
            exit
        endif
    enddo
    restore screen from cScr
RETURN nil

STATIC FUNCTION WE()
LOCAL cW
    cW:=PopWind(8,31,18,75,"+w/r",B_SINGLE_DOUBLE,.t.,,pDB_SLIDER)
    pushcolor("+w/r")
    @  9,33 say "The WaitEvent() function provides a"
    @ 10,33 say "Clipper wait state that responds both"
    @ 11,33 say "to keystrokes and mouse clicks, acting"
    @ 12,33 say "on SET KEYS or mouse HotSpots automat-"
    @ 13,33 say "ically. It should be substituted for"
    @ 14,33 say "the INKEY() function."
    Pause(17,35,"+gr/r")

    ScrollBox(9,32,17,74,1)

    @  9,33 say "WaitEvent() returns an array (#defines"
    @ 10,33 say "in events.ch):"
    setcolor("w/r")
    @ 11,35 say "aEvent := WaitEvent()"
    @ 12,35 say "aEvent[EV_TYPE] = EV_KEY, keystroke"
    @ 13,35 say "      or        = EV_SGL_CLICK"
    @ 14,35 say "      or        = EV_DBL_CLICK"
    @ 15,35 say "if aEvent[EV_TYPE] == EV_KEY"
    @ 16,35 say "    nKey := aEvent[EV_KEY_VAL]"
    Pause(17,35,"+gr/r")

    ScrollBox(9,32,17,74,2)

    @  9,35 say "aEvent := WaitEvent()" color "+w/r"
    @ 10,35 say "if aEvent[EV_TYPE]==EV_SGL_CLICK ;"
    @ 11,35 say "  .or. aEvent[EV_TYPE]==EV_DBL_CLICK"
    @ 12,35 say "  nMouseRow := aEvent[M_ROW]"
    @ 13,35 say "  nMouseCol := aEvent[M_COL]"
    @ 14,35 say "  aEvent[EV_BTN] - EV_LEFT_BTN"
    @ 15,35 say "                 - EV_RIGHT_BTN"
    @ 16,35 say "                 - EV_BOTH_BTN"
    Pause(17,35,"+gr/r")
    Unpop(cW)
    popcolor()

RETURN nil

STATIC FUNCTION MA()
LOCAL cW:=PopWind(9,37,17,72,"r/*w",B_DOUBLE,.t.,"Restricted Area",pDB_EXPLODE)
LOCAL nID,aEvent,lExitNow:=.f.
    lExitNow:=.f.
    NewSpotStack()
    nID:=NewButton(BTN_TEXTBAR,13,47,"Click here to exit",{|| lExitNow:=.t.},"+w/b")
    MouseArea(10,38,16,71)
    do while !lExitNow
        aEvent:=WaitEvent()
        if aEvent[EV_TYPE]==EV_KEY .and. aEvent[EV_KEY_VAL]==K_ESC
            exit
        endif
    enddo
    UnPop(cW)
    KillSpotStack()
    MouseArea(0,0,maxrow(),maxcol())
RETURN nil

STATIC FUNCTION MR()
LOCAL lExitNow:=.f.,cW,nSetCursor,nLastRow:=0,nLastCol:=0,lLastR:=.f.,lLastL:=.f.
LOCAL aMInfo:=array(M_SIZE_ARRAY)
    cW := PopWind(10,38,15,68,"r/*w",,.t.)
    pushcolor("r/*w")
    nSetCursor:=setcursor(0)
    @ 14,45 say "Click here to exit" color "+w/b"
    @ 11,43 say "ROW:         COL:"
    @ 12,43 say "LEFT:        RIGHT:"
    do while !lExitNow
        MouseRead(aMInfo)
        if nLastRow<>aMInfo[M_ROW] .or. nLastCol<>aMInfo[M_COL]
            nLastRow:=aMInfo[M_ROW]
            nLastCol:=aMInfo[M_COL]
            @ 11,49 say str(nLastRow,2)
            @ 11,63 say str(nLastCol,2)
        endif
        if lLastL<>aMInfo[M_LEFT_PRESSED] .or. lLastR<>aMInfo[M_RIGHT_PRESSED]
            lLastL:=aMInfo[M_LEFT_PRESSED]
            lLastR:=aMInfo[M_RIGHT_PRESSED]
            @ 12,50 say if(lLastL,"X"," ")
            @ 12,64 say if(lLastR,"X"," ")
        endif
        if aMInfo[M_ROW] == 14 .and. Between(aMInfo[M_COL],45,62) .and. ;
          aMInfo[M_LEFT_PRESSED]
            exit
        endif
    enddo
    UnPop(cW)
    popcolor()
    setcursor(nSetCursor)
RETURN nil


STATIC FUNCTION MOnOff()
LOCAL cW1,cW2,aEvent,lSetMouse
    cW1:=PopWind(8,31,18,75,"b/*w",B_DOUBLE_SINGLE,.t.,,pDB_PULLDOWN)
    pushcolor("b/*w")
    @  9,33 say "MouseInit() - initializes mouse functions"
    @ 10,33 say "MouseOn()   - turns on mouse cursor"
    @ 11,33 say "MouseOff()  - disables mouse, cursor off"
    @ 12,33 say "SetMouse()  - get/set function for mouse"
    @ 13,33 say "              cursor state"
    @ 15,33 say "In general the mouse cursor should be"
    @ 16,33 say "turned off prior to writing to the screen"
    @ 17,33 say "to avoid what are known as 'mouse turds'."

    cW2:=PopWind(4,15,6,65,"+w/r")
    setcolor("+w/r")
    @ 5,17 say "Press F10 to toggle mouse cursor, ESC to exit"

    MouseOn()
    do while .t.
        aEvent := WaitEvent()
        if aEvent[EV_TYPE] == EV_KEY
            do case
                case aEvent[EV_KEY_VAL] == K_F10
                    lSetMouse := SetMouse()
                    SetMouse(!lSetMouse)
                case aEvent[EV_KEY_VAL] == K_ESC
                    MouseOn()
                    exit
            endcase
        endif
    enddo
    Unpop(cW2)
    Unpop(cW1)
    popcolor()
RETURN nil


