/*=======================================================================
    Program : dmofades.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Mon  07-05-1993   11:40:51
     System : CLIX DEMO
    Compile : /m/n

      Notes : Fades() demo
=======================================================================*/
#include "clxcmd.ch"
#include "fades.ch"

/*-----------------------------------------------------------------------
   Function: DoFades()
-----------------------------------------------------------------------*/
FUNCTION DoFades()
LOCAL cImg1,cImg2,cScr,lSetMouse:=SetMouse(.f.)
    save screen to cScr
    setblink(.t.)
    ScrHead("Slideshow type FADES",{"n/bg","+w/bg","+w/b","n/bg"},3,.f.)
    pushcolor("n/bg")

    @  7,15 say "FADE() - slideshow type fades for screen images" color "+w/bg"

    @  9,10 say "Syntax:"
    @ 10,15 say "Fade(nFadeType, cImg [,lDirection] [,nDelay])"

    @ 12,5 say "Fade() can lend flash and glitter to application opening screens."
    @ 13,5 say "There are 8 variations of fades with speed set by the nDelay parameter."

    Pause(15,,,"Press any key for a demonstration....")

    cImg1:=ReadScrn("clix.img")
    cImg2:=ReadScrn("cdb.img")

    Fade(F_SHADE, cImg1, F_DOWN, 1)
    FadeTtl("SHADE, down")
    inkey(1)
    Fade(F_SHADE, cImg2, F_UP, 1)
    FadeTtl("SHADE, up")
    inkey(1)
    Fade(F_CURTAIN, cImg1, F_RIGHT)
    FadeTtl("CURTAIN, right")
    inkey(1)
    Fade(F_CURTAIN, cImg2, F_LEFT)
    FadeTtl("CURTAIN, left")
    inkey(1)
    Fade(F_SPARKLE, cImg1)
    FadeTtl("SPARKLE")
    inkey(1)
    Fade(F_QUARTERS,cImg2,,2)
    FadeTtl("QUARTERS")
    inkey(1)
    Fade(F_HSTRIPE, cImg1)
    FadeTtl("HSTRIPE")
    inkey(1)
    Fade(F_VSTRIPE, cImg2)
    FadeTtl("VSTRIPE")
    inkey(1)
    popcolor()
    restore screen from cScr
    SetMouse(lSetMouse)
RETURN nil


STATIC FUNCTION FadeTtl(ctext)
    MsgBox(ctext,"+w/rb",,.f.,.t.,,.t.)
RETURN nil
