//  clxcmd.ch
//  (c) 1994 BERNATH COMPUTER
//  Thu  09-01-1994   20:42:50
//=================================================================

// DEFAULT for parameters passing. Thanks to Rick Spence for this one!
#command DEFAULT <p> to <val> [,<pn> to <valn>] ;
    => ;
    <p> = iif(<p> = NIL, <val>, <p>) ;
    [;<pn> = iif(<pn> = NIL, <valn>, <pn>)]

// COMPILE a codeblock formatted string
#define COMPILE(s)  &('{|| ' + s + '}')

// REPEAT WHILE
#command REPEAT => do while .t.
#command UNTIL <exp1> => if (<exp1>); exit; end; end



// @ .. PROMPT  and MENU TO substitute
#command @ <PrRow>, <PrCol> PROMPT <Prompt> [MESSAGE <Message> ] [WHEN <Active>] [HELPKEY <hk>];
   => MAKE_PRMPT( <PrRow>, <PrCol>, <Prompt>, <Message>, <Active>, <hk> )

#command MENU TO <v>  [COLORS <a>] [TRAPKEY <alT>] [<np: NOPAD>] ;
   =>  <v> := HOT_MENU(<v> ,<a>, <alT>, <.np.>)

// for PICK command on GET
#translate PICK <b> => SEND reader:=<b>

// Remove comments to cause Dialog() to be substituted for Alert()
//#xtranslate Alert([<parms,...>])  ;
//    => Dialog([<parms>])



// Set message command with COLOR
#command SET MESSAGE TO <n>                                             ;
             [<cent: CENTER, CENTRE>]                                   ;
             [COLOR <c>]                                                ;
             [MAXLEN <nl>]                                              ;
             [STYLE <ns>]                                               ;
      => SetMsgParm(<n>, <.cent.>, <c>, <nl>, <ns> )

// alternate SET KEY implementing a stack
#command SET KEY <n> TO <proc>                                          ;
    => KeySet(<n>, {|p,l,v| <proc>(p,l,v)})

#command SET KEY <n> [TO]                                               ;
      => KeySet( <n>, NIL )

// lock multiple records
#command MULTILOCK TO <lAll>                                            ;
         [WHILE <w>]                                                    ;
         [FOR   <f>]                                                    ;
         [RANGE <s> TO <e>]                                             ;
         [LIST  <a>]                                                    ;
    => <lAll> := GroupLock(<a>,<{w}>,<{f}>,{<s>,<e>})



// BROWSE command
#command BROWSE                                                         ;
            [FROM <t>,<l> TO <b>,<r>]                                   ;
            [FIELDS <aF>]                                               ;
            [HEADERS <aHdr>]                                            ;
            [PICTURES <aP>]                                             ;
            [VALID <aV>]                                                ;
            [EDIT <EditOK>]                                             ;
            [COLORS <cClrSpec>]                                         ;
            [MATCH <Srch>]                                              ;
            [RANGE <Srch>]                                              ;
            [FOR <bFor>]                                                ;
            [KEYS <aK>]                                                 ;
            [HOTSPOTS <aHot>]                                           ;
            [LOCK <nLock>]                                              ;
            [<dlk: DELOK>]                                              ;
            [<lb: LONGBAR>]                                             ;
            [<lU: UNIQUE>]                                              ;
            [<lInc: INCREMENTAL>]                                       ;
            [SEPS <aS>]                                                 ;
            [BOX <cBT>]                                                 ;
            [<lShad: SHADOW>]                                           ;
            [TITLE <cTitle>]                                            ;
            [CAPTION <cCaption>]                                        ;
            [MESSAGE <bMsg>]                                            ;
                                                                        ;
    => Browse(<t>,<l>,<b>,<r>,<aF>,<aHdr>,<aP>,<aV>,<EditOK>,<cClrSpec>,;
              <Srch>,<{bFor}>,<aK>,<aHot>,<nLock>,<.dlk.>,<.lb.>,nil,   ;
              <.lU.>,<.lInc.>,<aS>,<cBT>,<cTitle>,<cCaption>,<.lShad.>, ;
              <{bMsg}>)


// Add MESSAGE and HELPKEY clause to GET
#command @ <row>, <col> GET <var>                                       ;
                        [PICTURE <pic>]                                 ;
                        [VALID <valid>]                                 ;
                        [WHEN <when>]                                   ;
                        [MESSAGE <dispmsg>]                             ;
                        [HELPKEY <hk>]                                  ;
                        [SEND <msg>]                                    ;
                                                                        ;
      => SetPos( <row>, <col> )                                         ;
       ; AAdd(                                                          ;
               GetList,                                                 ;
               _GET_( <var>, <(var)>, <pic>, <{valid}>, <{when}> ):display() ;
             )                                                          ;
       ; LoadGetMSpot(ATail(GetList))                                   ;
      [; CargoPut(ATail(GetList), {"GETMSG", <dispmsg>})]               ;
      [; CargoPut(ATail(GetList), {"HELPKEY", <hk>})]                   ;
      [; ATail(GetList):<msg>]


// Radio Button redefine for GET

#command @ <row>, <col> [SAY <sayxpr>]                                  ;
                        GET <var>                                       ;
                        [COLOR <color>]                                 ;
                        [WHEN <when>]                                   ;
                        [MESSAGE <dispmsg>]                             ;
                        [SEND <msg>]                                    ;
                        WITH RADIOBUTTONS <buttons>                     ;
                        [<horiz: HORIZONTAL>]                           ;
                        [<single: SINGLE>]                              ;
                        [<double: DOUBLE>]                              ;
                                                                        ;
      => setpos( <row>, <col> )                                         ;
       ; dispbegin()                                                    ;
       ; aadd( GetList, _GET_( <var>, <(var)>,"9",, <{when}> ) )        ;
      [; CargoPut(ATail(GetList), {"GETMSG", <dispmsg>})]               ;
      [; atail(GetList):colorDisp(<color>)]                             ;
      [; atail(GetList):<msg>]                                          ;
       ; dispout(" ")                                                   ;
       ; RadioBtnNew( atail(getlist), <{when}>,                         ;
                     <row>, <col>, <sayxpr>, <var>,                     ;
                     <buttons>, <.single.>, <.double.>, <.horiz.> )     ;
       ; atail(getlist):reader := { |get| RadioBtnReader( get,          ;
                                          <.single.>, <.double.>,       ;
                                          <.horiz.>, <sayxpr> ) }                  ;
       ; dispend()


// CHECKBOX command for GETS
#command @ <row>, <col> GET <var> CHECKBOX <cStr>               ;
                        [COLOR <cKolor>]                        ;
                        [MESSAGE <cMsg>]                        ;
    =>  setpos(<row>, <col>)                                    ;
        ; CheckGet({|x| iif(x==NIL,<var>,<var>:=x)},<(var)>,    ;
                <cStr>,GetList,<cKolor>,<cMsg>)                 ;
        ;DrawCheck(atail(GetList))




#ifndef NO_MOUSE

//  mouse support header

#xtranslate Scroll([<parms,...>])       ;
    =>  MScroll(<parms>)

#xtranslate SaveScreen([<parms,...>])   ;
    =>  MSaveScreen(<parms>)


#xtranslate RestScreen([<parms,...>])   ;
    =>  MRestScreen(<parms>)


#xtranslate DevOut([<parms,...>])   ;
    =>  MDevOut(<parms>)


#xtranslate Qout([<parms,...>])   ;
    =>  MQout(<parms>)

#xtranslate SetMode([<parms,...>])  ;
    =>  MSetMode(<parms>)

#xtranslate DispBox([<parms,...>])  ;
    => MDispBox(<parms>)

// read
#command READ                                                  ;
         [PREGET <bPreG>]                                      ;
         [POSTGET <bPostG>]                                    ;
         [<lVA: VALIDALL>]                                     ;
      => ReadModal(GetList, {|| WaitEvent()}, <{bPreG}>, <{bPostG}>, <.lVA.>) ;
       ; GetList := {}

#else

// read
#command READ                                                  ;
         [PREGET <bPreG>]                                      ;
         [POSTGET <bPostG>]                                    ;
         [<lVA: VALIDALL>]                                     ;
      => ReadModal(GetList, {|| inkey(0)}, <{bPreG}>, <{bPostG}>, <.lVA.>) ;
       ; GetList := {}

#endif

// incremental date GET reader
#command @ <row>, <col> GET <var> [<clauses, ...>]             ;
           DATEINC [<moreClauses, ...>]                        ;
    => @ <row>, <col> GET <var> [<clauses>]                    ;
       SEND reader := {|get| DateGetR(get)}                    ;
       [<moreClauses>]



// combo box GET reader
#command @ <row>, <col> GET <var>                               ;
           [PICTURE <cPic>]                                     ;
           COMBO <choices>                                      ;
           [WHEN <bWhen>]                                       ;
           [VALID <bValid>]                                     ;
           [<lo: LISTONLY>]                                     ;
           [FROM <nT>,<nL> TO <nB>,<nR>]                        ;
           [BOXCOLOR <cBoxKolor>]                               ;
           [CAPTION <cCap>]                                     ;
           [MESSAGE <cMsg>]                                     ;
    => setpos(<row>,<col>)                                      ;
       ; aadd(GetList,                                          ;
        ComboGetNew({|x| if(x==NIL, <var>, <var>:=x)},          ;
           <(var)>, <cPic>, <{bWhen}>, <{bValid}>, <choices>,   ;
           {<nT>,<nL>,<nB>,<nR>},                               ;
           <cBoxKolor>, <cCap>, <cMsg>, <.lo.>))

// command interface to GenericEd()
#command EDIT WITH <bUdfBlock>                                          ;
         [COLORS <kolors>]                                              ;
         [TITLE  <cTitle>]                                              ;
         [LEGAL  <aLegalOp>]                                            ;
         [SEARCH <aSrch>]                                               ;
         [POST <abPostBlock>]                                           ;
         [ORDER <aaOrder>]                                              ;
         [OPTIONS <aOptMnu>]                                            ;
         [PAGES <nPages>]                                               ;
         [FIELDS <aBrow>]                                               ;
         [LOCK <nLock>]                                                 ;
         [<lNoSave: NOSAVESCR>]                                         ;
         [<lIsTag: ISTAG>]                                              ;
                                                                        ;
        =>GenericEd(<cTitle>,<bUdfBlock>,<kolors>,<aSrch>,<aLegalOp>,   ;
           <abPostBlock>,<aOptMnu>,<nPages>,<aBrow>,<nLock>,<.lNoSave.>,;
           <aaOrder>,<.lIsTag.>)

// COPY FIELDS command
#command COPY FIELDS FROM AREA <nSA> TO AREA <nDA> MAP <aaM> ;
           [KEY <bKey>]                         ;
           [WHILE <bWhile>]                     ;
           [FOR <bFor>]                         ;
           [NEXT <nNext>]                       ;
           [<lRest: REST>]                      ;
           [<lNA: NOAPPEND>]                    ;
          =>                                    ;
          CopyFields(<nSA>,<nDA>,<aaM>,<{bKey}>,<{bWhile}>,<{bFor}>,<nNext>,<.lRest.>,<.lNA.>)

#command MULTI                                                  ;
           ALIAS <aAl>                                          ;
           COORDS <aaCoord>                                     ;
           RELATE <aRel>                                        ;
           [INITSEEK <cInit>]                                   ;
           [FIELDS <aaFlds>]                                    ;
           [HEADERS <aaHdrs>]                                   ;
           [COLORS <aKolors>]                                   ;
           [TITLES <aTitles>]                                   ;
           [LONGBARS <alHi>]                                    ;
           [INCREMENTALS <alInc>]                               ;
           [UNIQUE <alUn>]                                      ;
           [HOTKEYS <aaKeys>]                                   ;
           [HOTFUNC <aaFunc>]                                   ;
           [CAPTIONS <aCaps>]                                   ;
           [FORBLOCKS <abFor>]                                  ;
           [LOCK <aLock>]                                       ;
           =>                                                   ;
           MultiBrowse(<cInit>,<aAl>,<aaFlds>,<aaHdrs>,<aKolors>,<aaCoord>, ;
                    <aTitles>,<alHi>,<alUn>,<aaKeys>,<aaFunc>,<aCaps>,      ;
                    <aRel>,<alInc>,<abFor>,<aLock>)

//  defines

#define _SHARED         .f.
#define _EXCLU          .t.

#define TRUE            .t.
#define FALSE           .f.

#define _ON             .t.
#define _OFF            .f.

#define _PG_EJECT       chr(12)
#define _CRLF           chr(13)+chr(10)

// Message Type defines
#define _MT_BLINE       1           // full line style
#define _MT_SWIN        2           // StatWin() style
#define _MT_USER        3           // user defined message style
