/*
 * File......: FTINT86.CH - Header file for users of FT_INT86() function
 * Author....: Ted Means
 * Date......: $Date:   15 Aug 1991 23:08:48  $
 * Revision..: $Revision:   1.2  $
 * Log file..: $Logfile:   E:/nanfor/src/ftint86.chv  $
 * 
 * This is an original work by Ted Means and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log:   E:/nanfor/src/ftint86.chv  $
 * 
 *    Rev 1.2   15 Aug 1991 23:08:48   GLENN
 * Forest Belt proofread/edited/cleaned up doc
 * 
 *    Rev 1.1   27 May 1991 13:25:18   GLENN
 * Revised for new version of ft_int86() package, which is written in C
 * (CINT86.C), assembler (AINT86.ASM).  
 * 
 *    Rev 1.0   01 Apr 1991 01:02:38   GLENN
 * Nanforum Toolkit
 *   
 *
 */

#define AX         1
#define BX         2
#define CX         3
#define DX         4
#define SI         5
#define DI         6
#define BP         7
#define DS         8
#define ES         9
#define FLAGS     10

#define INT86_MAX_REGS       10

#translate makehi( <X> )   => (<X> * (2 ^ 8))

#translate REG_DS => .T.

#translate REG_ES => .F.

#translate highbyte( <X> ) => int( <X> / 256 )

#translate lowbyte( <X> )  => int( <X> % 256 )

#define UNSIGNED(n)   (n)
#define I2BYTE(n)     chr(n)
#define BYTE2I(c)     asc(c)

#define INT21       33
