//  clxtext.ch
//  (c) 1993 BERNATH COMPUTER
//  definitions for Text File commands

#command TEXT USE <(cFile)>                                         ;
                   [ALIAS <cAlias>]                                 ;
                   [<lNew: NEW>]                                    ;
    =>  TxtUse(<(cFile)>, <"cAlias">, <.lNew.>)

#command TEXT CLOSE [<area>]                                        ;
    =>  TxtClose(<area>)

#command TEXT GO TOP [<area>]                                       ;
    => TxtGoTop(<area>)

#command TEXT GO BOTTOM [<area>]                                    ;
    => TxtGoBottom(<area>)

#command TEXT GOTO <nLine>                                          ;
                   [IN <area>]                                      ;
    => TxtGoTo(<nLine>, <area>)

#command TEXT SELECT <area>                                         ;
    => TxtSelect(<area>)

#command TEXT LOCATE <(str)>                                        ;
                      [IN <area>]                                   ;
                      [<lCase: CASE>]                               ;
    => TxtLocate(<(str)>, <area>, <.lCase.>, .f.)

#command TEXT LOCATE CONTINUE [IN <area>]                           ;
    => TxtLocate(NIL, <area>, NIL, .t.)

#command TEXT APPEND <Line> [IN <area>]                             ;
    => TxtAppend(<Line>, <area>)

#command TEXT SKIP                                                  ;
       [IN <area>]                                                  ;
    => TxtSkip(1, <area>)

#command TEXT SKIP <nHowMany>                                       ;
                   [IN <area>]                                      ;
    => TxtSkip(<nHowMany>, <area>)
