/*=======================================================================
    Program : dmobrows.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Wed  12-15-1993   08:49:03
     System : CLIX DEMO
    Compile : /m/n

      Notes : BROWSE command demo
=======================================================================*/
#include "clxcmd.ch"
#include "clxbox.ch"
#include "inkey.ch"

/*-----------------------------------------------------------------------
   Function: DoBrows()
-----------------------------------------------------------------------*/
FUNCTION DoBrows()
LOCAL cScr,cW,dLoDate,dHiDate,lSetMouse:=SetMouse()
LOCAL aFlds:= {"KEY","NAME","COMPANY","ADDRESS1","ADDRESS2","CITY","STATE","ZIP","PHONE", "HISTORY", "SALES", "OTHERCHG", "PAYMENTS", {|| SALES+OTHERCHG+PAYMENTS} }
LOCAL aHdrs:={"Key","Contact","Company","Address","Address","City","State","Zip","Phone", "History", "Sales", "Other","Payments", "Net"}
LOCAL aPics:={"@!",NIL,NIL,NIL,NIL,NIL,"!!","99999-9999","(999)999-9999",NIL,"99999.99","99999.99","99999.99","99999.99"}
LOCAL aEdit,cKolor,aaHot
LOCAL aKeys:={  {K_ALT_A, {|| Dialog("You pressed Alt-A")} },;
                {K_ALT_B, {|| Dialog("You pressed Alt-B")} }   }
    save screen to cScr
    ScrHead("BROWSE COMMAND",{"+w/b","+r/b","+b/*gr","n/w"},2,.f.)
    pushcolor("w/b")
    @  6,3 say "The CLIX BROWSE command provides a simple interface to the very flexible"
    @  7,3 say "but complicated Clipper tbrowse class FUNCTIONs.  The CLIX BROWSE is feat-"
    @  8,3 say "ure rich, and you can start from as simple as saying BROWSE, and add capa-"
    @  9,3 say "bility by specifying optional keywords and parameters for those features"
    @ 10,3 say "you want to include."
    CenterLine("FEATURES:","+gr/b",12)
    setcolor("+bg/b")
    @ 13,8 say " Mouseable Browse"
    @ 14,8 say " Box with shadow, title, and caption"
    @ 15,8 say " Filtered tbrowse with WHILE and FOR condition, or RANGE"
    @ 16,8 say " Columns may be specified as editable or non-editable, with"
    @ 17,8 say "  PICTURE, VALID, and WHEN clause for each column"
    @ 18,8 say " User defined Hotkeys, and mouse hotspots"
    @ 19,8 say " Incremental search"
    @ 20,8 say " Lock columns"
    Pause(22,,"+gr/b")
    ScrollBox(4,2,22,77,1)
    CenterLine("FEATURES:","+gr/b",6)
    @  8,8 say " Multiline headers"
    @  9,8 say " UNIQUE clause"
    @ 10,8 say " Color control"
    @ 11,8 say " Allow or not allow deletion of records"
    @ 12,8 say " LONGBAR cursor bar option spans whole row"
    @ 13,8 say " MESSAGE option allows a displays the EVAL of a codeblock on"
    @ 14,8 say "  the caption line"
    Pause(22,,"+gr/b")
    ScrollBox(4,2,22,77,-1)
    CenterLine("SYNTAX:","+gr/b",5)
    setcolor("+w/b")
    @  6,10 say "BROWSE [FROM <nTop>,<nLeft> TO <nBott>,<nRight>]        ;"
    @  7,10 say "       [FIELDS <aF>] [HEADERS <aH>]                     ;"
    @  8,10 say "       [PICTURES <aP>] [VALID <aV>] [EDIT <EditOK>]     ;"
    @  9,10 say "       [COLORS <cClrSpec>] [SEPS <aS>] [BOX <cBT>]      ;"
    @ 10,10 say "       [SHADOW] [TITLE <cTitle>] [RANGE aRange]         ;"
    @ 11,10 say "       [CAPTION <cCaption>] [MESSAGE <bMsg>]            ;"
    @ 12,10 say "       [KEYS <aK>] [LOCK <nLock>] [DELOK] [LONGBAR]     ;"
    @ 13,10 say "       [UNIQUE] [INCREMENTAL] [HOTSPOTS aaHot]          ;"
    @ 14,10 say "       [MATCH <cMatch>] [FOR <cFor>]"

    setcolor("w/b")
    CenterLine("All items in [ ] are optional and have default values.","w/b",17)
    Pause(22,,"+w/b")

    setcolor("w/n,n/w")
    aEdit:=array(len(aFlds))
    afill(aEdit,.t.)
    aEdit[1]:=.f.
    aEdit[2]:=.f.
    aEdit[len(aEdit)]:=.f.
    cKolor := "B/W,W/B,B/W,+W/R,R/W"
    aaHot:={"+W/*B,W/B",;
            {"Current Field", {|b,c| c:=b:getColumn(b:colPos), alert("Current field is "+CargoGet(c, "FNAME")+";"+;
                            Any2Str(eval(c:block)))} },;
            {"Go Top", {|b| b:goTop()} },;
            {"Go Bottom", {|b| b:goBottom()} } ;
           }
    cls
    use customer index custkey
    @ 0,1 say "Example1: Fields, headers, pictures specified. Edit, delete OK. Incremental Search"
    @ 2,1 say "BROWSE FROM 5,5 TO 19,75 FIELDS aFlds HEADERS aHdrs PICTURE aPics ;"
    @ 3,1 say "       COLORS cKolor EDIT aEdit DELOK LOCK 1 INCREMENTAL KEYS aKeys"
    @ 4,1 say '       HOTSPOTS aaHot TITLE "Hotspots and Editing"'
    BROWSE FROM 6,5 TO 19,75 FIELDS aFlds HEADERS aHdrs PICTURE aPics ;
           COLORS cKolor EDIT aEdit DELOK LOCK 1 INCREMENTAL ;
           HOTSPOTS aaHot TITLE "Hotspots and Editing"

    cls
    @ 0,1 say "Example2: default fields and headers. No edit, longbar"
    @ 2,1 say "BROWSE FROM 5,5 TO 18,75 COLORS cKolor LOCK 1 LONGBAR ;"
    @ 3,1 say '  TITLE "Longbar and HotKeys" KEYS aKeys '
    @ 4,1 say '  CAPTION "Alt-A  Alt-B"'
    cKolor:="BG/B,B/BG"
    BROWSE FROM 6,5 TO 18,75 COLORS cKolor LOCK 1 LONGBAR KEYS aKeys ;
           TITLE "Longbar and HotKeys" CAPTION "Alt-A   Alt-B"

    cls
    use invoice index invcust
    @ 0,1 say "Example3: Filtered to customer JOYERO. Limited edits."
    @ 2,1 say 'BROWSE FROM 5,5 TO 18,75 FIELDS aFlds HEADERS aHdrs COLORS cKolor ;'
    @ 3,1 say '       EDIT aEdit LOCK 1 MATCH "JOYERO" TITLE "Filtered"'
    cKolor:="R/W,W/R,R/W,+GR/R"
    aFlds:={"KEY","INV_NO","ITEM_NO","TRAN_DESC","TRAN_DATE","AMOUNT"}
    aHdrs:={"Key","Inv#","Item#","Description","Date","Amount"}

    aEdit:=array(len(aFlds))
    afill(aEdit, .t.)
    aEdit[1]:=.f.
    aEdit[2]:=.f.
    aEdit[3]:=.f.
    BROWSE FROM 5,5 TO 18,75 FIELDS aFlds HEADERS aHdrs COLORS cKolor ;
           EDIT aEdit LOCK 1 MATCH "JOYERO" TITLE "Filtered"

    cls
    @ 0,1 say "Example4: Both MATCH and FOR clauses."
    @ 2,1 say 'BROWSE FROM 5,5 TO 18,75 FIELDS aFlds HEADERS aHdrs COLORS cKolor ;'
    @ 3,1 say '       LOCK 1 MATCH "JOYERO" FOR year(TRAN_DATE)=1992 ;'
    @ 4,1 say '       SEPS {"","  ",""}'
    cKolor:="N/BG,+BG/N,N/BG"
    BROWSE FROM 6,5 TO 18,75 FIELDS aFlds HEADERS aHdrs COLORS cKolor ;
           LOCK 1 MATCH "JOYERO" FOR year(TRAN_DATE)=1992 BOX B_NOBOX ;
                SEPS {"","  ",""}


    cls
    MakeDates()
    use dates index dates
    @ 0,1 say "Example 6: RANGE filtered."
    @ 2,1 say 'BROWSE FROM 5,15 TO 18,65 RANGE {dtos(dLoDate), dtos(dHiDate)} ;'
    @ 3,1 say '       COLORS cKolor LONGBAR BOX B_SINGLE_DOUBLE SHADOW'
    do while .t.
        cW:=PopWind(7,20,10,50,"+w/g",B_SINGLE_DOUBLE,.t.,"Choose date range:")
        dLoDate:=ctod("03/01/93")
        dHiDate:=ctod("06/13/93")
        pushcolor("+w/g,+w/n")
        set cursor on
        @ 8,22 say " Low date:" get dLoDate
        @ 9,22 say "High date:" get dHiDate
        read
        popcolor()
        Unpop(cW)
        if lastkey() == K_ESC
            exit
        endif
        cKolor:="+W/G,+W/N"
        SetMouse(lSetMouse)
        BROWSE FROM 5,15 TO 18,65 RANGE {dtos(dLoDate), dtos(dHiDate)} ;
               TITLE "Range Filtered" ;
               COLORS cKolor LONGBAR BOX B_SINGLE_DOUBLE SHADOW
    enddo
    SetMouse(lSetMouse)
    close data
    erase dates.dbf
    erase ("DATES"+indexext())
    popcolor()
    restore screen from cScr
RETURN NIL


STATIC FUNCTION MakeDates()
LOCAL aD:={  {"DATEF","D",8,0},;
             {"DATEC","C",32,0} }
LOCAL i,dDate:=ctod("01/01/93")
    if !file("DATES.DBF")
        dbCreate("DATES", aD)
        use DATES exclusive
        for i:=0 to 364
            append blank
            replace DATEF with dDate+i,;
                    DATEC with cdow(dDate+i)+", "+MDY(dDate+i)
        next

        index on dtos(DATEF) to DATES
        use
    endif
RETURN nil

