/*=======================================================================
    Program : dmobox.prg
    (c) 1993 BERNATH COMPUTER all rights reserved
       Date : Fri  07-09-1993   15:26:56
     System : CLIX DEMO
    Compile : /m/n

      Notes : demo of box drawing

=======================================================================*/
#include "clxcmd.ch"
#include "clxbox.ch"

/*-----------------------------------------------------------------------
   Function: DoBox()
   Function: DrawBox(nT,nL,nB,nR,cFrameClr,cFrame,lShadow,cTitle,nDispMode)
-----------------------------------------------------------------------*/
function DoBox()
local cScr
    setblink(.f.)
    save screen to cScr
    ScrHead("Fancy Box Drawing",{"+w/rb","+gr/rb","+w/bg","r/b"},3,.t.)
    pushcolor("+w/rb")
    @  7,5 clear to 11,75
    @  7,7 say "CLIX boxes come in a variety of border styles, with optional non-"
    @  8,7 say "destructive (see thru) shadow, optional title, control over color,"
    @  9,7 say "and various 'exploding' display modes.  In addition, there is a 3D"
    @ 10,7 say "mode which does a halfway decent simulation of a three dimensional"
    @ 11,7 say "box."
    Pause(,,,"Press any key for a demonstation....")
    DrawBox(6,2,10,26,"+w/b",B_SINGLE,.t.,"Single line")
    DrawBox(8,7,12,31,"+gr/g",B_DOUBLE,.t.,"Double line")
    DrawBox(10,12,14,36,"w/r",B_SINGLE_DOUBLE,.t.,"Single/Double line")
    DrawBox(12,17,16,41,"n/w",B_DOUBLE_SINGLE,.t.,"Double/Single line")
    DrawBox(14,22,18,46,"+bg/bg",B_THICK,.t.,"Thick line")
    DrawBox(16,27,20,51,"+w/rg",B_NOBOX,.t.,"No frame")
    inkey(5)
    DrawBox(6,5,20,75,"n/*gr",B_DOUBLE,.t.,"EXPLODING!!",pDB_EXPLODE)
    DrawBox(8,15,18,65,"w/b",B_DOUBLE,.t.,"PULLDOWN!!",pDB_PULLDOWN)
    DrawBox(10,25,16,55,"+w/g",B_DOUBLE,.t.,"SLIDE RIGHT!!",pDB_SLIDER)
    Pause()
    DrawBox(6,5,20,70,IN,B_3D,.t.)
    DrawBox(8,10,11,20,OUT,B_3D,.f.)
    @ 9,14 say "ONE" color "+w/w"
    DrawBox(8,55,11,65,OUT,B_3D,.f.)
    @ 9,59 say "TWO" color "+w/w"
    DrawBox(8,30,18,34,IN,B_3D,.f.)
    DrawBox(8,40,18,44,IN,B_3D,.f.)
    pushcolor("n/w")
    @ 11,32 say "T"
    @ 12,32 say "H"
    @ 13,32 say "R"
    @ 14,32 say "E"
    @ 15,32 say "E"

    @ 12,42 say "D"
    @ 13,42 say "E"
    @ 14,42 say "E"
    popcolor()
    DrawBox(15,10,18,20,OUT,B_3D,.f.)
    @ 16,13 say "THREE" color "+w/w"
    DrawBox(15,55,18,65,OUT,B_3D,.f.)
    @ 16,58 say "FOUR" color "+w/w"
    inkey(2)
    Depress(8,10,11,20)
    delay(9)
    Depress(8,55,11,65)
    delay(9)
    Depress(15,10,18,20)
    delay(9)
    Depress(15,55,18,65)
    Pause()
    popcolor()
    restore screen from cScr
return NIL


/*-----------------------------------------------------------------------
   Function: DoPopWin()
-----------------------------------------------------------------------*/
function DoPopWin()
local cScr,aWin:={},cW1,cW2,cW3
    save screen to cScr
    ScrHead("Standard Popup Windows",{"+w/rb","+gr/rb","+w/bg","r/b"},3,.t.)
    pushcolor("+w/rb")
    @  7,5 clear to 11,75
    @  7,7 say "CLIX windows come in two types; 'standard' windows that are LAST ON,"
    @  8,7 say "FIRST off in 'popping' order, and window objects which can be moved,"
    @  9,7 say "sized, and brought to the top."
    @ 10,7 say "The standard windows come in all the styles as CLIX boxes, and in"
    @ 11,7 say "addition can be removed in various 'exploding' methods."
    setcolor("+gr/rb")
    @ 13,10 say "Syntax:"
    @ 14,15 say "cWin:=PopWind(nT,nL,nB,nR,cClr,cFrame,lShad,cTitle,nDispType)"
    @ 16,10 say "The window is removed with the Unpop() function."
    Pause(,,,"Press any key for a demonstration....")
    aadd(aWin,PopWind(4,2,7,12,"15/0"))
    aadd(aWin,PopWind(4,15,7,25,"15/1"))
    aadd(aWin,PopWind(4,28,7,38,"15/2"))
    aadd(aWin,PopWind(4,41,7,51,"15/3"))
    aadd(aWin,PopWind(4,54,7,64,"15/4"))
    aadd(aWin,PopWind(4,67,7,77,"15/5"))
    aadd(aWin,PopWind(9,67,12,77,"15/6"))
    aadd(aWin,PopWind(14,67,17,77,"15/7"))
    aadd(aWin,PopWind(19,67,22,77,"15/8"))
    aadd(aWin,PopWind(19,54,22,64,"0/9"))
    aadd(aWin,PopWind(19,41,22,51,"0/10"))
    aadd(aWin,PopWind(19,28,22,38,"0/11"))
    aadd(aWin,PopWind(19,15,22,25,"0/12"))
    aadd(aWin,PopWind(19,2,22,12,"0/13"))
    aadd(aWin,PopWind(14,2,17,12,"0/14"))
    aadd(aWin,PopWind(9,2,12,12,"0/15"))
    cW1:=PopWind(10,25,17,54,"n/bg",B_DOUBLE,.f.,,pDB_EXPLODE)
    cW2:=PopWind(11,30,16,49,"w/r",B_DOUBLE,.f.,,pDB_SLIDER)
    cW3:=PopWind(12,35,15,44,"+gr/gr",B_DOUBLE,.f.,,pDB_PULLDOWN)
    inkey(3)
    UnPop(cW3,pDB_PULLUP)
    UnPop(cW2,pDB_SLIDEL)
    UnPop(cW1,pDB_IMPLODE)
    for i:=len(aWin) to 1 step -1
        Unpop(aWin[i])
        Delay(2)
    next
    inkey(3)
    popcolor()
    restore screen from cScr
return NIL
/*-----------------------------------------------------------------------
   Function: DoWinob()
-----------------------------------------------------------------------*/
function DoWinObj()
local nWH1,nWH2,nWH3,i,cScr
    save screen to cScr
    ScrHead("Window Objects",{"+w/rb","+gr/rb","+w/bg","r/b"},3,.t.)
    pushcolor("+w/rb")
    @  7,5 clear to 10,75
    @  7,7 say "CLIX window objects are moveable, sizeable, and are not limited"
    @  8,7 say "to the last on, first off, method of popping. They can be made"
    @  9,7 say "invisible and then visible, brought to the top of the stack."
    Pause()
    nWH1:=MakeWind(8,15,15,40,"N/BG",B_DOUBLE,.t.,"Test window",2)
    SayInWin(nWH1,0,0,"Scoobee doobee doo")
    SayInWin(nWH1,2,0,"This line should be truncated ya know","+W/BG")
    nWH2:=MakeWind(12,25,18,73,"+W/R",B_SINGLE,.t.,"Here is a second window")
    SayInWin(nWH2,2,1,"Now nummer2 WinOnTop()","+W/R")
    nWH3:=MakeWind(6,35,14,65,"+GR/G",B_SINGLE_DOUBLE,.t.,"Thirdly")
    for i:=0 to 6
        SayInWin(nWH3,i,0,"'Nuther window  'Nuther window")
    next
    nWH4:=MakeWind(9,45,15,70,"+BG/RB",B_THICK,.t.,"Go FOURTH!",pDB_PULLDOWN)
    inkey(3)
    HideWind(nWH2)
    inkey(3)
    ShowWind(nWH2)
    inkey(3)
    Win2Top(nWH1)
    inkey(3)
    Win2Top(nWH3)
    inkey(3)
    for i:=1 to 5
        MoveWind(nWH3,.f.,-1,2)
        inkey(1)
    next
    Win2Top(nWH1)
    SayInWin(nWH1,3,2,"I'm gonna grow!!")
    inkey(1)
    SizeWind(nWH1,.f.,6,8)
    SayInWin(nWH1,3,2,"I grewded!","+GR/BG")
    inkey(2)
    KillAllW(pDB_SLIDEL)
    setcursor(1)
    popcolor()
    restore screen from cScr

return NIL
