/*
  VGAHELP.PRG

  Author .... D.B. McDonald  [ CIS 76334,3521 ]
  Update .... February 17, 1992
  Version ... 1.00.00
  Compiler .. CLIPPER 5.01 using options /M /N /W

  VgaColor Help routinte

*/
#include "vgacolor.ch"

#define TOP     4
#define LEFT    10
#define BOTTOM  16
#define RIGHT   70

#define HELP_TEXT { ;
                    "F1         VGA Color TAble Help", ;
                    "F3         Load a 48 byte VGA text file", ;
                    "F4         Save a 48 byte VGA text file", ;
                    "SHFT/F5    Decrement/Increment VGA palette", ;
                    "SHFT/F6    Decrement/Increment Red Tint", ;
                    "SHFT/F7    Decrement/Increment Green Tint", ;
                    "SHFT/F8    Decrement/Increment Blue Tint", ;
                    "F9         Reset VGA palette to defaults", ;
                    "F10        Toggle SetBlink bit" ;
                  }

* --------------------------------------------------------------------------- *
Function VgaHelp( cClr )
*    Display HELP window
* --------------------------------------------------------------------------- *
   local nShadow := wSetShadow( nToColor( SHADOW_COLOR ) )
   local nWin := wSelect()

   //... Display Help Window
   DispBegin()
   wOpen( TOP, LEFT, BOTTOM, RIGHT )
   setcolor( cClr )
   wBox( THICK_LINE )
   aeval( HELP_TEXT, { |s,r| wSay( r, 4, s ) } )
   DispEnd()

   inkey(0)
   wClose()       

   wSetShadow( nShadow )
   wSelect( nWin )

return NIL

* --------------------------------------------------------------------------- *
* EOF: VGAHELP.PRG				February 17, 1992 at 14:57:46
* --------------------------------------------------------------------------- *

