/*
  VGACOLOR.PRG

  Author .... D.B. McDonald  [ CIS 76334,3521 ]
  Update .... February 17, 1992
  Version ... 1.00.00
  Compiler .. CLIPPER 5.01 using options /M /N /W

  This application is a variation of Nantucket Tools II Color Editor, COLORPAL.
  I found COLORPAL somewhat clunky and in my arrogance decided to design a
  better mouse trap.

  As VGA graphics is the bare minimum in the world of PC computers, I have
  written this application assuming you are using a COLOR VGA computer.  If
  you're not, CHANGE!!!

*/
#include "vgacolor.ch"

* --------------------------------------------------------------------------- *
procedure main( fVGA )
* --------------------------------------------------------------------------- *
   local aCodeBlock                             
   local nCursor := SetCursor( SC_NONE )
   local cSavClr := SetColor( 'w/b,+w/b,,,b/w' )

   //... Paint background window                      
   DispBegin()
   wSay(  0,0, PadC( expand( "VGA Color Palette Editor" ), 80 ), getcolor( UNSELECT ) )
   wSay( 24,0, PadR( "  F1: HELP    ESC: Exit Application  ", 80 ), getcolor( UNSELECT ) )
   DispBox( 1,0,23,79, replicate( "", 9 ) )
   DispEnd()

   //... Use existing 48 byte VGA text file if it exists
   if fVGA # NIL
      FileVgaPal( fVGA )
   endif

   //... Add key codes to color table
   aCodeBlock := { ;
                   { K_F1, { || VgaHelp( '+w/r' ) } }, ;
                   { K_F2, { || sound( 1000,1 )   } }, ;
                   { K_F3, { || LoadVga( @fVGA, '+w/br' ) } }, ;
                   { K_F4, { || SaveVga( @fVGA, '+w/br' ) } }  ;
                 }

   //... Paint Color Table
   SetColor( cSavClr )
   ColorTable( aCodeBlock )

   //... Reset everything
   setblink( .T. )
   vgaPalette()
   clear screen
   SetCursor( nCursor )

return


* --------------------------------------------------------------------------- *
* EOF: VGACOLOR.PRG				February 17, 1992 at 14:22:59
* --------------------------------------------------------------------------- *

