*
*	BOXDBF, listed below, is an all-purpose scroll box. It is based
*	on Dirk Lesko's MAXDBF(). 
*
*	ARGUMENTS: 
*	
*		TOP,LEFT,BOTTOM,RIGHT are integers.
*
*		FIELDS,TITLES are arrays. All array elements must be character
*		strings. FIELD array elements may be functions as long as they
*		return a fixed-length string. The TITLES array is optional. If it
*		is not passed, however, the box cannot scroll left to right.
*
*		KEYFUNC() is an optional user-defined keystroke handling function 
*		which operates similarly to the DBEDIT keystroke handling functions.
*		Return 0 to quit the box, return 1 to go back to the box, or return
*		2 to go back to the box after re-painting it.
*
*		HEADCOLOR, INTERIORCOLOR, and BARCOLOR are integers. A function may
*		be passed (instead of an integer) as the INERIORCOLOR. It can be 
*		used to display different colors in the box depending on the content
*		of what is displayed.
*
*		WHILECONDITION, and FORCONDITION are optional "while" and "for" 
*		clauses. They are strings that contain logical expressions.
*
*		SEEKVAR is a "seek" variable that is required only if a 
*		WHILECONDTION other that ".t." is passed. It is necessary to insure
*		that the user can quickly go to the first record.
*
*		SAYELSE() is an optional use-defined function tht can be used to
*		display other data (related to the highlighted record) elsewhere
*		on the screen.
*
*
*		EXAMPLE OF USAGE:
*
*  PRIVATE fields[3],titles[3]
*
*  fields[1] = [transcode]
*  fields[2] = [TRANSFORM(hours,"99.9")]
*  fields[3] = [TRANSFORM(amount,"999,999.99")]
*
*  titles[1] = [TRANSACTION]
*  titles[2] = [HOURS]
*  titles[3] = [AMOUNT]
*
*  SELECT transact
*
*  GO TOP
*
*  BOX(19,10,22,62) 
*
*  BOX(07,20,16,60,M_FRAME(),23,3,8)
*
*  PRINT(07,21,[INDIVIDUAL TIME AND FEE ENTRY],30)
*
*  boxdbf(8,21,15,59,fields,titles,[keyfunc()],30,23,112,;
*				[],[p_name_no = mp_name_no],[],[batbotdisp()])
*
*
****************************************************************************

3FUNCTION boxdbf

	EXTERNAL untrim

	PARAMETER _trow, _tcol, _brow, _bcol, _fields, _fhead1, _keyfunc,;
				 __headcol, __color, __barcol, _criteria1, _criteria2, seekvar,;
				 _special

	PRIVATE 	_trow      ,;	    && top
			_tcol      ,;	    && left
			_brow      ,;	    && bottom
			_bcol      ,;	    && right
			__color    ,;	    && internal color
			__barcol   ,;      && bar color
          	_alen      ,; 	    && number of rows
			_width     ,; 	    && width of box
			_pkey      ,; 	    && key-pressed variable
			_plast     ,; 	    && last active row
			_pactive   ,; 	    && current active row
			_header    ,;	    && header string (column headings)
			_temp      ,;      && temprorary variable
			_tempstr   ,;	    && temporary string variable
          	_tempstr2  ,; 	    && temporary string variable
			_fieldnum  ,; 	    && field number variable
			_fcount    ,; 	    && number of fields in _fields[]
			_temprec   ,;	    && current record number at start 
		  	__coltype  ,;	    && variable type of color parameters
			_keyretrn  ,;	    && contains return value from key-function
			__pan      ,;	    && logical - is panning left or right allowed?
			_mess_scrn ,;	    && to hold line-24 message screen area
			_start     ,;	    && line to start box lines (either top or down 1)
		  	_blob      ,;	    && a dummy variable
			__headyn	  ,;	    && number to determine where (or if) heading should be placed
			func_colyn ,;	    && is the color that's passed a function?
			_top       ,;	    && top of message box
			_bot       ,;
			_left	     ,;
			_right     ,;
			_mess_scrn ,;	    && message screen
			_ikey      ,;
			mseekvar	  ,;
			_macstring ,;
			_x         ,;
			sflag		   	&& search flag

	* make sure five parameters are passed
	**************************************
	IF PCOUNT() < 5
		RETURN(-8)
	ENDIF

  * make sure there is a DBF open and the arrays are present
  **********************************************************  
  IF !USED()
     M_DATA(30,-8)          					 	&& notify MMA
     RETURN(-8)              					&& no DBF in use
  ENDIF

  * if there is a DBF open, store the current recno()
  * in case they escape out, or click outside the window area
  *********************************************************** 
  _temprec = RECNO()

	* check for header
	******************
	IF TYPE([_fhead1]) != [A]

		__headyn = -1                          && don't display a header
		_start = 1

		PRIVATE _fhead1[len(_fields)]

	ELSE

		__headyn = 0			   			&& display header 
		_start = 0

	ENDIF

	* check for colors
	******************
	_coltype   = TYPE([__color])
	func_colyn = .F.

	IF _coltype = [C] 

			func_colyn = .T.

	ELSEIF _coltype = [U]

		__color = 23

	ENDIF

	IF TYPE([__headcol]) != [N]

		__headcol = 30

	ENDIF

	IF TYPE([__barcol]) != [N]

		__barcol = 23

	ENDIF

  * check for conditions
  **********************
  IF TYPE([_criteria1]) != [C]

     _criteria1 = [.t.]
								 
	ELSEIF EMPTY(_criteria1)

     _criteria1 = [.t.]

	ELSEIF UPPER(_criteria1) != [.T.] 
	
		IF  TYPE([seekvar]) = [U] 

			RETURN(-9)

		ELSEIF EMPTY(seekvar)

			RETURN(-9)

		ENDIF

  ENDIF

  IF TYPE([_criteria2]) != [C]
 
     _criteria2 = [.t.]

  ELSEIF EMPTY(_criteria2)

  	_criteria2 = [.t.]

  ENDIF

	* check for _keyfunc
	********************
  	IF TYPE([_keyfunc]) != [C]

		_keyfunc = "_defky()"

	ELSEIF TYPE([_keyfunc]) != [U]

		IF EMPTY(_keyfunc)

			_keyfunc = "_defky()"

		ENDIF

	ENDIF

	* check for _special
	********************
	IF TYPE([_special]) != [C]

		_special = "dummy()"

	ENDIF

  * variables to store keystroke, active, and last active elements
  * temporary strings and whatnot
  ****************************************************************
  _pkey      = 0                    
  _plast     = 1                    
  _pactive   = 1                    
  _tempstr   = ""
  _tempstr2  = ""
	_header    = ""
  	_fcount    = LEN(_fields)
	_macstring = ""
	__pan      = IIF(M_DATA(23) = 1,.T.,.F.)
	_mess_scrn = SAVESCREEN(24,0,24,79)
	_blob      = []
	sflag      = .F.


  * declare the array that holds the offsets for scrolling
  ********************************************************
  PRIVATE _offset[LEN(_fields)],_fheader[LEN(_fhead1)]

	ACOPY(_fhead1,_fheader)

  * setup the header string and the offsets for each field
  * and a macro string to expand on each record change
  ********************************************************
  FOR _x = 1 TO _fcount

     _tempstr = _fields[_x]
     _temp    = LEN(&_tempstr)

		IF __headyn = 0

  		   _offset[_x]  = LEN(_header)+1
	        _fheader[_x] = UNTRIM(_fheader[_x],;
		   					MAX(_temp,LEN(_fheader[_x])+1)+1) 
	        _header      = _header+_fheader[_x]
	  
	       IF (LEN(_macstring)+LEN(_fields[_x])+8 > 190)
  	         LOOP
     	  ELSE
        	    _macstring = _macstring+"+UNTRIM("+_fields[_x]+;
					   ","+LTRIM(STR(LEN(_fheader[_x])))+")"
     	  ENDIF

		ELSEIF __headyn = -1

     	  _offset[_x]  = LEN(_header)+1
     	  _fheader[_x] = UNTRIM(_fields[_x], _temp) 
     	  _header      = _header+_fheader[_x]

	       IF (LEN(_macstring)+LEN(_fields[_x])+8 > 190)
  	       	LOOP
     	  ELSE
        	  _macstring = _macstring+"+UNTRIM("+_fields[_x]+;
									","+LTRIM(STR(_temp))+")"
     	  ENDIF

		ENDIF

  NEXT

  _macstring = SUBSTR(_macstring,2,200)

  * starting left offset to start printing is from the first field
  ****************************************************************
  _fieldnum = 1                   

  * calculate the width of the box
  ********************************
  _width = ((_bcol-_tcol)+1)    

  * calculate the length of the array that will hold the fields  
  * from the file.
  ***************************************************************
  _alen = _brow-_trow +_start

  * declare all the arrays that will hold the lines
  * of text, the record # into the file for each line, as
  * well as the rows and columns of each displayed line of text
  *************************************************************
  PRIVATE linearray[_alen], recnum[_alen], _arow[_alen],;
          _acol[_alen], _acol2[_alen]

  AFILL(_acol,_tcol)
  AFILL(_acol2,_tcol+_width)

  FOR _x = 1 TO _alen
      _arow[_x] = _trow+_x+2
  NEXT

  * use scroll to clear the location of the box since it
  * is faster than letting box() do it. 
  ******************************************************
  SCROLL(_trow, _tcol, _brow, _bcol, 0, IIF(func_colyn,__headcol,__color))

  * display header line
  ********************************* 
	IF __headyn = 0

  	PRINT(_trow,_tcol,_header,__headcol,_width)

	ENDIF

  * if the auto restart flag is set to 1 then move the
  * file pointer to the record # stored in the file position
  * global data area (m_data(31)), and reset the active element
  * to where it was. the file position data contains the
  * file record # of the first displayed line of text
  * the last active element should have the last active element
  * that was highlighted. This has to be set in the calling program
  *****************************************************************
  IF (M_DATA(29) = 1)

     GOTO M_DATA(31)

     _pactive = M_DATA(2)

     * do some bounds checking
     *************************
     IF (_pactive > _alen)

        _pactive = _alen

     ENDIF

     _plast = _pactive

  ENDIF

  * regular cursor off 
  * read in the lines of text into the array used for display
  ******************************************************************** 
	CSROFF()

  DO dbfreadarr

  GOTO recnum[1]

  * use the loop inside a loop trick for programming ease
  *******************************************************

  DO WHILE .T.
        
  	* display the entire array if inside the outer loop
     ***************************************************   
		IF __headyn = 0
	     	PRINT(_trow,_tcol,SUBSTR(_header,_offset[_fieldnum],_width),;
             __headcol,_width)
		ENDIF

     FOR _x = 1 TO _alen 

     	PRINT(_trow+_x+__headyn,_tcol,SUBSTR(linearray[_x], ;
             _offset[_fieldnum],_width),;
				  IIF(func_colyn,colr(recnum[_x]),__color),_width)
     NEXT

		GOTO recnum[1]

     PRINT(_trow+_pactive+__headyn,_tcol,substr(linearray[_pactive], ;
                _offset[_fieldnum],_width),__barcol,_width)

		IF _special != [dummy()]
			_blob  = &_special          
		ENDIF

		_plast = 1

     * check for key activity
     *********************************

     DO WHILE .T.
        
        * if active element has been moved, then 
        * redisplay the highlight
        ****************************************
        IF (_pactive != _plast)

           PRINT(_trow+_pactive+__headyn,_tcol,SUBSTR(linearray[_pactive],;
                    _offset[_fieldnum],_width),__barcol,_width)

		  IF func_colyn .OR. _special != [dummy()]
		  	_blob = recnum[_pactive]
		  ENDIF

           PRINT(_trow+_plast+__headyn,_tcol,SUBSTR(linearray[_plast],;
               _offset[_fieldnum],_width),IIF(func_colyn,;
			 colr(recnum[_plast]),__color),_width)

		  IF func_colyn .OR. _special != [dummy()]
		  	GOTO _blob
		  ENDIF

		  IF _special != [dummy()]
		  	_blob = &_special 
		  ENDIF

        ENDIF        

        * check for a key, and save last active element
        ***********************************************
        _pkey  = WAITKEY()      				 && enables wait state
        _plast = _pactive					 && but works like inkey()

        * check if valid key, or mouse movement
        ***************************************
        DO CASE

           * see if they pressed the up arrow
				**********************************
           CASE _pkey = 5

		  	PUTKEY(5)

              IF _pactive = 1

                IF !dbfreadbac()

*				printmess([Top Of File!])
				M_SQUEAK()
				WAITKEY(1)
*				RESTSCREEN(_top,_left,_bot +1,_right +1,_mess_scrn)

			  ELSE
				blob = recnum[_pactive]

                   ** Un-highlight old record
				**************************
                   PRINT(_trow+_plast+__headyn,_tcol,;
                    	substr(linearray[_plast+1], ;
                    	_offset[_fieldnum],_width),;
					IIF(func_colyn,colr(recnum[_plast+1]),__color),_width)

                   ** Scroll em!
				*************
                   Scroll(_trow+1+__headyn,_tcol,_brow,_bcol,-1)

				GOTO blob

				IF _special != [dummy()]
					_blob = &_special 
				ENDIF

                   ** Highlight new record
				***********************
                   PRINT(_trow+_pactive+__headyn,_tcol,;
                    	substr(linearray[_pactive], ;
                    	_offset[_fieldnum],_width),__barcol,_width)

                   LOOP

			  ENDIF

              ELSE 
              	_pactive = _pactive -1

                 GOTO recnum[_pactive]
                 LOOP
              ENDIF
        
           * see if they pressed the down arrow
		  ************************************
           CASE _pkey = 24

		  	PUTKEY(24)

              IF _pactive = _alen

                IF	!dbfreadfor()
*                  printmess([Bottom Of File!])
                   M_SQUEAK()
                   WAITKEY(1)
*			  	RESTSCREEN(_top,_left,_bot +1,_right +1,_mess_scrn)
                ELSE
					  	
				blob = recnum[_pactive]

                   ** Un-highlight old record
				**************************
                   PRINT(_trow+_plast+__headyn,_tcol,;
                   	substr(linearray[_plast-1], ;
                    	_offset[_fieldnum],_width),;
					IIF(func_colyn,colr(recnum[_plast-1]),__color),_width)

                    ** Scroll em!
				 *************
                    Scroll(_trow+1+__headyn,_tcol,_brow,_bcol,1)

				 GOTO blob

				 IF _special != [dummy()]
				 	_blob = &_special 
				 ENDIF

                    ** Highlight new record
				 ***********************
                    PRINT(_trow+_pactive+__headyn,_tcol,;
                    	substr(linearray[_pactive], ;
                    	_offset[_fieldnum],_width),__barcol,_width)
                    LOOP

                ENDIF

              ELSE 

                 IF !empty(linearray[_pactive+1])  		&& no scrolling into

                    _pactive = _pactive+1					&& a blank element
                    GOTO recnum[_pactive]
                 ELSE
*				 printmess([Bottom Of File!])
                    M_SQUEAK()
                    WAITKEY(1)
*				 RESTSCREEN(_top,_left,_bot +1,_right +1,_mess_scrn)
                 ENDIF

                 LOOP

              ENDIF
      
           * see if they pressed the left arrow
		  ************************************  
           CASE _pkey = 19 .AND. __pan .AND. (__headyn = 0)

		  	PUTKEY(19)

              * check to see if the left offset is at
              * the beginning when moving left
              ***************************************
              IF (_fieldnum <= 1)

                 M_SQUEAK()
                 LOOP
              ELSE 
                 _fieldnum = _fieldnum-1
                 WAITKEY(1)
                 EXIT
              ENDIF
        
           * see if they pressed the right arrow
		  *************************************  
           CASE _pkey = 4	.AND. __pan .AND. (__headyn = 0)

		  	PUTKEY(4)

              IF (_fieldnum < len(_fields))
                 _fieldnum = _fieldnum+1
                 WAITKEY(1)
                 EXIT
              ELSE 
                 M_SQUEAK()
                 LOOP
              ENDIF
        
           * see if the user pressed CTRL/PGUP key, 
		  * goto top of file (or criteria1) if so
           ****************************************
           CASE _pkey = 31

		  	PUTKEY(29)

		  	IF UPPER(_criteria1) = [.T.]

              	GO top
						
		  	ELSE

		  		SEEK seekvar
		  	ENDIF

              DO dbfreadarr

              GOTO recnum[1]

              _pactive = 1

		  	EXIT
        
           * see if the user pressed the HOME key
           **************************************
           CASE _pkey = 1

              PUTKEY(1)

              GOTO recnum[1]

              _pactive = 1

              LOOP
        
           * see if the user pressed the END key
           *************************************
           CASE _pkey = 6

           	PUTKEY(6)

			_x = _alen

              GOTO recnum[_alen]

			DO WHILE EMPTY(linearray[_x])
						
				_x = _x -1
				GOTO recnum[_x]

			ENDDO

              _pactive = _x

              LOOP
        
           * see if the user pressed CTRL/PGDWN key
				* goto bottom of file (or criteria1) if so
           ******************************************
           CASE _pkey = 30
           
			PUTKEY(23)

			allforwd()

              _pactive = 1

              DO dbfreadarr

              GOTO recnum[_pactive]

			EXIT

           * see if the user pressed the PG UP key.
		  * Advance a page of text if they did
           ****************************************
           CASE _pkey = 18 

			PUTKEY(18)

              IF !EXECUTE(_alen,[dbfreadbac()])
				M_SQUEAK()
			ENDIF

			_pactive = 1

              EXIT
        
           * see if the user pressed the PG DWN key.
				* Rewind a page of text if they did
           *****************************************
           CASE _pkey = 3

			PUTKEY(3)

              IF !EXECUTE(_alen,[dbfreadfor()])
				M_SQUEAK()
				DO dbfreadarr
				_pactive = 1
				EXIT
			ENDIF
					
			DO dbfreadarr

              _pactive = _alen

              DO WHILE EMPTY(linearray[_pactive])

				_pactive = _pactive -1

			ENDDO

              GOTO recnum[_pactive]

			EXIT

           * if an ALT/R is pressed, refresh the display
           * so that a set key to can reposition the record pointer
           ********************************************************
           CASE _pkey = 275               

			GOTO recnum[1]

              DO dbfreadarr 

              GOTO recnum[_pactive]

              EXIT

           * if the user presses a letter, then hunt it down
           * within the file only if an index is active
           *************************************************
           CASE (_pkey > 31) .AND. (_pkey < 127)

              IF ISINDEX()

				IF TYPE([INDEXKEY()]) = [D]

					IF !STATUS(17)
						SET SOFTSEEK ON
						sflag = .T.
					ENDIF

					findstr = CTOD(CHR(LASTKEY()) +[ /  /  ])

				ELSE

					findstr = CHR(LASTKEY()) +SPACE(_width -7)	

				ENDIF

				seekscrn = SAVESCREEN(_brow -3,_tcol +1,_brow,_bcol -2)

				BOX(_brow -3,_tcol +1,_brow -1,_bcol -2,[],;
					IIF(func_colyn,colr(recnum[_plast]),__color),3,8) 

				KEYBOARD CHR(4)

                 	CSRON()

                 	@ _brow -2,_tcol +3 GET findstr 

				READ

                	CSROFF()

                	IF LASTKEY() = 27 	  	&& if they ESCAPE, just return

					RESTSCREEN(_brow -3,_tcol +1,_brow,_bcol -2,seekscrn)

                   	LOOP

                	ENDIF

                	SEEK TRIM(findstr)

				IF sflag
					SET SOFTSEEK OFF
					sflag = .F.
				ENDIF

                	IF FOUND() .AND. &_criteria1 .AND. &_criteria2

                	 	DO dbfreadarr

                  		GOTO recnum[1]

                  		_pactive = 1

                	ELSE

                    	M_SQUEAK()

                    	GOTO recnum[_pactive]

                	ENDIF

				EXIT

              ENDIF

		  * returning anything other that '0' or '2' leaves box the 
		  * the way it was
		  **********************************************************
		  CASE _pkey != 0

		  	CSRON()

		  	GOTO (recnum[_pactive])

		  	_keyretrn = &_keyfunc

		  	IF _keyretrn = 0							&& quit

				IF LASTKEY() != 27

           	   		M_DATA(30,-1)	 
              		RETURN(recnum[_pactive])

				ELSE

					M_DATA(30,0)
					GOTO (_temprec)
					RETURN(0)

				ENDIF

			ELSEIF _keyretrn = 2                     && redraw box

              	_pactive = 1
				_plast   = 1

				IF UPPER(_criteria1) != [.T.] .AND. !&_criteria1 

					SEEK seekvar
						
				ELSEIF UPPER(_criteria1) = [.T.] .AND. !&_criteria2

					GO TOP

				ENDIF

	               DO dbfreadarr

  	          	goto recnum[1]

				CSROFF()

				EXIT

			ELSEIF _keyretrn = 1                   && return to scroll box

				CSROFF()

			ENDIF

        ENDCASE
        
     ENDDO

  ENDDO
***************************************************************************************************

FUNCTION _defky

	IF _pkey = 13
		RETURN(0)
	ELSEIF _pkey = 27
		RETURN(0)
	ENDIF

RETURN(1)
*****************************************************************************

FUNCTION dbfreadbac                   && reads back one record until it meets
			      								 && the criterias
	PRIVATE ret_val

  ret_val = .T.

  DO WHILE .T.

  	SKIP -1

     IF BOF() .OR. !&_criteria1  
        GOTO recnum[1]
	    ret_val = .F.
        EXIT
     ENDIF

	 IF DELETED() .OR. !&_criteria2
	 	LOOP
	 ENDIF

     AINS(linearray,1)
     AINS(recnum,1)

     recnum[1]    = RECNO()
  	 linearray[1] = &_macstring

		EXIT

   ENDDO

RETURN(ret_val)
*************************************************************************

FUNCTION dbfreadfor

	***************************************************
  *** this routine reads forward one record       ***               
  *** and inserts it into the last element        ***
  *** of the array                                ***
  ***************************************************
	PRIVATE ret_val

	ret_val = .T.

  DO WHILE .T.

  	 SKIP 1

     IF EOF() .OR. !&_criteria1  
        GOTO recnum[_alen]
			ret_val = .F.
        EXIT
     ENDIF

	 IF DELETED() .OR. !&_criteria2
	 	LOOP
	 ENDIF

     ADEL(linearray,1)
     ADEL(recnum,1)

     recnum[_alen]    = RECNO()
  	 linearray[_alen] = &_macstring

	 EXIT

   ENDDO

RETURN(ret_val)
*********************************************************************************************

PROCEDURE dbfreadarr

	***************************************************
  *** this routine reads forward the number       ***               
  *** of records needed to fill the entire array  ***
  ***************************************************

  _x = 1

  DO WHILE &_criteria1 .AND. _x <= _alen .AND. !EOF() 

  	IF &_criteria2. .AND. !DELETED() 			&& we have a winner
               
     	linearray[_x] = &_macstring
     	recnum[_x]    = RECNO()
     	_x            = _x+1

    ENDIF

    SKIP 1

  ENDDO

  IF _x <= _alen

     _z = _x

     SKIP -1

     FOR _z = _x TO _alen

         linearray[_z] = SPACE(_width)
         recnum[_z]    = RECNO()

     NEXT

  ENDIF

RETURN
************************************************************************

FUNCTION dummy

RETURN(1)
************************************************************************

FUNCTION allforwd

	PRIVATE mseekvar,_ikey,sflag

	IF (UPPER(_criteria1) != [.T.]) 

		_ikey    = INDEXKEY(0) 
		mseekvar = seekvar

		IF TYPE(_ikey) = [C]

			mseekvar = SUBSTR(mseekvar,1,LEN(mseekvar) -1) +;
					    	CHR(ASC(SUBSTR(mseekvar,LEN(mseekvar),1)) +1)

		ELSEIF TYPE(_ikey) = [N]

			_ikey = STR(&_ikey)

			IF [.] $ _ikey

				mseekvar = seekvar + VAL([.] +REPLICATE([0],;
							 	LEN(_ikey) -AT([.],_ikey)-1) +[1])

			ELSE

				mseekvar = seekvar +1

			ENDIF

		ELSEIF TYPE(_ikey) = [D]

		   	mseekvar = DTOC(mseekvar)
		  	mseekvar = CTOD(SUBSTR(mseekvar,1,3) +;
						LTRIM(STR(VAL(SUBSTR(DTOC(seekvar),4,2)) +1)) +;
								SUBSTR(mseekvar,6,3))

		ENDIF

		IF !STATUS(17)
			SET SOFTSEEK ON
			sflag = .T.
		ENDIF

		SEEK mseekvar

		IF sflag
			SET SOFTSEEK OFF
			sflag = .F.
		ENDIF

		DO WHILE &_criteria1 .AND. !EOF() 	&& if we're not at the end of 
			SKIP						&& criteria1 yet - we will be 
		ENDDO						&& soon enough!

		SKIP -1				   && now we're at the end of the criteria1 stuff

		DO WHILE &_criteria1 .AND. !BOF()

			IF &_criteria2
				EXIT
			ENDIF
		
			SKIP -1

		ENDDO

		IF BOF()	.OR. !&_criteria1
			RETURN(.F.)
		ENDIF

	ELSE

		GO BOTTOM

		IF !&_criteria2

			DO WHILE &_criteria1 .AND. !BOF()

				IF &_criteria2
					EXIT
				ENDIF
		
				SKIP -1

			ENDDO

			IF BOF()	.OR. !&_criteria1
				RETURN(.F.)
			ENDIF

		ENDIF

	ENDIF

RETURN(.T.)
************************************************************************

FUNCTION colr

	PARAMETERS num

	PRIVATE retcolor

	GOTO num

	retcolor = &__color

RETURN(retcolor)
**************************************************************************

FUNCTION printmess

	PARAMETERS mess_str

	_top       = INT((_trow +_alen) /2) -1
	_bot       = _top +2
	_left	     = INT((_width -LEN(mess_str)) /2) -1
	_right     = _left +LEN(mess_str) +2
	_mess_scrn = SAVESCREEN(_top,_left,_bot+1,_right+1)

	BOX(_top,_left,_bot,_right,[],__headcol,3,8)

	PRINT(_top +1,_left +1,mess_str,__headcol)

RETURN([])
*************************************************************************

FUNCTION da_chng  			&& change any user-defined data records

PRIVATE screen,num,fields[1],temprec

screen    = SAVESCREEN(03, 00, 23, 79)
fields[1] = [client]

SELECT client

GO TOP

DO WHILE !EOF()

        IF !DELETED()
            EXIT
        ENDIF

        SKIP    
END DO

IF EOF()

	error([CLIENT file is empty - enter clients first])
	RESTSCREEN(03,00,23,79,screen)
	RETURN([])

ENDIF

DO WHILE .T.

	BOX(05,10,20,52,M_FRAME(),23,3,8)

	PRINT(05,11,[CLIENT LIST])

	GO TOP

	val = boxdbf(06,11,19,51,fields,[],[],30,23,112)

	IF val < 1
		EXIT
	ENDIF

	DO WHILE .T.
	
		SELECT matter

		SEEK STR(client->clientcode)

		temprec = RECNO()

		num = 0

		DO WHILE clientcode = client->clientcode .AND. !EOF()

			num = num +1

			SKIP

			IF num > 1
				EXIT
			ENDIF

		ENDDO

		DO CASE

		CASE num = 0
			 error([No Matters Found For Selected Client])
			 SELECT client
			 EXIT
	
		CASE num = 1
			
			GO (temprec)
	
		CASE num > 1

			SET ORDER TO 4

			GO TOP
	
			PRIVATE field_list[3], field_desc[3]
	
			field_list[1] = "matterdesc"
			field_list[2] = "STR(mattercode)"
			field_list[3] = "STR(clientcode)"
	
			field_desc[1] = "MATTER DESCRIPTION"
			field_desc[2] = "MATTER CODE"
			field_desc[3] = "CLIENT CODE"
	
        BOX(05,06,20,73,m_frame(),7,m_data(16),m_data(17))

			PRINT(05,07,"MATTER SELECTION FOR " + TRIM(client->client),30)

			recnum = boxdbf(6,7,19,72,field_list,field_desc,[],;
					  30,23,112,".t.","clientcode = client->clientcode")

			CSRON()

			SET ORDER TO 1

			GOTO (recnum)

			IF LASTKEY() = 27
				SELECT client
				EXIT
			ENDIF

		ENDCASE

		SET KEY -6 TO

		code = STR(clientcode) + STR(mattercode)
		desc = SUBSTR(TRIM(matterdesc),1,40)

		SELE client

		SET ORDER TO 2

		SEEK matter->clientcode

		SET ORDER TO 1

		SELE matter

		mmat_type = ALLTRIM(mat_type)
		endstr    = "_udb"
		endstr1   = ".dbf"
		ustr      = mmat_type +endstr +endstr1
		sstr      = mmat_type +endstr
		start_fld = 3
		numb      = 1
		exit_key  = "first"

		IF FILE(ustr)

			SELECT 0

			IF !NET_USE(sstr,.F.,20)
				error([UDB File Not Available - Please Try Later])
				RESTSCREEN(03, 00, 23, 79, screen)
				SET KEY -6 TO cw_save()
				RETURN([])
			ENDIF

			SET INDEX TO (sstr)

 			SEEK code   && go to that matter's record

			IF !FOUND()
			   error([Can't Find Selected Matter in UDB])
			   USE
			   SELECT client
			   SET ORDER TO 1
			   GO TOP
			   RESTSCREEN(03, 00, 23, 79, screen)
			   SET KEY -6 TO cw_save()
			   RETURN([])
			ENDIF

			IF !REC_LOCK(20)
			   error([Selected Record is Not Available - Please Try Later])
			   USE
			   SELECT client
			   GO TOP
			   RESTSCREEN(03, 00, 23, 79, screen)
			   SET KEY -6 TO cw_save()
			   RETURN([])
			ENDIF
	
			BOX(04,00,20,79)
	
			PRINT(5,28,"Client: " + TRIM(client->client))
			PRINT(6,28,"Matter: " + desc)
	
			how_many_flds = FCOUNT() 
			scr           = how_many_flds /12
			scr1          = how_many_flds % 12
	
			IF scr1 > 0
				screens = INT(scr) + 1
			ELSE
				screens = scr
			ENDIF
	
			DO WHILE .T.
				DO CASE
	
				  CASE exit_key = "first"
		      	  	exit_key = READ_SCREEN((start_fld),how_many_flds)
					LOOP
	
				  CASE (exit_key = "down" .AND. numb = screens) .OR.;
				  					exit_key = "out"
					EXIT
	
				  CASE exit_key = "up" .AND. numb = 1
					EXIT
	
				  CASE exit_key = "down"
	
					numb      = numb + 1
					start_fld = start_fld + 12
	
					IF !EMPTY(FIELD(start_fld))
	
						exit_key  = READ_SCREEN((start_fld),;
									how_many_flds)
	
						LOOP
	
					ELSE
						
						EXIT
	
					ENDIF
	
				  CASE exit_key = "up"
	
					numb      = numb - 1
					start_fld = start_fld - 12
					exit_key  = READ_SCREEN((start_fld),how_many_flds)
	
					LOOP
				ENDCASE
			ENDDO
	
			UNLOCK
	
			USE
	
		ELSE
	
	 		error("No User-Defined Database Found For This Matter Type")
			SELECT client
			EXIT
	
		ENDIF
	
		RESTSCREEN(03,00,23,79,screen)
	
		IF num = 1
			SELECT client
			EXIT
		ENDIF

	ENDDO

ENDDO

SELECT client

GO TOP

RESTSCREEN(03, 00, 23, 79, screen)

SET KEY -6 TO cw_save()

RETURN([])
************************************************************************

FUNCTION read_screen  	    			&& multi-page gets using READS()

PARAMETERS start,end

PRIVATE trow,esc,level,c_rev,c_norm,screen

SCREEN = savescreen(8,3,20,77)

trow   = 8
esc    = 0
level  = 1
c_rev  = 112
c_norm = 7
level  = 1

exitkeys(13,5,24,-6)

FOR X = start TO start + 11
	
	IF X <= end
		
		PRINT(trow,3,FIELD(X),c_norm)
		
		temp = FIELD(X)
		tempfld = (temp)
		
		IF TYPE(tempfld) = "M"
			PRINT(trow,15,"  -- MEMO --  ",c_norm)
			trow = trow + 1
		ELSE
			PRINT(trow,15,&tempfld,c_norm)
			trow = trow + 1
		ENDIF
		
	ENDIF
NEXT

DO WHILE .T.
		
		fld2 = FIELD(start)

		IF EMPTY(fld2)
			EXIT
		ENDIF

		fld1 = &fld2
		
		IF TYPE(fld2) = "M"

			CSRPUT(level +7,15)
			gokey = waitkey(0)	
			
			DO CASE
				
			CASE gokey = 13 .OR. gokey = -6

				s1 = SAVESCREEN(level +2,15,level +9,77)

				BOX(level +2,15,level +9,77)

				var = MEMOEDIT(fld1,level +3,16,level +7,76,.T.)

				REPLACE &fld2 WITH var

				RESTSCREEN(level +2,15,level +9,77,s1)

				level = level +1
				start = start + 1

				IF level > 12
					EXIT
				ENDIF

				LOOP
				
			CASE gokey = 24
				level = level +1
				start = start + 1

				IF level > 12
					EXIT
				ENDIF

				LOOP
				
			CASE gokey = 5

				level = level -1

				IF level < 1
					EXIT
				ENDIF

				start = start -1

				LOOP
				
			CASE gokey = 27

				EXIT

			OTHERWISE
				LOOP
			ENDCASE
		ELSE

			esc = READS(level +7,15,fld1,c_rev)

			REPLACE &fld2 WITH fld1
			PRINT(level +7,15,fld1,c_norm)
			
			IF esc = 27
				EXIT
			ENDIF
			
			IF esc = 13 .OR. esc = 24 .OR. esc = -6
				level = level +1
				start = start + 1

				IF level > 12
					EXIT
				ENDIF

				LOOP
			ENDIF
			
			IF esc = 5

				level = level -1

				IF level < 1
					EXIT
				ENDIF

				start = start -1
				LOOP

			ENDIF

		ENDIF
ENDDO

DO CASE
	
CASE LASTKEY() = 13 .OR. LASTKEY() = 24
	ret_str = "down"
	
CASE LASTKEY() = 5
	ret_str = "up"
	
CASE LASTKEY() = 27
	ret_str = "out"
	
OTHERWISE 
	ret_str = "out"
	
ENDCASE

restscreen(08, 03, 20, 77, SCREEN)

RETURN(ret_str)
****************************************************************************
