*Function....:CLR()
*Syntax......:CLR(expN,expN)
*Parameters..:row,col
*Returns.....:null
*Notes.......:@ row, col CLEAR does not perform as documented.
* It should clear a corner described by the row and column
* coordinates.  Clipper, however starts at the described row and
* column and clears everything to the end of screen.  This
* function will simulate the CLEAR command as documented.
* Since the purpose of a function is to return a value and what we
* really want here is to DO something, this should more properly
* be written as a procedure.  This is provided purely as an
* example of the enormous versatility of user defined functions.
* Since a function MUST return a value, CLR() returns null string.
* Call the function by with a question mark.
*   ? CLR(row,col)
* If used as a procedure, you don't have to worry about any
* of that (but then we wouldn't have a function example).
* Following are the two ways.  Take your pick.

*    FUNCTION EXAMPLE
FUNCTION clr
PARAM row,col
*
FOR f_row = row to 23
    @ f_row, col
NEXT
* Clear line 24 without scrolling...
@ 24, col SAY SPACE(79 - col)
RETURN ("")
*
*
*    PROCEDURE EXAMPLE
*    Syntax:  DO clr WITH row,col
PROCEDURE clr
PARAM row,col
*
FOR f_row = row to 23
    @ f_row, col
NEXT
@ 24, col SAY SPACE(79 - col)

RETURN
