/*
ClipStrt.PRG
(c) 1993, Paul G. Kurr All Rights Reserved. CIS-70511,3626

Use and modification of this program is permitted by any person or
organization provided that the credit for the original work is
maintained (keep my name in it).

This program is provided as is without any warranty what-so-ever.

The author assumes no responsibility for the use of this program.
Use at your own risk.

*** Allow for rest OS2Start function for those doubters on C$ ***

*/
Function Main(cCommand, cParms, cType)

Local nType, nReturn

if cCommand == NIL
   cCommand := ""
Endif

cCommand := Alltrim(cCommand)

if cCommand == "/?" 

   ? "ClipStrt cProgram [['xParameters'] [cType]]"
   ? "Test for the OS/2 VDM DOSStartSession Interface Program."
   ? "(c) 1993, Paul Kurr, Roswell, GA, CIS-70511,3626"
   ? ""
   ? "   cProgram    - Program or path/program to execute (C:\OS2\XCOPY.EXE)"
   ? "   xParameters - Parameters to be passed to program"
   ? "                  if more than one parameter is being passed, enclose all"
   ? "                  parameters in quotes. ('C:\temp1\*.* Y:\Temp /s /e')"
   ? "   cType       - Session type code (OF - OS/2 FullScreen, OW - OS/2 Window, "
   ? "                  PM - Presentation Mgr, DF - DOS FullScreen, DW - DOS Window,"
   ? "                  ?? or blank Let OS/2 figure it out)"
   ? ""
   ? 'Examples:   ClipStrt Dir /w DW '
   ? '               Starts a DOS window and executes a "dir /w"'
   ? '               note:  (dir is command, /w is parm)'
   ? '            ClipStrt c:\os2\xCopy.exe "C:\Temp Y:\BU /s /e" OF'
   ? '               Starts an OS/2 full screen session, executing XCOPY'
   ? '               note:  the exe path was specified.'
   ? '            ClipStrt cmd.exe "/c xcopy C:\temp Y;\BU /s /e" Ow'
   ? '               Starts an OS/2 window, lets CMD.EXE execute XCOPY.'
   ? '               note:  the path for xcopy was not required.'

   Return NIL

Endif

if cParms == NIL
   cParms := ""
endif

cParms := Alltrim(cParms)

if cType == NIL
   cType := ""
endif

cType := Alltrim(upper(cType))

do case

case cType == "OF"                              // OS/2 Fullscreen
   nType := 1
   
case cType == "OW"                              // OS/2 Window
   nType := 2

case cType == "PM"                              // Presentation Manager Pgm
   nType := 3

case cType == "DF"                              // DOS FullScreen
   nType := 4

case cType == "DW"                              // DOS Window
   nType := 7

Otherwise
   nType := 0                                   // Haven't got a clue

endcase

*  Execute function OS2Start

if nReturn := OS2Start(cCommand, cParms, nType) == 0
   ? "Flip to the desktop and see if you program is running."
   ? "Although it may be finished by now."
Else
   ? "An error occured issuing OS2Start()"
   ? "The return code was: " + Alltrim(Str(nReturn)) + " decimal."
Endif

Return NIL
