; CLIPINT.ASM
;
; by Michael Brill
; updated 10-6-89 by G. Melton for clipper s'87 functionality
;         must be linked with extend.lib
;
   PAGE  60,132
   PUBLIC   INTERRUPT
   EXTRN    __parinfo:far
   EXTRN    __parni:far
   EXTRN    __retni:far

   dgroup   group   datasg

   datasg     segment   'data'
   save_int   dw 0h
   save_areg  dw 0h
   save_breg  dw 0h
   save_creg  dw 0h
   save_dreg  dw 0h
   datasg  ends

;***************************************************
_code segment byte public

assume   cs:_code,ds:dgroup,es:nothing
;---------------------------------------------------
;
;     Syntax: interrupt(interrupt number,AX,BX,CX,DX)
;
;     Return: value in AX, after the interrupt has occurred
;
;     Params: interrupt number - the interrupt (0-255) to execute
;             AX,BX,CX,DX      - values to be put into the ax-dx
;                                registers before interrupt
;
;-----------------
INTERRUPT   PROC  FAR
   push     bp       ;Save Clipper's registers
   mov      bp,sp
   push     ds
   push     es
   push     si
   push     di
   mov      ax,0     ;insure five parameters were passed
   push     ax
   call     __parinfo
   add      sp,2
   cmp      ax,5
   jne      _exit
   mov      ax,1     ;Get the values for registers
   push     ax
   call     __parni
   add      sp,2
   mov      save_int,ax     ;;save int no.
   mov      ax,2
   push     ax
   call     __parni
   add      sp,2
   mov      save_areg,ax
   mov      ax,3
   push     ax
   call     __parni
   add      sp,2
   mov      save_breg,ax
   mov      ax,4
   push     ax
   call     __parni
   add      sp,2
   mov      save_creg,ax
   mov      ax,5
   push     ax
   call     __parni
   add      sp,2
   mov      save_dreg,ax
   mov      ax,save_int                  ;Get the interrupt number
   mov      byte ptr CS:_intplace+1,al   ;where the int # goes to form the
                                       ;INT x instruction
   mov      dx,save_dreg                 ;Grab the rest of the registers
   mov      cx,save_creg
   mov      bx,save_breg
   mov      ax,save_areg
_intplace   dw 00cdH                   ;Execute the interrupt
_exit:
   pop      di
   pop      si
   pop      es                           ;
   pop      ds                           ;Restore Clipper's registers
   pop      bp                           ;
   push     ax
   call     __retni                       ;Return the value in AX
   add      sp,2
   ret                                   ;Go on back to Clipper

INTERRUPT  ENDP
;-----------------------------------------------------------
_code ends
;***********************************************************
        END
