COMMENT 
************************************************************************ 
*                         TITEL: CLIPFOR.ASM                           *
*                           Public - Domain                            *
*                           royalty - free                             *
*         INTERFACE CLIPPER S'87 // MS Fortran 4.0 + - 5.0             * 
*      02-FEB-90, Germany (West) It explains my orthography!           *  
*                                                                      *
* Create one exe-file of Clipper- & MS-Fortran obj-files. This inter-  *
* face bridges both languages. No fancy switches and adjustments!      * 
*                                                                      *
* History:                                                             *
*  Version 1 went the way through the interface statements in C.       *
*  It worked, but not without some fancy switches. The exe - files     *
*  where larger as well. To understand what was going on, it was also  *
*  helpful to have some idea of C.                                     *                            
*                                                                      *  
* This Version is entirely written in assembler. It uses the functions *
*  of Clipper's extend-system and McConnell's extor.obj directly.      *
*  --> Small code, no switches and blazingly fast.                     *
*  If you know, how your language hands its data down to assembler,    *
*  then it is no big deal to pass it up to Clipper, as long as it      *
*  shares the Microsoft Runtime Library(tm).                           *       
*                                                                      *
*  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*
*  If you are also interested in accessing DBF-Files out of Fortran,   *
*  let my know. For $20 I'll send you the source.                      *
*                                                                      *
*  EXTERNAL EVENTS may now INTERRUPT YOUR CLIPPER PROGRAM while you are*
*  on a wait state (read, inkey(), wait, etc.). You are able to CONTROL*
*  your CLIPPER application THROUGH THE PARALLEL PORT (lptx:).It works *
*  just like pressing a "SET KEY TO xyz" -key. I built a high          *
*  precission timer with it; & only very little hardware had been in-  *
*  volved. (1 x mono-, 1 x flip-flop, \/\/\-R's & C's-  --||--)        *
*  There is also a demo available for 5$.You need a printer to run it. *
*  If you are interested in the commented assembly source and the      *
*  involved hardware, 50$ will be fine.                                *                                
*                                           Sorry, green stamps only!  *
*  *
*  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*
*                                                                      *
*  Attn.: Dirk Lesko, remember London, December 1989 at the Nantucket  *
*         European Developers Conference, I told you I was going to do *                
*         it! - It's my pleasure to give you the demo without charge! -*
*         (May be you remember me, you gave me the price of the 2nd    *
*         day's contest. Remember the party ?)                         *
*                                                                      *
*  *
*                                                                      *
* General;                                                             *
*  Fortran gives you FAR pointers to its data. You pick the data there *
*   and hand it over to Clipper.                                       *
*                                                                      *
*  Compiler-switches for Fortran:  (MS-Fortran 4.x & 5.0)              *                              
*   SET FL=/c /AL /Zl /Olt /FPa /Gs /W2                                *
*                                                                      *
*  Microsoft Macro Assembler >= Version 5.1                            *
*   SET MASM=/Mx /W2                                                   *
*                                                                      * 
*  How to link:                                                        *
*    LINK /NOE myprog + CLIPFOR.OBJ+EXTOR.OBJ,,NUL, \                  *
*                                       clipper.lib+llibfora;          *
*                                                                      *
* Extor.obj was released by Rich McConnell & donated to public domain. *
*  --> look for CGOODS2.ARC in NANFORUM    !!! Don't be without it !!! *
*                                                                      *
* Author:Jobst Hensiek, Claustorwall 23, D-3380 Goslar 1, Germany(West)*
* call: 011 (495) 321-4457, CIS: [76656, 1606]                         * 
* I ask for complains and compliments. By the way, do you have a job   *
* for me ? I'am very close to my masters degree (engineer of material  *
* sience. I do speak german, C', assembler, english, fortran, Clipper  *
* and a mix of the above.)                                             *
*                                                                      *
* ------------------ I was told to implement this . ------------------* 
*                Clipper is a trademark of Nantucket Corp.             *               
*               Extor.obj is copyrigthed by Nantucket Corp.            *        
*         Nantucket is a registered trademark of Nantucket Corp.       *        
*         Microsoft is a registered trademark of Microsoft Corp.       *        
*       MASM & MS-C & MS-FORTRAN are trademarks of Microsoft Corp.     *    
************************************************************************ 
                                                                       
IFNDEF @VERSION
 IF2
    .ERR2
    %out Microsoft Macro Assembler 5.1 required!
  ENDIF
ELSE
                  .XALL
;--------------------- A few macros to make life easier --------------*
          TRUE    =       1
          FALSE   =       0

@FGET_I2          MACRO   REG,ARG              ; INTEGER*2
          LES     BX,DWORD PTR ARG                 
          MOV     REG,ES:[BX]                      
          PUSH    REG
ENDM

@FGET_I4          MACRO   ARG                  ; INTEGER*4
          LES     BX,DWORD PTR ARG
          MOV     AX,ES:[BX]                   ; LOW
          MOV     DX,WORD PTR ES:[BX+2]        ; HIGH
          PUSH    DX
          PUSH    AX
ENDM

@FGET_R8         MACRO   ARG                  ; don't blame me for it!
         PUSH    BP
         LES     BP,DWORD PTR ARG
         MOV     AX,ES:[BP]                   ; HMSW
         MOV     BX,ES:[BP+2]                 ; LMSW     ?
         MOV     CX,ES:[BP+4]                 ; HLSW     ?
         MOV     DX,ES:[BP+6]                 ; LLSW
         POP     BP
         PUSH    DX
         PUSH    CX
         PUSH    BX
         PUSH    AX
ENDM

@FGET_PTR        MACRO STRING                 ; this is a lot nicer!   
         PUSH    ES                           ; great Nantucket, great!
         LES     AX,DWORD PTR STRING
         MOV     DX,ES
         POP     ES
         PUSH    DX
         PUSH    AX
ENDM        

@STACK_POP      MACRO  WERT                   ; please don't ask
        ADD     STP,WERT
        ADD     SP,STP
ENDM

@FPINFA         MACRO   PLATZ                 ; ?-> german! 
        EXTRN   __parinfa:FAR
        MOV     AX,PLATZ
        PUSH    AX
        CALL    FAR PTR __parinfa
        ADD     SP,002H
ENDM
        
@FPINFO         MACRO PLATZ,TEST
        EXTRN   __parinfo:FAR
        MOV     AX,PLATZ
        PUSH    AX
        CALL    FAR PTR __parinfo
        ADD     SP,002H
        AND     AX,TEST
ENDM

@FCHECK         MACRO   PLATZ,INDEX             ; This one does it!
        MOV     STP,002H
        LES     BX,DWORD PTR PLATZ              ;
        MOV     AX,ES:[BX]                      ;
        LES     BX,DWORD PTR INDEX              ;
        MOV     DX,ES:[BX]                      ;
        CMP     DX,000H
        JZ      WEG
         PUSH   DX
         MOV     STP,004H
WEG:    PUSH    AX
ENDM

@FI2RET         MACRO   STAPEL
                ADD     SP,STAPEL
                LES     BX,DWORD PTR WERT
                MOV     WORD PTR ES:[BX],AX
ENDM 

@FRET_I2        MACRO   WERT,REG
                LES     BX,DWORD PTR WERT
                MOV     WORD PTR ES:[BX],AX
ENDM

@FISARR         MACRO
                CMP            DX,000H
                JZ             GO_OK               
                ADD             SP,002H
                MOV             AX,FALSE
                JMP             SHORT BYE 
GO_OK:
ENDM

@CALL           MACRO           WAS, ST_POP
                EXTRN           WAS&:FAR
                CALL            FAR PTR WAS&
                IFNB            <ST_POP>
                 ADD            SP,ST_POP
                ENDIF
ENDM
;------------------------< EOM = end of macros ------------------------------*


;------------------------< code starts here >--------------------------------*
.MODEL LARGE, FORTRAN                        


; Some of you might know, why this has to be in place.
; I take your guesses ...
IFDEF DEMO                   ; In case you don't have MS Fortran 4.x handy
 public Oktoberfest          ; this will help a LITTLE! At least you get this
 .DATA                       ; demo running. If you recomplie fordemo.for
 Oktoberfest DD	0h           ; reassemble clipfor.asm also WITHOUT the 
ENDIF                        ; demo-switch.                         10-4 ?

.CODE
COMMENT 
***
*	Return INTEGER*2 to Clipper; passing by [VALUE]
*
*	example:
*        INTEGER*2 NUMBER
*
*        CALL FRETNI(NUMBER)
*	        
***
FRETNI  PROC  FAR      USES ES DS DI SI, WERT:DWORD 
        @FGET_I2       AX,WERT
        @CALL          __retni,002h
        RET			
FRETNI  ENDP



COMMENT 
***
*	Return LOGICAL*1 to Clipper; passing by [VALUE]
*
*	example:
*        LOGICAL*1 WAHR
*
*        CALL FRETL(WAHR)
*	        
***
FRETL   PROC FAR       USES ES DS DI SI, WERT:DWORD 
        @FGET_I2       AX,WERT
        @CALL          __retl,002h
	RET			
FRETL   ENDP



COMMENT 
***
*
*	example:
*        INTEGER*4 NUMBER
*
*        CALL FRETNL(NUMBER)
*	        
***
FRETNL  PROC FAR       USES ES DS DI SI, WERT:DWORD 
        @FGET_I4       WERT
        @CALL          __retnl,004h
	RET			
FRETNL  ENDP


	
COMMENT 
***
*	Return REAL*8 to Clipper; passing by [VALUE]
*
*	example:
*        REAL*8 NUMBER
*
*        CALL FRETND(NUMBER)
*	        
***
FRETND  PROC FAR       USES ES DS DI SI, WERT:DWORD 
        @FGET_R8       WERT
        @CALL          __retnd,008H
        RET			
FRETND  ENDP



COMMENT 
***
*	Return to Clipper
*
*	example:      
*        
*        CALL FRET()
*	        
***
FRET    PROC FAR
        @CALL           __ret
        RET
FRET    ENDP



COMMENT 
***
*	Return STRING to Clipper 
*
*	example:
*        CHARACTER*20 ALPHA
*
*        CALL FRETC(ALPHA//CHAR(0))
*	        
***
FRETC   PROC FAR        USES ES DS DI SI, STRING:DWORD
        @FGET_PTR       STRING
        MOV             BX,AX
        MOV             DS,DX
        @CALL           _strlen,004h
        DEC             AX
        MOV             DI,AX
        MOV             WORD PTR DS:[BX+DI],000H
        PUSH            DX
        PUSH            BX
        @CALL           __retc,004H
        RET
FRETC   ENDP



COMMENT 
***
*	Return STRING with specified length to Clipper
*
*	example:
*        CHARACTER*20 STRING
*        INTEGER*2 LENGTH 
*
*        CALL FRECLN(STRING//CHAR(0),LENGTH)
*	        
***
FRTCLN  PROC FAR        USES ES DS DI SI, STRING:DWORD, LAENGE:DWORD
        @FGET_I2        CX,LAENGE
        @FGET_PTR       STRING
        @CALL           __retclen,004H
        RET
FRTCLN  ENDP



COMMENT 
***
*	Return DATE-STRING to Clipper
*
*	example:
*        CHARACTER*9 DATE
*        DATE='19900101'
*
*        CALL FRETDS(DATE//CHAR(0))
*	        
***
FRETDS  PROC FAR USES ES DS DI SI, STRING:DWORD
        @FGET_PTR       STRING
        @CALL           __retds,004H
        RET
FRETDS  ENDP



COMMENT 
***
*	get STRING from Clipper 
*
*	example:
*        CHARACTER*20 STRING
*        INTEGER*2 ORDER,INDEX            ; don't skip the INDEX!
*
*        CALL FPARC(STRING,ORDER,INDEX)   
*	        
***
FPARC   PROC FAR        USES ES DS DI SI, STRING:DWORD, PLATZ:DWORD, \
                                          INDEX:DWORD 
        LOCAL   STP:WORD 
        @FCHECK         PLATZ,INDEX
        @CALL           __parc,STP
        MOV             DS,DX
        MOV             SI,AX
        PUSH            DX
        PUSH            AX
        @CALL           _strlen,004h
        MOV             CX,AX
        SHR             CX,1                    ; for moving words
 
        ; QUELLE DS:SI
        ; ZIEL   ES:SI
        LES             DI,DWORD PTR STRING
        
        ; FR DEN RCHTRANSPORT
        MOV             DX,ES
        MOV             AX,DI
     
        ; KOPIERE..
        REP             MOVSW 
        RCL             CX,001H
        REP             MOVSB

        ; FORTRAN - FANCY ???
        MOV             WORD PTR ES:[DI],27H
        INC             DI
        MOV             WORD PTR ES:[DI],000H

        RET
FPARC   ENDP



COMMENT 
***
*	get INTEGER*2 from CLipper 
*
*	example:
*        INTEGER*2 NUMBER
*        INTEGER*2 ORDER,INDEX             ; don't skip the INDEX!
*
*        CALL FPARNI(NUMBER,ORDER,INDEX)
*	        
***
FPARNI  PROC FAR        USES ES DS DI SI SP, WERT:DWORD, PLATZ:DWORD, \
                                             INDEX:DWORD
        LOCAL           STP:WORD
        @FCHECK         PLATZ,INDEX
        @CALL           __parni
        @FI2RET         STP
        RET
FPARNI  ENDP



COMMENT 
***
*	get INTEGER*4 from CLipper 
*
*	example:
*        INTEGER*4 NUMBER
*        INTEGER*2 ORDER,INDEX             ; don't skip the INDEX!
*
*        CALL FPARNL(NUMBER,ORDER,INDEX)
*	        
***
FPARNL  PROC FAR        USES ES DS DI SI SP, WERT:DWORD, PLATZ:DWORD, \
                                             INDEX:DWORD
        LOCAL           STP:WORD
        @FCHECK         PLATZ,INDEX
        @CALL           __parnl,STP
        LES             BX,DWORD PTR WERT
        MOV             WORD PTR ES:[BX],AX
        MOV             WORD PTR ES:[BX+2],DX
        RET
FPARNL  ENDP




COMMENT 
***
*	get DOUBLE from CLipper 
*
*	example:
*        REAL*8 NUMBER
*        INTEGER*2 ORDER,INDEX             ; don't skip the INDEX!
*
*        CALL FPARND(NUMBER,ORDER,INDEX)
*	        
***
FPARND  PROC FAR        USES ES DS DI SI SP, WERT:DWORD, PLATZ:DWORD, \
                                                         INDEX:DWORD
        LOCAL           STP:WORD
        @FCHECK         PLATZ,INDEX
        @CALL           __parnd, STP   
        MOV             DS,DX
        MOV             SI,AX
        MOV             CX,4
        LES             DI,DWORD PTR WERT
        PUSH            ES
        PUSH            DI
        REP             MOVSW
        POP             DI
        POP             ES
        RET
FPARND  ENDP




COMMENT 
***
*	get LOGICAL from CLipper 
*
*	example:
*        LOGICAL*1 WAHR
bm                                  
*        INTEGER*2 ORDER,INDEX             ; don't skip the INDEX!
*
*        CALL FPARL(WAHR,ORDER,INDEX)
*	        
***
FPARL   PROC FAR        USES ES DS DI SI SP, WERT:DWORD, PLATZ:DWORD, \
                                             INDEX:DWORD
        LOCAL           STP:WORD
        @FCHECK         PLATZ,INDEX
        @CALL           __parl
        @FI2RET         STP
        RET
FPARL  ENDP

COMMENT 
***
*	ask parinfO, same as for C' 
*       
*	example:
*        INTEGER*2 INF
*        INTEGER*2 ORDER             
*
*        CALL FPINFO(INF,ORDER)
*	        
***
FPINFO  PROC FAR        USES ES DS DI SI SP, WERT:DWORD, PLATZ:DWORD
        LOCAL           STP:WORD
        @FGET_I2        AX,PLATZ
        PUSH            AX
        @CALL           __parinfo
        @FI2RET         002H
        RET
FPINFO ENDP




COMMENT 
***
*	obtain ARRAY-Information, same as for C'
*       
*	example:
*        INTEGER*2 INF
*        INTEGER*2 ORDER,INDEX             ; don't skip the INDEX!
*
*        CALL FPINFA(INF,ORDER,INDEX)
*	        
***
FPINFA  PROC FAR        USES ES DS DI SI SP, WERT:DWORD, PLATZ:DWORD, \
                                             INDEX:DWORD
        LOCAL           STP:WORD
        @FCHECK         PLATZ,INDEX
        @CALL           __parinfa
        @FI2RET         STP
        RET
FPINFA ENDP




COMMENT 
***
*	obtain length of a string     
*       
*	example:
*        INTEGER*2 LENGTH
*        INTEGER*2 ORDER,INDEX             ; don't skip the INDEX!
*
*        CALL FPCLEN(LENGTH,ORDER,INDEX)
*	        
***
FPCLEN  PROC FAR        USES ES DS DI SI SP, WERT:DWORD, PLATZ:DWORD, \
                                             INDEX:DWORD
        LOCAL           STP:WORD
        @FCHECK         PLATZ,INDEX
        @CALL           __parclen
        @FI2RET         STP
        RET
FPCLEN ENDP




COMMENT 
***
*	obtain size of memory allocated for a string     
*       
*	example:
*        INTEGER*2 LENGTH
*        INTEGER*2 ORDER,INDEX             ; don't skip the INDEX!
*
*        CALL FPCSIZ(LENGTH,ORDER,INDEX)
*	        
***
FPCSIZ  PROC FAR        USES ES DS DI SI SP, WERT:DWORD, PLATZ:DWORD, \
                                             INDEX:DWORD
        LOCAL           STP:WORD
        @FCHECK         PLATZ,INDEX
        @CALL           __parclen
        @FI2RET         STP
        RET
FPCSIZ ENDP




COMMENT 
***
*	get DATE-STRING from Clipper     
*       
*	example:
*        CHARACTER*9 DATSTR
*        INTEGER*2 ORDER,INDEX             ; don't skip the INDEX!
*
*        CALL FPARDS(DATSTR,ORDER,INDEX)
*	        
***
FPARDS  PROC FAR        USES ES DS DI SI, DATUM:DWORD, PLATZ:DWORD, \
                                          INDEX:DWORD 
        LOCAL           STP:WORD 
        @FCHECK         PLATZ,INDEX
        @CALL           __pards,STP
     
        ; STRING- DATUM
        MOV             DS,DX
        MOV             SI,AX
        MOV             CX,004H
 
        ; QUELLE DS:SI
        ; ZIEL ES:SI
        LES             DI,DWORD PTR DATUM 
        
        ; FR DEN RCHTRANSPORT
        MOV             DX,ES
        MOV             AX,DI
     
        ; KOPIERE..
        REP             MOVSW 
        RCL             CX,001H
        REP             MOVSB

        ; FORTRAN - FANCY
        MOV             WORD PTR ES:[DI],27H
        INC             DI
        MOV             WORD PTR ES:[DI],000H

        RET
FPARDS  ENDP
;-----------< End of functions for the Extend-System >----------------------*


;-----------< To be able to use the following functions, you have to link 
;                        with Rich McConnell's EXTOR.OBJ

COMMENT 
***
*	Return REAL*8 (DOUBLE) by REFERENCE to Clipper     
*       Don't forget to mark the parameter with the @ before you pass 
*        it to Fortran!
*
*	example:
*        REAL*8 NUMBER
*        INTEGER*2 ORDER,INDEX,ERR_FLAG           !! don't skip the INDEX!
*
*        CALL FSTOND(NUMBER,ORDER,INDEX,ERR_FLAG)
*	 
*        IF ERR_FLAG = 0 ->  ERROR
***
FSTOND  PROC FAR        USES ES DS DI SI, WERT:DWORD, PLATZ:DWORD, \
                                          INDEX:DWORD, ERR_FLAG:DWORD 
        LOCAL           STP:WORD
        @FCHECK         PLATZ,INDEX
        @FISARR
        @FGET_R8        WERT
        @CALL           __stornd
        @STACK_POP      +008H
BYE:    @FRET_I2        ERR_FLAG,AX
        RET
FSTOND  ENDP    




COMMENT 
***
*	Return REAL*8 (DOUBLE) by REFERENCE to Clipper & adjust decimals     
*       Don't forget to mark the parameter with the @ before you pass it
*        to Fortran!
*
*	example:
*        REAL*8 NUMBER
*        INTEGER*2 DECIML,ORDER,INDEX,ERR_FLAG     !! don't skip the INDEX!
*
*        CALL FSTNDC(NUMBER,DECIML,ORDER,INDEX,ERR_FLAG)
*	        
*        IF ERR_FLAG = 0 ->  ERROR
*	        
***
FSTNDC  PROC FAR        USES SS ES DS DI SI, WERT:DWORD, DEZIMAL:DWORD, \
                                             PLATZ:DWORD,INDEX:DWORD, \
                                             ERR_FLAG:DWORD 
        LOCAL           STP:WORD
        @FCHECK         PLATZ,INDEX
        @FISARR
        @FGET_I2        AX,DEZIMAL   
        @FGET_R8        WERT
        @CALL           __storndec
        @STACK_POP      +00AH
BYE:    @FRET_I2        ERR_FLAG,AX
        RET
FSTNDC  ENDP    




COMMENT 
***
*	Return INTEGER*4 (LONG) by REFERENCE to Clipper     
*       Don't forget to mark the parameter with the @ before you pass it
*        to Fortran!
*
*	example:
*        INTGER*4 NUMBER
*        INTEGER*2 ORDER,INDEX,ERR_FLAG           !! don't skip the INDEX!
*
*        CALL FSTONL(NUMBER,ORDER,INDEX,ERR_FLAG)
*	 
*        IF ERR_FLAG = 0 ->  ERROR
***
FSTONL    PROC FAR      USES ES DS DI SI, WERT:DWORD, PLATZ:DWORD, \
                                         INDEX:DWORD, ERR_FLAG:DWORD 
          LOCAL         STP:WORD
          @FCHECK       PLATZ,INDEX
          @FISARR
          @FGET_I4      WERT
          @CALL         __stornl
          @STACK_POP    +004H
BYE:      @FRET_I2        ERR_FLAG,AX
          RET
FSTONL    ENDP    




COMMENT 
***
*	Return INTEGER*2 by REFERENCE to Clipper     
*       Don't forget to mark the parameter with the @ before you pass 
*        it to Fortran!
*
*	example:
*        INTGER*2 NUMBER
*        INTEGER*2 ORDER,INDEX,ERR_FLAG           !! don't skip the INDEX!
*
*        CALL FSTONI(NUMBER,ORDER,INDEX,ERR_FLAG)
*	 
*        IF ERR_FLAG = 0 ->  ERROR
***
FSTONI    PROC FAR      USES ES DS DI SI, WERT:DWORD, PLATZ:DWORD, \
                                          INDEX:DWORD, ERR_FLAG:DWORD 
          LOCAL         STP:WORD
          @FCHECK       PLATZ,INDEX
          @FISARR
          @FGET_I2      AX,WERT
          @CALL         __storni
          @STACK_POP    +002H
BYE:      @FRET_I2      ERR_FLAG,AX
          RET
FSTONI    ENDP    




COMMENT 
***
*	Return LOGICAL*1 by REFERENCE to Clipper     
*       Don't forget to mark the parameter with the @ before you pass it
*        to Fortran!
*
*	example:
*        LOGICAL*1 WAHR
*        INTEGER*2 ORDER,INDEX,ERR_FLAG           !! don't skip the INDEX!
*
*        CALL FSTOL(WAHR,ORDER,INDEX,ERR_FLAG)
*	 
*        IF ERR_FLAG = 0 ->  ERROR
***
FSTOL     PROC FAR      USES ES DS DI SI, WERT:DWORD, PLATZ:DWORD, \
                                          INDEX:DWORD, ERR_FLAG:DWORD 
          LOCAL         STP:WORD
          @FCHECK       PLATZ,INDEX
          @FISARR
          @FGET_I2      AX,WERT
          @CALL         __storl
          @STACK_POP    +002H
BYE:      @FRET_I2        ERR_FLAG,AX
          RET
FSTOL     ENDP    




COMMENT 
***
*	Return STRING by REFERENCE to Clipper     
*       Don't forget to mark the parameter with the @ before you pass it
*        to Fortran!
*
*	example:
*        CHARACTER*20 STRING
*        INTEGER*2 ORDER,INDEX,ERR_FLAG           !! don't skip the INDEX!
*
*        CALL FSTOC(STRING,ORDER,INDEX,ERR_FLAG)
*	 
*        IF ERR_FLAG = 0 ->  ERROR
***
FSTOC   PROC FAR        USES ES DS DI SI, STRING:DWORD, PLATZ:DWORD, \
                                          INDEX:DWORD, ERR_FLAG:DWORD
        LOCAL           STP:WORD
        @FCHECK         PLATZ,INDEX
        @FISARR
        @FGET_PTR       STRING
        MOV             BX,AX
        MOV             DS,DX
        @CALL           _strlen,004h
        DEC             AX
        MOV             DI,AX
        MOV             WORD PTR DS:[BX+DI],000H
        PUSH            DS
        PUSH            BX
        @CALL           __storc
        @STACK_POP      +004H
BYE:    @FRET_I2        ERR_FLAG,AX
        RET
FSTOC   ENDP




COMMENT 
***
*	Return DATE-STRING by REFERENCE to Clipper     
*       Don't forget to mark the parameter with the @ before you pass it
*         to Fortran!
*
*	example:
*        CHARACTER*9 STRING
*        INTEGER*2 ORDER,INDEX,ERR_FLAG           !! don't skip the INDEX!
*
*        CALL FSTODS(STRING,ORDER,INDEX,ERR_FLAG)
*	 
*        IF ERR_FLAG = 0 ->  ERROR
***
FSTODS  PROC FAR        USES ES DS DI SI, STRING:DWORD, PLATZ:DWORD, \
                                          INDEX:DWORD, ERR_FLAG:DWORD
        LOCAL           STP:WORD
        @FCHECK         PLATZ,INDEX
        @FISARR
        @FGET_PTR       STRING
        MOV             BX,AX
        MOV             DS,DX
        MOV             WORD PTR DS:[BX+9],000H
        @CALL           __stords
        @STACK_POP      +004H
BYE:    @FRET_I2        ERR_FLAG,AX
        RET
FSTODS  ENDP




COMMENT 
***
*	Return STRING of specified length by REFERENCE to Clipper     
*       Don't forget to mark the parameter with the @ before you pass it
*        to Fortran!
*
*	example:
*        CHARACTER*20 STRING
*        INTEGER*2 LENGTH,ORDER,INDEX,ERR_FLAG      !! don't skip the INDEX!
*
*        CALL FSTCLN(STRING,LENGTH,ORDER,INDEX,ERR_FLAG)
*	 
*       IF ERR_FLAG = 0 ->  ERROR
***
FSTCLN  PROC FAR        USES ES DS DI SI, STRING:DWORD, LAENGE:DWORD, \
                                          PLATZ:DWORD, INDEX:DWORD, \
                                          ERR_FLAG:DWORD
        LOCAL           STP:WORD
        @FCHECK         PLATZ,INDEX
        @FISARR
        @FGET_I2        AX,LAENGE         
        @FGET_PTR       STRING
        @CALL           __storclen
        @STACK_POP      +006H
BYE:    @FRET_I2        ERR_FLAG,AX
        RET
FSTCLN  ENDP

ENDIF
END

