*  Program Ŀ
*                                                                           
*     File Name: STACK.PRG                                                  
*     Copyright: (c) 1996 by Smart Office Solutions                         
*        Author: Ren van der Lende                                         
*                                                                           
*   Description: Stack Class, LIFO style (Last In, First Out)               
*                                                                           
* Ĵ
*  Date created: 01-01-96              Date updated: 01-01-96              
* 
#include "classes.ch"

**
function StackNew()
**
return Stack():Init()


**
CREATE CLASS Stack
**

EXPORT:
   
#ifdef CLPCLASSES
   VAR aItems            METHOD STC_aIte         // (A) Array of stack items
   VAR nItems            METHOD STC_nIte         // (N) Length of the stack
#else
   VAR aItems            READONLY
   VAR nItems            READONLY
#endif

   MESSAGE Init          METHOD STC_Init        CONSTRUCTOR

   MESSAGE Peek          METHOD STC_Peek
   MESSAGE Pop           METHOD STC_Pop
   MESSAGE Push          METHOD STC_Push

END CLASS

#ifdef CLPCLASSES
**
   VAR METHOD STC_aIte FOR  1
   VAR METHOD STC_nIte FOR  2
**
#endif

**
METHOD STC_Init()
**
   ::aItems := {}
   ::nItems := 0
END METHOD


**
METHOD STC_Peek()
**
local xRetVal

   if ::nItems > 0
      xRetVal := ATAIL( ::aItems )
   endif
return xRetVal


**
METHOD STC_Pop()
**
local xRetVal

   if ::nItems > 0
      xRetVal := ATAIL( ::aItems )
      ASIZE( ::aItems, ::nItems-1 )
      ::nItems--
   endif
return xRetVal


**
METHOD STC_Push( xValue )
**
local xRetVal

   if ::nItems > 0
      xRetVal := ATAIL( ::aItems )
   endif

   AADD( ::aItems, xValue )
   ::nItems++

return xRetVal
