*  Clipper Header Ŀ
*                                                                           
*     File Name: CLPCLS.CH                                                  
*     Copyright: (c) 1996 by Smart Office Solutions                         
*        Author: Antonio Linares and Francisco Pulpn                       
*                authors of FiveWin for Clipper                             
*                                                                           
*     Adaptions: Ren van der Lende                                         
*                                                                           
*   Description: Defines for use with CLIPPER internal CLASS engine         
*                                                                           
* Ĵ
*  Date created: 01-01-96              Date updated: 01-01-96              
* 

#ifndef _CLPCLS_CH

   #define _CLPCLS_CH
   #define _FuncType_


   // Class declaration
   // =================

   #xcommand CLASS <ClsName>                                      ;
       =>                                                         ;
             function <ClsName>()                                ;;
                static nClassH := 0                              ;;
                if nClassH = 0                                   ;;
                   if ( nClassH := _SetNewClass( #<ClsName> ) ) = 0

   #xtranslate CREATE CLASS <ClsName> =>  CLASS <ClsName>


   // Instance variable declaration
   // =============================

   // SCOPE and CONSTRUCTOR are dummies

   #xcommand _GEN_DATA_ <vt>, <v>, <m> ;
            [ <scp: PUBLIC, EXPORT, READONLY, PROTECTED, LOCAL, HIDDEN> ] =>  ;
            _AddMethod( #<v>, #<m>, __SCOPE__ [ <scp> ], .F., <vt> )

   #xcommand VAR     <v> METHOD <m> => _GEN_DATA_  1, <v>, <m>
   #xcommand INSTVAR <v> METHOD <m> => VAR <v> METHOD <m>
   #xcommand DATA    <v> METHOD <m> => VAR <v> METHOD <m>


   // Method declarations
   // ===================

   #xcommand __METHOD__ <Met> [, <MetN> ] [ <scp: PUBLIC, EXPORT, LOCAL, HIDDEN> ] [ <CONSTRUCTOR> ] => ;
      _AddMethod( _MetTrans_(<Met>) [,_MetTrans_(<MetN>)], __SCOPE__ [ <scp> ], <.CONSTRUCTOR.>, 0 )

   #xcommand _GEN_METHOD_ <Met> [,<MetN> ] [<*x*>] =>  ;
             __METHOD__  <Met> [,<MetN> ]  [<x>]

   #xcommand _GEN_METHOD_ <Met> VIRTUAL [<*x*>] => __METHOD__ <Met>:_VIRTUAL_ [<x>]

   #xcommand _GEN_METHOD_ <Met> [IS] NULL       => __METHOD__ <Met>:_VIRTUAL_

   #xcommand _GEN_METHOD_ <Met> [IS] DEFERRED   => __METHOD__ <Met>:_VIRTUAL_

   #xcommand _GEN_METHOD_ <Met> METHOD <udf> [, <MetN> METHOD <udfN> ] [<*x*>] => ;
             __METHOD__ <Met> = <udf> [ , <MetN> = <udfN> ] [<x>]

   #xcommand MESSAGE <*cMDesc*>   => _GEN_METHOD_ <cMDesc>

   #xcommand  __ST__  <st: METHOD, MESSAGE, VAR, INSTVAR, DATA > <*x*> ;
                     => <st> <x>

   #xcommand EXPORT  <*x*> => __ST__ <x> PUBLIC
   #xcommand HIDE    <*x*> => __ST__ <x> HIDDEN
   #xcommand PROTECT <*x*> => __ST__ <x> PROTECTED


   // Scope declarations (NOT USED)
   // ==================
   #xcommand EXPORT:     =>
   #xcommand PUBLIC:     =>   EXPORT:
   #xcommand PROTECTED:  =>
   #xcommand READONLY:   =>   PROTECTED:
   #xcommand LOCAL:      =>
   #xcommand HIDDEN:     =>   LOCAL:

   #xtranslate __SCOPE__                                => NIL
   #xtranslate __SCOPE__ <scp: PUBLIC, EXPORT>          => 0
   #xtranslate __SCOPE__ <scp: READONLY, PROTECTED>     => 1
   #xtranslate __SCOPE__ <scp: LOCAL, HIDDEN>           => 2

   #xtranslate _MetTrans_( <Met> ) => ;
               _AsStr_( <Met> ), _AsStr_( <Met> )

   #xtranslate _MetTrans_( <Met> = <udf> ) => ;
               _AsStr_( <Met> ), _AsStr_( <udf> )

   #xtranslate _MetTrans_( <Met>:_VIRTUAL_ ) => ;
               _AsStr_( <Met> ), "_VIRTUAL_"

   #xtranslate _AsStr_( <itm> ) => #<itm>
   #xtranslate _AsStr_( <itm>( [<prm,...>] ) ) =>  #<itm>

   #xtranslate :VIRTUAL => :_VIRTUAL_

   #xcommand ENDCLASS  =>                                ;
                             nClassH := _AddNewClass()  ;;
                             elseif nClassH = -1        ;;
                                return NIL              ;;
                             end                        ;;
                          end                           ;;
                          return __CLASSINS( nClassH )  ;;
                          #include "clpclsen.ch"

   #xcommand END CLASS  => ENDCLASS



   // ==========================================================================

   #xcommand _METHOD_ <Tp: FUNCTION, PROCEDURE> <Met> [ CLASS <ClassN> ] =>;
                     _FuncType_ <Tp> <Met>  ;;
                     local Self := QSelf()

   #translate METHOD <Tp: FUNCTION, PROCEDURE> <*Met*> => ;
                    _METHOD_ <Tp> <Met>

   #translate METHOD <ClassN>::<*Met*>        => ;
                    _METHOD_ FUNCTION <Met>

   #translate METHOD <ClassN>.<*Met*>         => ;
                    _METHOD_ FUNCTION <Met>


   //   Self
   //  ======
   #xtranslate ::      =>    Self:


#endif  // _CLPCLS_CH

#xcommand METHOD <*MDesc*> =>  _GEN_METHOD_ <MDesc>
