*  Program Ŀ
*                                                                           
*     File Name: CREATOR.PRG                                                
*     Copyright: (c) 1996 by Smart Office Solutions                         
*        Author: Ren van der Lende                                         
*                                                                           
*   Description: General Class creator for Clipper 5.2/3                    
*                                                                           
* Ĵ
*  Date created: 01-01-96              Date updated: 01-01-96              
* 

STATIC saVar, saMeth, saClasses := {}, snCurrent := 0
STATIC scNewClass, slCanAdd := .F., snScope := 0


**
function _Virtual_()
**
return QSelf()


**
function _SetNewClass( cClassName )
**
local nPos    := 0
local nHandle := -1

   if .not. slCanAdd         /* Initialize creation of a new class */
      cClassName := UPPER(ALLTRIM(cClassName))

      if ( nPos := ASCAN( saClasses, { |a| a[1] == cClassName } ) ) = 0
         AADD( saClasses, { cClassName, -1 } )
         snCurrent  := LEN( saClasses )
         scNewClass := cClassName
         saVar      := {}
         saMeth     := {}
         slCanAdd   := .T.
         nHandle    := 0
      else
         nHandle := saClasses[nPos,2]
      endif
   endif
return nHandle


**
function _AddMethod( cMessage, cMethod, nScope, lConstr, nType )
**
   if slCanAdd
      if nType = 0                     /* Add a method */
         AADD( saMeth, { cMessage, cMethod } )
      else                             /* Add a variable */
         AADD( saVar, { cMessage, cMethod } )
      endif
   endif
return NIL


**
function _AddNewClass()
**
local nHandle := 0

   if slCanAdd               /* Create the new class */
      nHandle := __CLASSNEW( scNewClass, LEN( saVar ) )

      if !EMPTY( saVar )     /* Fill class with instance variables */
         AEVAL( saVar, { |a| __CLASSADD( nHandle,       a[1], a[2] ),;
                             __CLASSADD( nHandle, "_" + a[1], a[2] ) } )
      endif
      if !EMPTY( saMeth )    /* Fill class with methods */
         AEVAL( saMeth, { |a| __CLASSADD( nHandle, a[1], a[2] ) } )
      endif

      saClasses[snCurrent,2] := nHandle

                             /* Reset workvar's */
      scNewClass := ""
      slCanAdd   := .F.
      saVar      := {}
      saMeth     := {}
   endif
return nHandle
