* PASSWORD.PRG
* APPLICATION PASSWORD GENERATION PROGRAM by Gary L. Cota
*     created: 07/27/88
* last update: 12/02/88
*
CLEAR ALL
CLOSE ALL
SET BELL       OFF
SET CONFIRM    ON
SET DELETED    ON
SET DELIMITER  OFF
SET ECHO       OFF
SET EXACT      OFF
SET EXCLUSIVE  ON
SET INTENSITY  ON
SET SAFETY     OFF
SET SCOREBOARD OFF
SET TALK       OFF
SET WRAP       ON
*
*************************************************************
* The current field assignments for ??WTFO are as follows:  *
*                                                           *
*  F01 .......... LOG_OUT  - Did the user exit normally?    *
*  F02 .......... TIME_OUT - Time user logged out           *
*  F03 .......... DATE_OUT - Date user logged out           *
*  F04 .......... TIME_IN  - Time user logged in            *
*  F05 .......... DATE_IN  - Date user logged in            *
*  F06 .......... SECURITY - User access level (ENCRYPT)    *
*  F07 .......... USERPASS - User password (PASSWORD)       *
*  F08 .......... USERNAME - User name (ENCRYPT)            *
*  F09 .......... DUMMY    - Bogus field                    *
*  F10 .......... DUMMY    - Bogus field                    *
*  F11 .......... PRINTER  - Local or Network printer       *
*  F12 .......... SERVER   - Network SERVER name (for       *
*                            print spooling purposes)       *
*  F13 .......... DUMMY    - Bogus field                    *
*  F14 .......... DUMMY    - Bogus field                    *
*                                                           *
* If the field order seems strange, it is deliberate.  The  *
* order is the inverse of the original .dbf structure.  The *
* original field names are also listed.                     *
*                                                           *
* NOTE:  PASSWORD indicates field is protected using the    *
* c_PASSWORD() function; ENCRYPT indicated fields are       *
* protected using the c_ENCRYPT() function. Both of these   *
* functions are 100% CLIPPER and are found at the bottom    *
* of this program.                                          *
*************************************************************
*
* SET COLOR TO GR+/N,GR+/B,W+/N,BG+/B   && color monitors
SET COLOR TO W/N,N/W+,,,N/W             && COMPAQ monitor
DO WHILE .T.
   CLEAR
   MFILE=SPACE(13)
   @ 12,13 SAY "ENTER SYSTEM CONTROL FILE OR ESC TO CANCEL" GET MFILE PICTURE "!!!!!!!!.!!!"
   READ
   IF EMPTY(MFILE)
      QUIT
   ENDIF
   IF .NOT. FILE("&MFILE.")
      MMSG="FILE NOT FOUND - PRESS ANY KEY TO CONTINUE"
      ?? CHR(7)
      @ 23,40-(LEN(MMSG)/2) SAY MMSG
      SET CONSOLE OFF
      WAIT
      SET CONSOLE ON
   ELSE
      USE &MFILE.
      ZAP
      EXIT
   ENDIF
ENDDO
*
DO WHILE .T.
   **********************************************
   * Encryption routine uses a "key" to further *
   * alter display of secured information.      *
   **********************************************
   mPASSWORD=SPACE(10)
   mNAME=SPACE(10)
   mLEVEL=0
   mKEY="#@$uSa!&*"
   mHEADING="APPLICATIONS SYSTEM USER PASSWORD & ACCESS ENCRYPTION MODULE"
   CLEAR
   @ 01,40-(LEN(mHEADING)/2) SAY mHEADING
   @ 05,08 SAY "                                       Encrypted      Decrypted"
   @ 07,08 SAY "User Name ............."
   @ 09,08 SAY "User Password ........."
   @ 11,08 SAY "User Access Level ....."
   mPROMPT="Enter USER information or press ESCape when finished"
   @ 22,40-(LEN(mPROMPT)/2) SAY mPROMPT
   *
   @ 07,32 GET mNAME PICTURE "@!"
   @ 09,32 GET mPASSWORD PICTURE "@!"
   @ 11,32 GET mLEVEL PICTURE "99"
   READ
   CLEAR GETS
   IF EMPTY(mNAME) .OR. LASTKEY()=27
      EXIT
   ENDIF
   *
   *********************************
   * Pad leading blanks with zeros *
   *********************************
   mWork=IIF(mLEVEL<10,STR(mLEVEL,1,0),STR(mLEVEL,2,0))
   mLEVEL=IIF(LEN(mWork)=1,"000000000"+mWork,"00000000"+mWork)
   *
   LOCATE FOR c_ENCRYPT(mNAME,mKEY)=F08
   *
   *******************************************
   * If user is not on file, add.  If user   *
   * is on file replace password and access  *
   * level with entries.  Note all entries   *
   * are encrypted using c_PASSWORD() func-  *
   * tion provided below.                    *
   *******************************************
   *
   IF EOF()
      mREPLY="Y"
      ?? CHR(7)
      @ 22,0
      @ 22,15 SAY "User info not found - Do you wish to Add (Y/N)?" GET mREPLY PICTURE "!" VALID(mREPLY$"YN")
      READ
      IF mREPLY="N"
         LOOP
      ENDIF
      *
      APPEND BLANK
   ENDIF
   *
   **********************************
   * Encrypt the bogus field values *
   **********************************
   mwork=c_ENCRYPT("AbCdEfGhiJ","OHMYOHMYOH")
   REPLACE F13 WITH mwork
   mwork=c_ENCRYPT("!@#$%^&*()","1234567890")
   REPLACE F14 WITH mwork
   REPLACE F10 WITH 102+c_PASSWORD(mKEY),F09 WITH c_PASSWORD(mKEY)
   *
   *****************************
   * Encrypt work field values *
   *****************************
   REPLACE F08 WITH c_ENCRYPT(mNAME,mKEY),F07 WITH c_PASSWORD(mPASSWORD,mKEY),F06 WITH c_ENCRYPT(mLEVEL,mKEY)
   REPLACE F01 WITH .F.,F02 WITH TIME(),F03 WITH DATE(),F04 WITH TIME(),F05 WITH DATE()
   *
   ******************************************
   * Set printer fields as LOCAL, no SERVER *
   ******************************************
   REPLACE F11 WITH "LOCAL",F12 WITH "NO SERVER"
   *
   *
   @ 07,47 SAY c_ENCRYPT(mNAME,mKEY)
   @ 07,62 SAY c_DECRYPT(F08,mKEY)
   @ 09,47 SAY c_PASSWORD(mPASSWORD,mKEY) PICTURE "999999999"
   @ 11,47 SAY c_ENCRYPT(mLEVEL,mKEY)
   @ 11,62 SAY c_DECRYPT(F06,mKEY)
   *
   mprompt="USER RECORD HAS BEEN ADDED/UPDATED - PRESS ANY KEY TO CONTINUE"
   @ 22,0
   @ 22,40-(LEN(mprompt)/2) SAY mprompt
   SET CONSOLE OFF
   WAIT
   SET CONSOLE ON
ENDDO
CLEAR
QUIT
*
**********************************
* User Defined Functions follow: *
**********************************
*
FUNCTION c_ALLTRIM
   ************************************************************************
   *  PASS:     <expC1>                                                   *
   *                                                                      *
   *  RETURNS:  The character string minus trimmed leading and trailing   *
   *            spaces.                                                   *
   *                                                                      *
   *  PURPOSE:  Uses less memory space than it's CLIPPER counterpart.     *
   *                                                                      *
   *  EXAMPLE:  mfirst = FIRST_NAME                                       *
   *            mlast  = LAST_NAME                                        *
   *            ? c_ALLTRIM(mfirst)+" "+c_ALLTRIM(mlast)                  *
   ************************************************************************
   *
   PARAMETERS _in_string
   *
RETURN(LTRIM(TRIM(_in_string)))
*
*
*
FUNCTION c_DECRYPT
   ************************************************************************
   *  PASS:     <expC1>, <expC2> (optional)                               *
   *                                                                      *
   *  RETURNS:  Character string                                          *
   *                                                                      *
   *  PURPOSE:  Use to decrypt a Character string that was encrypted      *
   *            using the c_ENCRYPT() function.                           *
   *  ------------------------------------------------------------------  *
   *  NOTE:  If customization is required, change the value being sub-    *
   *         tracted in the CHR() statement of the FOR...NEXT loop below. *
   *         But beware this value must match that being added in the     *
   *         c_ENCRYPT() function.                                        *
   *                                                                      *
   *  NOTE:  This function requires the c_ALLTRIM() and c_FILL_OUT func-  *
   *         tions to be present during the compile and link cycles.      *
   ************************************************************************
   PARAMETERS _in_string, _in_key
   *
   ****************************************
   * If second parameter has been passed, *
   * add key value to password value      *
   ****************************************
   IF PCOUNT()=2
      _ma_ = LEN(_in_key)
      _mc_ = 0
      _mx_ = 0
      FOR _mc_ = 1 TO (_ma_ + 1)
          _mx_ = _mx_ + ASC(SUBSTR(_in_key,_mc_,1)) * _mc_ + _mc_
      NEXT
   ELSE
      _mx_ = 155        &&  Arbitrary value - may be from 0 to 255 (ASCII)
   ENDIF
   *
   ********************************
   * Decrypt <expC1> *
   ********************************
   _ma_ = LEN(_in_string)
   _mb_ = ""
   _mc_ = 0
   _in_string = c_ALLTRIM(_in_string)
   *
   FOR _mc_ = LEN(_in_string) TO 1 STEP -1
       _mb_ = _mb_ + CHR(ASC(SUBSTR(_in_string,_mc_,1)) - _mx_ )
   NEXT
   *
RETURN(c_FILL_OUT(_mb_,_ma_))
*
*
*
FUNCTION c_ENCRYPT
   ************************************************************************
   *  PASS:     <expC1>, <expC2> (optional)                               *
   *                                                                      *
   *  RETURNS:  Character string                                          *
   *                                                                      *
   *  PURPOSE:  Used to encrypt a Character string that was encrypted     *
   *            using the c_DECRYPT() function.                           *
   *  ------------------------------------------------------------------  *
   *  NOTE:  If customization is required, change the value being added   *
   *         in the CHR() statement of the FOR...NEXT loop below.  But    *
   *         beware this value must match that being subtracted in the    *
   *         c_DECRYPT() function.                                        *
   *                                                                      *
   *  NOTE:  The second character string parameter has been added for     *
   *         even more protection.  If passed, this second parameter is   *
   *         as a "key" value.  The ASCII value of this "key" is added to *
   *         the CHR() value.  If this parameter is used, the value com-  *
   *         puted must match that of the parameter passed in the         *
   *         c_DECRYPT() function.                                        *
   *                                                                      *
   *  NOTE:  This function requires the c_ALLTRIM() and c_FILL_OUT()      *
   *         functions to be present during the compile and link cycles.  *
   ************************************************************************
   PARAMETERS _in_string, _in_key
   *
   ****************************************
   * If second parameter has been passed, *
   * add key value to password value      *
   ****************************************
   IF PCOUNT()=2
      _ma_ = LEN(_in_key)
      _mc_ = 0
      _mx_ = 0
      FOR _mc_ = 1 TO (_ma_ + 1)
          _mx_ = _mx_ + ASC(SUBSTR(_in_key,_mc_,1)) * _mc_ + _mc_
      NEXT
   ELSE
      _mx_ = 155        &&  Arbitrary value - may be from 0 to 255 (ASCII)
   ENDIF
   *
   ********************************
   * Encrypt <expC1> *
   ********************************
   _ma_ = LEN(_in_string)
   _mb_ = ""
   _mc_ = 0
   _in_string = c_ALLTRIM(_in_string)
   *
   FOR _mc_ = LEN(_in_string) TO 1 STEP -1
       _mb_ = _mb_ + CHR(ASC(SUBSTR(_in_string,_mc_,1)) + _mx_ )
   NEXT
   *
RETURN(c_FILL_OUT(_mb_,_ma_))
*
*
*
FUNCTION c_FILL_OUT
   ************************************************************************
   *  PASS:     <expC1>, <expN1>                                          *
   *                                                                      *
   *  RETURNS:  Character string                                          *
   *                                                                      *
   *  PURPOSE:  Pads Character string with spaces defaulting to a width   *
   *            of 79 if no numeric string is passed.                     *
   *                                                                      *
   *  EXAMPLE:  @ 01,23 PROMPT "File Maintenance" MESSAGE(c_CNTR_MSG(;    *
   *            c_FILL_OUT("Add, Delete, Edit System Records"))           *
   *  ------------------------------------------------------------------  *
   *  NOTE:  The UDF c_CNTR_MSG must be present for this function to      *
   *         in the above example.                                        *
   ************************************************************************
   PARAMETERS _mx_,_my_
   *
   IF TYPE("_my_")="U"
      * Length is undefined, default to 79
      _my_=79
   ENDIF
   _mz_=_my_ - LEN(_mx_)
RETURN(_mx_ + SPACE(_mz_))
*
*
*
FUNCTION c_PASSWORD
   ************************************************************************
   *  PASS:     <expC1>, <expC2> (optional)                               *
   *                                                                      *
   *  RETURNS:  Numeric string                                            *
   *                                                                      *
   *  PURPOSE:  Generates a numeric value for any string based on the     *
   *            ASCII value of each character multiplied by its relative  *
   *            position in the character string.                         *
   *                                                                      *
   *  EXAMPLE:  In the following code, a second parameter has been        *
   *            (mpw_key).                                                *
   *                                                                      *
   *            mpw_key = "@!$xYz&*+"                                     *
   *            USE PASSWORD.DBF                                          *
   *            mPASSWORD= SPACE(10)                                      *
   *            @ 1,5 SAY "ENTER PASSWORD " GET mPASSWORD                 *
   *            READ                                                      *
   *            IF mPASSWORD=SPACE(10)                                    *
   *               QUIT                                                   *
   *            ELSE                                                      *
   *               LOCATE FOR c_PASSWORD(mPASSWORD,mpw_key)=F07           *
   *               IF EOF()                                               *
   *                  ?? CHR(7)                                           *
   *                  @ 5,5 SAY "INVALID PASSWORD"                        *
   *               ELSE                                                   *
   *                  .....                                               *
   *                  other commands                                      *
   *                  .....                                               *
   *               ENDIF                                                  *
   *            ENDIF                                                     *
   *                                                                      *
   *  ------------------------------------------------------------------  *
   *  NOTE:  As a added precaution, if the second parameter has been      *
   *         passed it is added into the overall value that is returned.  *
   *         This "key" value can be hardcoded in the main module or      *
   *         placed in a type of data (.MEM, .DBF) file prior to branch-  *
   *         ing to the password verification routine.                    *
   *                                                                      *
   ************************************************************************
   PARAMETERS _in_string, _in_key
   *
   _ma_ = LEN(TRIM(_in_string))
   _mb_ = 0
   *
   **************************
   * Compute password value *
   **************************
   FOR _mc_ = 1 TO (_ma_ + 1)
       _mb_ = _mb_ + ASC(SUBSTR(_in_string,_mc_,1)) * _mc_
   NEXT
   *
   ****************************************
   * If second parameter has been passed, *
   * add key value to password value      *
   ****************************************
   IF PCOUNT()=2
      _ma_ = LEN(TRIM(_in_key))
      FOR _mc_ = 1 TO (_ma_ + 1)
          _mb_ = _mb_ + ASC(SUBSTR(_in_string,_mc_,1)) * _mc_
      NEXT
   ENDIF
   *
RETURN(_mb_)
*
*
*

