** Note that INTR is a function (at the end of this, that calls INTERRUPT)
** INTR converts the 8 "8-bit valued variables" and converts them into 16-bits
** Note that all INTR are in the form of:
**   INTR(i#,ah,al,bh,bl,ch,cl,dh,dl)
**

** Scrolling demo
*****************************************************************
*****************************************************************

for i = 1 to 10
   @ i+7,9 say "There's the scrolling bit - up, down, up, etc..."
next i

for i = 1 to 5
   for j = 1 to 7
      INTR(16,07,01,07,00,00,00,24,79)     && Scroll down
   next j

   for j = 1 to 7
      INTR(16,06,01,07,00,00,00,24,79)     && Scroll up
   next j
next i

** Clearscreen demo
*****************************************************************
*****************************************************************
@ 20,10 say "Or we can clear the screen rather quickly"
wait

INTR(16,07,00,07,00,00,00,24,79)           && Clear the screen


** Stuff demo
*****************************************************************
*****************************************************************

stuff = INTR(17,00,00,00,00,00,00,00,00)
? "You could disassemble ",stuff," to determine monitor type,RAM,printers,etc"
? "Sorry, I'm too lazy"
?
?
stuff = INTR(18,00,00,00,00,00,00,00,00)
? "It says you have",ltrim(str(stuff)),"K of regular RAM"

INTR(20,00,131,00,00,00,00,01,00)
? "Your COM port 1 is initialized to 8-N-1 (big deal, huh)"
?
?
inkey(2)


? "If you've a mono monitor, hit ALT-C here 'cuz it won't work"
wait


INTR(16,07,00,07,00,00,00,24,79)           && Clear the screen

INTR(16,00,06,00,00,00,00,00,00)           && Go into graphics mode

for i = 20 to 600 step 20
   for j = 1 to 200 step int(i/5)+1
      interrupt(16,3073,0,i,j)                  && It's easier calling the ASM
      interrupt(16,3073,0,i+10,200-j)           &&  function directly
      interrupt(16,3073,0,600-i,j)
      interrupt(16,3073,0,600-i+10,200-j)
   next j
next i
INKEY(0)


INTR(16,00,02,00,00,00,00,00,00)           && Go into text mode


@ 3,3 say "I think you get the point"

return


*****************************************************************
*****************************************************************
&& Executes the interrupt specified in int_num

function INTR
parameters int_num,ah,al,bh,bl,ch,cl,dh,dl
private ax,bx,cx,dx

ax = ah*256+al          && Join the highs and lows to form the x's
bx = bh*256+bl
cx = ch*256+cl
dx = dh*256+dl

return interrupt(int_num,ax,bx,cx,dx)
*****************************************************************




