#include "nandef.h"
#include "extend.h"

/*
    John T. Opincar, Jr.
    04-17-90

    NOTE -- Dave Seiber discovered most of the items in the database structure.
    Steve Larson also contributed a few (could be more that I am not aware of).
    I can only lay claim to four of them.

    This file contains type definitions which allow you to access Clipper's
    internal structures for databases and the software stack.  A brief
    explanation of how to access the databases follows.

    _dbf is an array of pointers to database structures.  _dbf[0] always points
    to the currently SELECTed database.  _dbf[1..255] are pointers to the
    databases currently in USE in the corresponding areas.  For example, if
    in Clipper the following lines were executed:
        select 1
        use dbf1
        select 2
        use dbf2
    then _dbf[0] and _dbf[2] would both point the internal structure for dbf2
    while _dbf[1] would point to the internal structure for dbf1.

    Thus, if I wanted to query eof() for dbf2 then the appropriate C expression
    would be:
        _dbf[2]->eof
    And since dbf2 is currenly SELECTed, _dbf[0]->eof would return the same
    thing.  The other items can be similarly accessed.

    The items uk1..n are placeholders for data whose meaning is unknown (to me).
*/

/* union types for __tos, the clipper software stack */
typedef struct _isint {     /* type == 0x0002 */
    long    numberi;
} isint;

typedef struct _isreal {    /* type == 0x0008 */
    double  numberr;
} isreal;

typedef struct _isdate {    /* type == 0x0020 */
    long    dayoffset;      /* date - 01/01/0100 + 1757585 */
    int     size;           /* bytes req'd to store date as string */
} isdate;

typedef struct _islog {     /* type == 0x0080 */
    int     logical;
} islog;

typedef struct _ischar {    /* type == 0x0100 */
    byte   *string;         /* pointer to string */
    int     size;           /* allocated size */
} ischar;

typedef struct _ismemo {    /* type == 0x0300 */
    int     uk1,
            uk2,
            uk3,
            uk4;
} ismemo;

typedef struct _isalias {   /* type == 0x0400 */
    int     uk1,
            uk2,
            uk3,
            uk4;
} isalias;

typedef struct _issym {     /* type == 0x1000 */
    int     uk1,
            uk2,
            uk3,
            uk4;
} issym;

typedef struct _isarray {   /* type == 0x2000 */
    int     uk1,
            uk2,
            uk3,
            uk4;
} isarray;

typedef union _types {
    isint   inttype;
    isreal  realtype;
    isdate  datetype;
    islog   logtype;
    ischar  chartype;
    ismemo  memotype;
    isalias aliastype;
    issym   symtype;
    isarray arraytype;
} types;

typedef struct _stacktype {
    int     type,
            length,
            decimals,
            unknown;
    types   data;
} stacktype;

extern stacktype *_tos;
extern stacktype  _xframe0;
extern stacktype  _xframe1;
extern stacktype  _xframe2;
extern stacktype  _xframe3;

#define NUMTYPE     0x0010         /* values for FIELD->type element */
#define DATETYPE    0x0040
#define LOGTYPE     0x0080
#define CHARTYPE    0x0100
#define MEMOTYPE    0x0300

typedef struct _symbol {
        char  unknown[10];
        char *name;
} SYMBOL;

typedef struct _field {
        int   type;
        int   len;
        int   dec;
        int   unknown1;
        int   offset;
        int   unknown2;
        int   unknown3;
        SYMBOL *symbol;
} FIELD;

/* database structure--uk? stands for an unknown item */
typedef struct _dbftype {
        char   signature;        /* 0x00 */        /* 03=dbf, 83=dbf+dbt */
        char   ymd[3];           /* 0x01-03 */     /* y+1900 m d */
        long   disklastrec;      /* 0x04-07 */
        int    data_off;         /* 0x08-09 */
        int    recsize;          /* 0x0a-0b */
        char  *uk1;              /* 0x0c-0f */ /* unknown */
        char  *uk2;              /* 0x10-13 */ /* unknown */
        char  *uk3;              /* 0x14-17 */ /* unknown */
        char  *uk4;              /* 0x18-1b */ /* unknown */
        char  *uk5;              /* 0x1c-1f */ /* unknown */
        long   reclen;           /* 0x20-23 */
        long   header;           /* 0x24-27 */
        long   recno;            /* 0x28-2b */
        long   lastrec;          /* 0x2c-2f */ /* unknown */
        char  *uk7;              /* 0x30-33 */
        int    dbf_handle;       /* 0x34-35 */
        int    has_dbt;          /* 0x36-37 */
        int    dbt_handle;       /* 0x38-39 */
        int    exclusive;        /* 0x3a-3b */
        int    area;             /* 0x3c-3d */
        SYMBOL *alias;           /* 0x3e-41 */
        int    not_eof;          /* 0x42-43 */
        int    uk8;              /* 0x44-45 */ /* unknown */
        int    deleted;          /* 0x46-47 */
        int    eof;              /* 0x48-49 */
        int    bof;              /* 0x4a-4b */
        int    found;            /* 0x4c-4d */
        int    flock;            /* 0x4e-4f */
        int    rlock;            /* 0x50-51 */
        int    uk9;              /* 0x52-53 */ /* unknown */
        int    lengthchanged;    /* 0x54-55 */
        int    updated;          /* 0x56-57 */
        int    appended;         /* 0x58-59 */
        char  *recptr;           /* 0x5a-5d */
        char  *uk11;             /* 0x5e-61 */ /* unknown */
        int    indexord;         /* 0x62-63 */
        int    indexcnt;         /* 0x64-65 */
        char  *indices[16];      /* 0x66-a5 */ /* Do not attempt to access */
        int    fcount;           /* 0xa6-a7 */ /* the indices.  The *char  */
        FIELD *dbffields;        /* 0xa8-ab */ /* only serve as a place    */
        char  *uk12;             /* 0xac-af */ /* holders as the actual    */
        int    hasfilter;        /* 0xb0-b1 */ /* is unknown (to me)       */
        char  *filter;           /* 0xb2-b5 */
        char  *uk13;             /* 0xb6-b9 */ /* unknown */
        int    numrelations;     /* 0xba-bb */
} dbftype;

extern dbftype **_dbf;    /* ptr to ptr to currently selected dbf */

CLIPPER PARMS()
{
    int     i, pi, info;
    long    pl;
    byte   *ps;
    double  pd;

    for (i = 1; i <= PCOUNT; i++) {
        info = _parinfo(i);
        switch (info) {
            case CHARACTER:
                ps = _parc(i);
                break;
            case NUMERIC:
                pi = _parni(i);
                break;
            case LOGICAL:
                pi = _parl(i);
                break;
            case DATE:
                ps = _pards(i);
                break;
        }
    }
    _retl( 0 );
    return;
}

CLIPPER DUMMY()
{
    /* these calls are necessary to get the compiler to include the typedefs */
    _tos->type = _tos->type;
    _xframe0.type = _xframe0.type;
    _xframe1.type = _xframe1.type;
    _xframe2.type = _xframe2.type;
    _xframe3.type = _xframe3.type;
    _dbf = _dbf;
    _retl( 0 );
}
