/*Ŀ
 ݳ Program Name: FLISTER.PRG       Copyright: Gallagher Computing Corp. 
 ݳ     Language: Clipper 5.2          Author: Kevin S Gallagher         
 Ĵ
 ݳ Comments:                                                            
 ݳ q_path    - path pointing to QBoot.dat                               
 Ĵ
 ݳ History:                                                             
 ݳ Added ability to check several paths for QBoot.dat files - KSG 5/93  
 
            */

#include "include1.h"
#define MANY_PATHS
static aQboot_:={}, aShow_:={}, q_path := "C:\"
static q_nHandle, a_nHandle, c_nHandle

function main
    local cBuf:="", cPassName:="", xx := 0
    @0,0 say Padr(" Reading from "+q_path+Q_FILE+"....",80) color HICOLOR
    UseQbootDat(.t.)
    while !ft_feof()
        cBuf := ft_freadln()
        if isdigit( cBuf )
            if subs( cBuf,1,1 ) != "2"
                aadd( aQboot_, { rtrim( subs(cBuf,2) ), NIL, "" } )
                ft_fskip(1)
                cBuf := ft_freadln()
                atail( aQboot_ )[3] := rtrim( cBuf )
                ft_fskip(-1)
            endif
        endif
        ft_fskip()
    enddo
    UseQbootDat(.f.)
    aeval( asort( aQboot_ , , , blocks_ )  ,{ | a | aadd( aShow_, a[1] ) } )

    if getargc() == 1
        cPassName := UPPER( getargv(1) )
        if ( xx:=ascan( aShow_,  cPassName ) ) <> 0
            @0,0 say padr(" Swaping files for cPassName",80) color ENCHCOLOR
            WriteBoot( xx )
            inkey(1)
            ft_reboot(1)
        else
            cls
            QOut("PseudoName " + cPassName + " not found in QBoot.dat")
            break
        endif
    endif

    MainScrn()
    setcolor(MENUCOLOR)
    #ifdef DO_CLOCK
    // running clock displayed on main menu
    // recommend ampm() used from ampm.prg and not from clipper.lib
    CM1(8,30,18,49,,,,,{ || devpos(0,69), devout( ampm(time() ),MENUCOLOR) })
    #else
    // default to no clock
    CM1(8,30,18,49)
    #endif
return nil

function CM1(nTr, nTc, nBr, nBc, aItems_, cColors, aLogic, nBoxType, bBlock)
    local nLen, nHolder, nKey, nSubs, nNewRec := 0, nRequest, nActually
    local cBoxType, cOldColor :="",  cSeek := []
    local oldcur:= setcursor(0)
    local oBrow, oCols
    local aEdit_:={}
    local xx    := 0
    local xxx
    cOldColor   := setcolor( if( ISCHAR( cColors ), cColors , MENUCOLOR  ) )
    nLen        := len(aShow_)
    bBlock      := IF( bBlock == NIL, { || .F. }, bBlock )

    if ValType(aLogic) != "A"
        aLogic  := Array(nLen)
        AFill( aLogic, .T. )
    endif

    dispbox( nTr-1, nTc-1, nBr, nBc+1, B_DOUBLE+" ", MENUCOLOR )
    ft_shadow(nTr-1, nTc-1, nBr, nBc+1 )
    oBrow:= TBrowseNew( nTr, nTc, nBr-1, nBc )
    oBrow:colorSpec := cColors
    nSubs:= 1
    oBrow:goTopBlock    := { || nSubs := 1 }
    oBrow:goBottomBlock := { || nSubs := nLen }
    oBrow:skipBlock := {| nRequest | nActually := if(abs(nRequest) >= ;
                           if(nRequest >= 0,;
                              nLen - nSubs, nSubs - 1),;
                                 if(nRequest >= 0, nLen - nSubs,;
                                    1 - nSubs),nRequest),;
                                       nSubs += nActually, ;
                                          nActually;
    }
    oCols:=TBColumnNew(, { || aShow_[nSubs]})
    oCols:colorBlock:=   { || if(aLogic[nSubs], { 1, 2 }, { 1, 3 } ) }
    oCols:width     := SHORTY
    oBrow:addColumn(oCols)

    while .t.
        oBrow:ForceStable()
        @maxrow(),0 say padc( SHOW_INFO ,80) color DISPCOLOR
        while ( ( nKey := WaitKeys( 0.1 ) ) == 0 )
            eval(bBlock)
        enddo
        @maxrow(),0 say padc( SHOW_INFO ,80) color DISPCOLOR
    
        do case
            // let the fingers do the walking...
            case nKey > 32 .and. nKey < 255
                if ( xxx := AScanner( aShow_, chr( nKey ) ) ) > 0
                    if nSubs > xxx
                        for xx := 1 to nSubs - xxx
                            oBrow:up()
                        next
                    elseif nSubs != xxx
                        nSubs:= xxx
                        oBrow:refreshall()
                        oBrow:ForceStable()
                    endif
                endif
            case nKey == K_DOWN .or. nKey == K_LEFT
                if nSubs == nLen
                    oBrow:gotop()
                else
                    oBrow:down()
                endif
            case nKey == K_UP .or. nKey == K_RIGHT
                if nSubs == 1
                    oBrow:gobottom()
                else
                    oBrow:up()
                endif
            case nKey == K_PGDN .or. nKey == K_END
                oBrow:pagedown()
            case nKey == K_PGUP .or. nKey == K_HOME
                oBrow:pageup()
            case nKey == K_CTRL_PGUP
                oBrow:gotop()
            case nKey == K_CTRL_PGDN
                oBrow:gobottom()
            case nKey == K_INS
                // add a new configuration
                aEdit_ := Editor( {"","","",""} )
                    nNewRec:=SaveEdits( aEdit_ )
                    aadd( aQboot_,{ subs(aEdit_[3],2), NIL ,aEdit_[4] } )
                    aadd( aShow_ ,subs(aEdit_[3],2) )
                    aadd( aLogic ,.t. )
                    asort( aShow_ )
                    asort( aQboot_, , ,blocks_ )
                    nLen := len( aShow_ )
                    oBrow:refreshall()
            case nKey == K_DEL
                //  purge highlighted configuration
                removeAlias( nSubs )
                AKill( aQboot_, nSubs )
                AKill( aShow_ , nSubs )
                AKill( aLogic , nSubs )
                nLen := len( aShow_ )
                // asize( aLogic, nLen )
                oBrow:gotop()
            case nKey == K_ENTER
                // edit highlighted configuration
                aEdit_ := GetAliasBuf(nSubs)
                aEdit_ := editor( aEdit_ )
                if !empty( aEdit_[1] )
                    removeAlias(nSubs)
                    nNewRec :=SaveEdits( aEdit_ )
                    aShow_[ nSubs ]    := subs( aEdit_[3], 2 )
                    aQboot_[ nSubs,1 ] := subs( aEdit_[3], 2 )
                    aQboot_[ nSubs,2 ] := NIL
                    aQboot_[ nSubs,3 ] := aEdit_[4]
                    asort( aShow_ )
                    asort( aQboot_, , ,blocks_ )
                    oBrow:refreshcurrent()
                    oBrow:gotop()
                endif
            case nKey == K_F10
                // Swap/boot with new setup if user says so!
                #ifdef MR_GRUMP
                if YES_NO("Confirm reboot")
                    WriteBoot( nSubs )
                    inkey(1)
                    ft_reboot(1)
                endif
                #else
                if alert("Confirm reboot", { " Yes ", " No " } ) == 1
                    WriteBoot( nSubs )
                    inkey(1)
                    ft_reboot()
                endif
                #endif
            case nKey == K_F3
                // environment editor
                EnvEditor()
            case nKey == K_ESC
                ExitToDos()
        endcase
    enddo
    setcolor( cOldColor )
    setcursor( oldcur )
return nSubs

/*
* Function..: UseQbootDat() --> Nil
* Purpose...: Open qboot.dat -or- to close qboot.dat
* Returns...: Nil
* Comment...: 
*/
function UseQbootDat(lMethod)
    lMethod := if(valtype(lMethod) == "L",lMethod,.F.)
    if lMethod
        q_nHandle := ft_fselect( 0 )
        ft_fuse( q_path + Q_FILE,FO_READWRITE )
    else
        ft_fuse()
    endif
return nil

/*
* Function..: removeAlias() --> Nil
* Purpose...: remove a single configuration from QBoot.dat
* Returns...: nil
* Comment...: revised method of getting to proper alias -KSG 5/03/93
*/
function removeAlias( nEle )
    local nHandle := 0, cBuf := ""
    if len( aShow_ ) == 1
        nHandle := fcreate( q_path+Q_FILE )
        if !fclose(nHandle)
            @0,0 say "File close error..." color ERRCOLOR
            break
        endif
        return nil 
    endif

    FindAlias( nEle )

    ft_fdelete()
    while .t.
        do case
            case ( ft_feof() )
                ft_fdelete(4)
                ft_fskip(1)
                ft_fdelete(1)
                exit
            case ( subs( ft_freadln(), 1, 1 ) ) == "1"
                // we hit another configuration
                exit
        endcase
        ft_fdelete()
    enddo
    UseQbootDat(.f.)
return nil

/*
* Function..: GetAliasBuf( nEle ) --> Nil
* Purpose...: retreive highlighted configuration
* Returns...: array[4]
* Comment...: revised method of getting to proper alias -KSG 5/03/93
*/
function GetAliasBuf( nEle )
    local cBuf_ := {"","","","",0}, cTempStr := ""
    FindAlias( nEle )
    cBuf_[ PSEUDO_NAME ] := ft_freadln()
    ft_fskip()
    cBuf_[ LONG_DESC ]   := ft_freadln()
    ft_fskip()
    cTempStr             := ft_freadln()
    cBuf_[1] += cTempStr + NEW_LINE
    ft_fskip()
    while .t.
        cTempStr := ft_freadln()
        if substr(cTempStr,1,1) == "2"
            ft_fskip()
            exit
        endif
        cBuf_[1] += cTempStr + NEW_LINE
        ft_fskip()
    enddo

    while .t.
        // loop until either EOF or next configuration
        do case
            case ( ft_feof() )
                exit
            case ( subs( ft_freadln(), 1, 1 ) ) == "1"
                exit
        endcase
        cBuf_[2] += ft_freadln() + NEW_LINE
        ft_fskip()
    enddo
    UseQbootDat(.f.)
return cBuf_

/*
* Function..: FindAlias( <array ele pointer> ) -->nil
* Purpose...: Locates highlighted alias for various routines
* Returns...: Nil
* Comment...: None
*/
function FindAlias( nEle )
    UseQbootDat(.t.)
    ft_fgotop()
    while .t.
        if rtrim( SUBS(ft_freadln(),2) ) == aQboot_[nEle][1]
            exit
        endif
        ft_fskip()
    enddo
return nil

/*
* Function..: SaveEdits( array[5] ) --> Nil
* Purpose...: Writes edited configuration to the EOF of bootfile
* Returns...: could add logic for filesize, then return logical value..
* Comment...: None
*/
function SaveEdits( aChanges_ )
    local nRec := 0
    UseQbootDat(.t.)
    ft_fgobot()
    nRec := ft_frecno()
    ft_fwriteln( aChanges_[ PSEUDO_NAME ] + NEW_LINE + ;
                 aChanges_[ LONG_DESC ]   + NEW_LINE + ;
                 aChanges_[ 1 ]           +            ;
                 "2"          + NEW_LINE  +            ;
                 aChanges_[ 2 ] ,  .f.    ;
    )
    UseQbootDat(.f.)
return nRec

/*
* Function..: WriteBoot( nLineNumber ) --> nil
* Purpose...: Write new autoexec.bat - config.sys
* Returns...: Nil
* Comment...: None
*/
function WriteBoot( nele )
    local cBuf:=""
    AutoRemake()
    UseQbootDat(.t.)
    FindAlias( nEle )
    a_nHandle := ft_fselect( 0 )
    ft_fuse( AUTOFILE,FO_READWRITE)
    while .t.
        ft_fselect( q_nHandle )
        cBuf := ft_freadln()
        if substr( cBuf,1,1) == "2"
            ft_fskip()
            exit
        endif
        ft_fselect( a_nHandle )
        ft_fappend()
        ft_fwriteln( cBuf,.t.)
        ft_fselect( q_nHandle )
        ft_fskip()
    enddo
    ft_fselect( a_nHandle )
    ft_fuse()
    ConfigRemake()
    c_nHandle := ft_fselect( 0 )
    ft_fuse( CONFFILE, FO_READWRITE )
    while .t.
        ft_fselect( q_nHandle )
        cBuf := ft_freadln()
        if subs( cBuf,1,1) == "1" .or. ft_feof()
            exit
        endif
        ft_fselect( c_nhandle )
        ft_fappend()
        ft_fwriteln( cBuf,.t.)
        ft_fselect( q_nHandle )
        ft_fskip()
    enddo
    ft_fselect( q_nHandle )
    ft_fuse()
    ft_fselect( c_nhandle )
    ft_fuse()
return nil

INIT procedure CheckFIle
    local cBuf1 :="", cBuf2:="", nHandle:=0
    #ifdef MANY_PATHS
    local cFullName:= getargv(0)
    #endif
    set(_SET_SCOREBOARD,.F.)
    #ifdef MANY_PATHS
    if file( subs( cFullName,1, rat("\",cFullName )) + Q_FILE )
        q_path := subs( cFullName,1, rat("\",cFullName ))
    elseif file(gete("QBOOT")+Q_FILE)
        q_path := gete("QBOOT")
    endif
    #endif
    if !file( q_path+Q_FILE )
        @0,0 say replicate(" ",80)
        @0,0 say q_path+Q_FILE+" not found, create it [Y/N] "
        if GetYN()
            if file("c:\autoexec.bat") .and. file("c:\autoexec.bat")
                cBuf1 := memoread("c:\autoexec.bat")
                cBuf2 := memoread("c:\config.sys")
                if ( nHandle := fcreate( Q_FILE ,0) ) = -1
                    ?"Error creating config data file"
                    BREAK
                endif
                // write generic headers
                fwrite( nHandle, "1CURRENT" + NEW_LINE )
                fwrite( nHandle, "PLACE A COMMENT HERE" + NEW_LINE )
                // write current autoexec/config files
                fwrite( nHandle, cBuf1 )
                fwrite( nHandle, "2" + NEW_LINE )
                fwrite( nHandle, cBuf2 )
                fclose( nHandle )
            endif
        else
            break
        endif
    endif
RETURN

/***************************************************************************
*
* Default CA-Clipper stuff.
* Warplink v2.6, utility SP.EXE will not run with the following code.
*
*/
ANNOUNCE rddsys

init procedure rddinit()
return


