/*
  Call any interrupt from CLIPPER 5.0x and return reg-values per @ref.
  (c) jsi 1991, germany, Jobst Hensiek

  **********************************************************************
  ** WARNING ***** WARNING ****** WARNING ******* WARNING *** WARNING **
  **********************************************************************
  *  Don't use this func() if your are not knowing what you are doing !* 
  **********************************************************************

  Syntax:
   ierr := INT_86X(<iINT>,<i@AX>,<i@BX>,<i@CX>,<i@DX>,<i@DS>,<i@ES>,<i@_flag>)

   ierr ==  0 -> OK !
        == -1 -> parameter error

  Example:
   #define MOUSE_INT   51  
   
   LOCAL AX = 1, BX = 0, CX = 0, DX = 0, ES = 0, DS = 0, _flag = 0
   INT_86X( MOUSE_INT, @AX, @BX, @CX, @DX, @DS, @ES, @_flag )

  Note:
    compile with MICROSOFT(tm) C 6.0a
*/

#include <extend.h>
#pragma   optimize("",off)

CLIPPER INT_86X( void ) {

   int   _AX = 0,
         _BX = 0,
         _CX = 0,
         _DX = 0,
         _DS = 0,
         _ES = 0,
       _flag = 0,
        _INT = 0,
     _ierror = 0,
        _len = 0;


    switch( ( _len = PCOUNT ) ) {

      case 8:
      case 7:
         _ES = _parni( 7 );

      case 6:
         _DS = _parni( 5 );
      
      case 5:
         _DX = _parni( 5 );

      case 4:
         _CX = _parni( 4 );

      case 3:
         _BX = _parni( 3 );
      
      case 2:
        _AX  = _parni( 2 );
        if ( (_INT = _parni( 1 )) > 255) {
          _ierror = -1;
          goto ERROR_EXIT;
        }
        break;

      default:
         _ierror = -1;
         goto ERROR_EXIT;
   }

   _asm {
      push  es
       push  ds
   
        ; get interrupt and poke into loc "POKE_ME + 1"
        MOV   AX, _INT                    
        MOV   BYTE PTR CS:[ POKE_ME + 1 ], AL

        ; stuff regs
        MOV   AX, _AX
        MOV   BX, _BX
        MOV   CX, _CX
        MOV   DX, _DX
        MOV   DS, _DS
        MOV   ES, _ES

   POKE_ME:
        INT   00h

        ;pop  regs
        MOV   _AX, AX
        MOV   _BX, BX
        MOV   _CX, CX
        MOV   _DX, DX
        MOV   _DS, DS
        MOV   _ES, ES

        ; get flag
        PUSHF
        POP   AX
        mov   _flag, AX

       pop    ds
      pop    es
  }

  // pop up the regs
  switch ( _len )  {

      case 8:
        _storni( _flag, 8 );

      case 7:
        _storni( _ES, 7 );

      case 6:
        _storni( _DS, 6 );

      case 5:
        _storni( _DX, 5 );

      case 4:
        _storni( _CX, 4 );

      case 3:
        _storni( _BX, 3 );

      case 2:
        _storni( _AX, 2 );
  }

 ERROR_EXIT:;
   _retni( _ierror );

}


