/*
    stack.prg

    Copyright (c) 1991 Anton van Straaten

    06/02/1991 04:18 avs - creation

    A simple implementation of a stack class.
*/

#include "class(y).ch"


create class Stack
    instvar items

export:
    method push
    method pop
endclass

/*
    A new stack object can be created from a single value,
    an array of values, or another stack object.
*/

constructor (aItems)
    local itemType := valtype(aItems)

    if aItems == NIL
        ::items := {}                       // empty stack
    elseif itemType == 'A'
        ::items := aItems
    elseif itemType == 'O' .and. aItems:className == 'STACK'
        ::items := array(len(aItems:items))
        acopy(aItems:items, ::items)
    else
        ::items := { aItems }
    end
return

function method push(item)
    aadd(::items, item)
return item

function method pop
    local retval
    local nLen := len(::items)
    if nLen > 0
        retval := ::items[nLen]
        asize(::items, nLen - 1)
    end
return retval


// eof stack.prg
