/*
    Menu.prg

    Copyright (c) 1991 Chris Muller
*/


#include "class(y).ch"
#include "win.ch"
#include "gen.ch"

create class menu from baseMenu

    protected:
        instvar window
        instvar width

    export:
        method draw
        method drawMnuWin
        method addItem
        method exec

endclass

constructor (Items), (Items)
return


procedure method draw(parentPos)
    local i

    if ::window == NIL
        ::drawMnuWin(parentPos)
    end

    for i := 1 to len(::Items)
        @ i-1, 0 prompt ::items[i]:text
    next i

return

procedure method drawMnuWin()
    local top    := winTop()  + ::parent:newMenuPos()
    local left   := winLeft() + 2
    local bottom := top  + len(::items) + 1
    local right  := left + ::width      + 1

    ::window := window():new(top, left, bottom, right, SNGLBORD)
return

procedure method additem(text, oAction)
    ::super:addItem(text, oAction)
    ::width := max(if(::width == NIL, 0, ::width), len(text))
return


procedure method exec
    ::super:exec()          // ::baseMenu:exec()
    ::window:kill()
    ::window := NIL
return
