/*
    heritest.prg

    21/03/1991 21:18 avs - updated

    This program demonstrates many of the inheritance and scoping
    features of Class(y).  The program displays a menu of options;
    all of which will generate an error when selected.  In each
    case, an illegal operation has deliberately been performed.

    The program uses a box class, defined in HTBOX.PRG, which is
    inherited from the rectangle class defined in this module.
    The rectangle class is very limited, and is not the same one
    used in the manual.
*/

#include "class(y).ch"

memvar getlist

procedure main
    local opt, test
    local oBox

    clear
    oBox := Box():new(5, 5, 12, 22, "ͻȺ ", "R+/W", "RB+/BG")
    @ 15, 0

    // test the 'super' message, as well as sending a specific
    // class name to specify where to begin a message search.
    oBox:test()
    oBox:super:test()
    oBox:test()
    oBox:rectangle:test()
    oBox:test()

    // test class variables
    oBox:nRects := 42
    oBox:nBoxes := 23
    ? oBox:nRects, oBox:nBoxes
    ? box():nRects, box():nBoxes
    ? rectangle():nRects

    @  6, 6 prompt 'Private access'
    @  7, 6 prompt 'Protected access'
    @  8, 6 prompt 'Bad assignment'
    @  9, 6 prompt 'Msg -> non-obj'
    @ 10, 6 prompt 'Bad message'
    @ 11, 6 prompt 'Access via class'
    menu to opt
    do case
        case opt == 1
            ? oBox:boxChars
        case opt == 2
            ? oBox:boxType
        case opt == 3
            oBox:top := 42
        case opt == 4
            ? opt:boxChars
        case opt == 5
            ? oBox:volume
        case opt == 6
            ? box():top
    endcase
return


create class Rectangle

export:
    classvar nRects

    instvar top, left, bottom, right noassign
    instvar width, height noassign

    method set
    method test

endclass


constructor (nTop, nLeft, nBottom, nRight)
    ::set(nTop, nLeft, nBottom, nRight)
return


procedure method set(nTop, nLeft, nBottom, nRight)
    ::top     := nTop
    ::left     := nLeft
    ::bottom := nBottom
    ::right  := nRight

    ::width  := nBottom - nTop
    ::height := nRight - nLeft
return


procedure method test
    ? 'rectangle:test'
return


// eof heritest.prg
