#include "classx.ch"
set wrap on
set scoreboard off

public doscolor := setcolor()

/*  This is a simple contact tracking system.  It is 'networked' only in
    that the entire file is locked, so only one user can access it at a
    time.

    compile:
    clipper contacts /l

    link (using BLINKER 3.0):
    BLINKER FI CONTACTS LIB CLASSX BLINKER INCREMENTAL OFF

    Notes:
        1.  This prg accesses BLINKER's SwpSetEnv() and SwpRunCMD()
            functions to shell to DOS
        2.  The functions and objects used by CLASSX cannot be traced
            with Clipper's debugger.
*/

// Access the re-defined USE command in the header file...
use contacts exclusive

/* Note that when using this USE command, the instance name is either
   the DBF file name or, if one is given, the alias.  The one line above
   substitutes for these three...
      contacts := UseClass("CONTACTS")
      contacts:Share := .F.
      contacts:Use()
*/

// Check that data file can be opened in network environment...
timenow := seconds()
LockAlert := AlertClass()
while !contacts:flock()
     if seconds() - timenow >= 5
          LockAlert:Message := "  Cannot Lock File  ;  Database May Be In Use  "
          LockAlert:Options := {"Try Again","Try Later"}
          LockAlert:Color := "W+/R"
          if LockAlert:Display() == 1
               timenow := seconds()
               use contacts exclusive  // Try Again
          else
               close all
               cls
               return
          endif
     endif
enddo
contacts:addindex := {"Country", "Organizatn", "Firstnam", "Lastname"}

// Establish the menus...
MainMenu := MenuClass()
SMenu := MenuClass()
FMenu := MenuClass()
MenuShade := ShadowClass()
MenuShade:Color := "r/b"
MainMenu:Color := "bg+/b,b/w,,,w/b"

SMenu:Options := {"Country           ",;
                  "Organization Name ",;
                  "First Name        ",;
                  "Last Name         "}
FMenu:Options := {"Save     ",;
                  "Print    ",;
                  "DOS Shell",;
                  "Unselect "}  // Just to demonstrate the use of FMenu:select
FMenu:select := {.T.,.T.,.T.,.F.}
MainMenu:Ucolor := "w/b"             // Will be inherited by FMenu
MainMenu:options := {"File","Search by:","Edit","Add New","Previous","Next","Quit"}

SMenu:HelpMsg :=    {"                Search in Country Name Order                           ",;
                     "             Search in Organization Name Order                         ",;
                     "                    Search by First Name                               ",;
                     "                     Search by Last Name                               "}
FMenu:HelpMsg :=    {"       Save This Record in a File (Use Entire Path Name)               ",;
                     "                       Print This Record                               ",;
                     "                    Exit Temporarily to DOS                            "}
MainMenu:HelpMsg := {"       Save a Record in a File, Print a Record, Shell to DOS           ",;
                     "     Search Records by Country, Organization, First, Last Names        ",;
                     "               Edit The Record That is Displayed                       ",;
                     "              Add a New Record to the Database                         ",;
                     "                   Skip to Previous Record                             ",;
                     "                      Skip to Next Record                              ",;
                     "                           Exit Program                                "}

MainMenu:Type := X_HORIZONTAL
MainMenu:Row := 1

SMenu:Type := X_SUBMENU
FMenu:Type := X_SUBMENU
SMenu:Actions := {{||Setter1()},{||Setter2()},{||Setter3()},{||Setter4()}}
FMenu:Actions := {{||Saver()},{||PrintX()},{||DOSShell()}}
MainMenu:Shadow := MenuShade

MainMenu:Actions := {FMenu,SMenu,{||Getter()},{||Adder()},{||Prever()},;
                    {||Nexter()},{||Quiter()}}

// The next section displays data in the first record, and displays the menus.
// This section controls program flow.

while .T.
     setcolor("bg+/b,b/w,,,w/b")
     cls
     displayer()
     MainMenu:Display()
enddo

// Functions for editing and menus...
****************************
Function Getter()

   cls
   displayer()
   @ 24,22 say "F3: Save, Exit    Esc: Exit, No Save"
   if contacts:lastrec == 0
             LockAlert:Message := "Database Is Empty;Add New Record First"
             LockAlert:Display()
             return NIL
   endif
   set key -2 to outer()

   @  7, 20  GET  HONOR valid get_hon()
   @  7, 27  GET  FULLNAME
   @  8, 20  GET  ORGANIZATN
   @  9, 20  GET  TITLE
   @ 10, 20  GET  ADDRESS1
   @ 11, 20  GET  ADDRESS2
   @ 12, 20  GET  ADDRESS3
   @ 13, 20  GET  ADDRESS4
   @ 14, 20  GET  COUNTRY
   @ 15, 20  GET  TELEPHONE1
   @ 15, 47  GET  TELEPHONE3
   @ 16, 20  GET  TELEPHONE2
   @ 16, 47  GET  TELEPHONE4
   @ 18, 20  GET  FACSIMILE1
   @ 18, 47  GET  FACSIMILE2
   @ 19, 20  GET  EMAIL
   @ 20, 20  GET  TELEX
   @ 22, 20  GET  LASTCDATE
   @ 22, 47  GET  LASTCNAME
   read

   fulln := alltrim(fullname)
   // Delete Jr or III from end of FULLNAME for parsing...
   do case
        case len(alltrim(fullname)) == 0  // Delete if no name given...
             contacts:delete()
             contacts:pack()
             return NIL
        case at("JR",upper(fulln)) > 0
             fulln := substr(fulln,1,at("JR",upper(fulln))-2)
        case at("III",upper(fulln)) > 0
             fulln := substr(fulln,1,at("III",upper(fulln))-2)
   endcase
   if at(",",fulln) > 0
        fulln := substr(fulln,1,at(",",fulln)-1)
   endif
   firstblk := at(" ",fulln)
   lastblk := rat(" ",fulln)

   // Parse FULLNAME into first and last name fields...
   do case
        case firstblk == 0
             // Set both first and last names to fullname...
             contacts:firstname := fulln
             contacts:lastname := fulln
        case firstblk > 0   // at lease two names
             contacts:firstname := substr(fulln,1,firstblk-1)
             contacts:lastname := substr(fulln,lastblk+1)
   endcase
return NIL

****************************
Function Outer()

keyboard chr(23)
return NIL

****************************
Function Adder()

contacts:append()
getter()
if len(alltrim(fullname)) == 0
     contacts:delete()
     contacts:pack()
endif

****************************
Function Prever()

if !contacts:bof()
     contacts:skip := -1
endif

****************************
Function Nexter()

contacts:skip := 1
if contacts:eof()
     contacts:skip := -1
endif

****************************
Function Quiter()

setcolor(doscolor)
cls
close all
quit

****************************
Function Setter1()

local tb := {4,2,1,18}
contacts:order := 1
//  Country+lastname
MakeBrow(tb)
return NIL

****************************
Function Setter2()

local tb := {18,2,1,4}
contacts:order := 2
// organizatn+lastname
MakeBrow(tb)
return NIL

****************************
Function Setter3()

local tb := {1,2,4,18}
contacts:order := 3
// firstnam+lastname
MakeBrow(tb)
return NIL

****************************
Function Setter4()

local tb := {2,1,18,4}
contacts:order := 4
// lastname
MakeBrow(tb)
return NIL

****************************
function displayer()

local oldcolor := setcolor("w+/b")
@  5, 27  SAY "Contacts Database"
setcolor("bg+/b")
@  7,  7  SAY "Name        :"
@  7, 20  SAY  HONOR
@  7, 27  SAY  FULLNAME
@  8,  7  SAY "Organization:"
@  8, 20  SAY  ORGANIZATN
@  9,  7  SAY "Title       :"
@  9, 20  SAY  TITLE
@ 10,  7  SAY "Address     :"
@ 10, 20  SAY  ADDRESS1
@ 11, 19  SAY ":"
@ 11, 20  SAY  ADDRESS2
@ 12, 19  SAY ":"
@ 12, 20  SAY  ADDRESS3
@ 13, 19  SAY ":"
@ 13, 20  SAY  ADDRESS4
@ 14,  7  SAY "Country     :"
@ 14, 20  SAY  COUNTRY
@ 15,  7  SAY "Telephones  :"
@ 15, 20  SAY  TELEPHONE1
@ 15, 47  SAY  TELEPHONE3
@ 16, 20  SAY  TELEPHONE2
@ 16, 47  SAY  TELEPHONE4
@ 18,  7  SAY "Facsimiles  :"
@ 18, 20  SAY  FACSIMILE1
@ 18, 47  SAY  FACSIMILE2
@ 19,  7  SAY "E-Mail      :"
@ 19, 20  SAY EMAIL
@ 20,  7  SAY "Telex       :"
@ 20, 20  SAY  TELEX
@ 22,  7  SAY "Last Contact:"
@ 22, 20  SAY  LASTCDATE
@ 22, 43  SAY "by:"
@ 22, 47  SAY  LASTCNAME
@  3,  4  TO 23, 75    DOUBLE
@  6,  5  TO  6, 74
@ 17,  5  TO 17, 74
// @ 19,  5  TO 19, 74
@ 21,  5  TO 21, 74
setcolor("bg+/b")
setcolor(oldcolor)
return NIL

********************************
Function Saver()

local oldcolor := setcolor("w+/b"), f_name := space(50),;
                  oldscreen := savescreen(5,5,9,61)
MenuShade:Box := {5,5,8,60}

@ 5,5 clear to 8,60
MenuShade:Display()
@ 6, 7 say "Enter File Name to Save (Will Overwrite Existing)"
@ 7, 7 get f_name
read
if lastkey() <> 27 .and. len(alltrim(f_name)) > 0
   set printer to (f_name)
   set device to printer
   displayer()
   set printer to
   set device to screen
endif
setcolor(oldcolor)
restscreen(5,5,9,61,oldscreen)
return NIL

********************************
Function PrintX()

set device to printer
displayer()
eject
set device to screen
return NIL

********************************
Function DOSSHell()

SwpSetEnv("PROMPT=TYPE EXIT TO RETURN TO CONTACTS$_$p$g")
SwpRunCMD("",0,"","")
cls
displayer()
return NIL

*********************************
Function MakeBrow(aOrder)

Local ChoiceArray := {}, oldscreen := savescreen(4,14,23,67),;
                         oldcolor := setcolor("w+/bg"), rcount := 0, i,;
                         aselectbl := {}, recs := {}, oldrec := recno()

go top
while !eof()
     aadd(ChoiceArray,left(FieldGet(aOrder[1]),25)+" "+left(FieldGet(aOrder[2]),25))
     aadd(aselectbl,.T.)
     aadd(recs,recno())
     skip
     rcount++
enddo

BrowShade := ShadowClass()
BrowShade:Box := {4, 14, 22, 66}
BrowShade:Chars := X_BOX_2
BrowShade:Display()

if rcount < 17          // fill extra rows with chr(179)'s
     for i = rcount+1 to 17
          aadd( ChoiceArray, space(25)+" "+space(25) )
          aadd( aselectbl, .F. )
     next
endif

@ 4, 40 say chr(209)
@ 22, 40 say chr(207)
Selected := AChoice( 5, 15, 21, 65, ChoiceArray, aselectbl )

restscreen( 4, 14, 23, 67, oldscreen )
setcolor( oldcolor )

if Selected == 0
   go oldrec
else
   go recs[Selected]
endif
cls
displayer()

return NIL

********************************
function get_hon

* Assures that the 'title' is Mr, Mrs, Ms, Miss, or Dr, Hon, Rev, Sir,

if !(alltrim(upper(honor)) $ "MR MRS MS MISS DR REV HON SIR SR SRA SNR MR. MRS. MS. MISS. DR.") .and. !empty(honor)
     hon_alert := AlertClass()
     hon_alert:Message := "Should Be;Mr, Mrs, Ms, Miss, Dr,;or Left Blank"
     hon_alert:Options := {"Revise","Continue"}
     hon_alert:Shadow := MenuShade
     hon_alert:Color := "W+/R"
     res := hon_alert:Display()
     if res == 1
          return .F.
     else
          return .T.
     endif
endif

return .T.

