// CLASSic V1.6b
// Here it is! A Class Creation Utility
// Written by John D. Van Etten
// Copyright 1994 - VanSoft

request oSymbol

#include "Error.ch"
#include "addon.ch"
#include "set.ch"

Memvar _oInherit

#DEFINE pCRC 2222375
#DEFINE pMESSAGES  89

#DEFINE pSELFINFO       1

// __oJVObject array
#DEFINE pDONE           1
#DEFINE pHANDLE         2
#DEFINE pEMPTY          3
#DEFINE pINFO           4
#DEFINE pSAVENEW        5
#DEFINE pPARENT         6
#DEFINE pREMAKE         7
#DEFINE pINHERIT_NAMES  8
#DEFINE pVARTYPE        9
#DEFINE pSTATIC_VARS    10
#DEFINE pCLASS_NAME     11
#DEFINE pDATA           12  // Save Data Area

#DEFINE pEXCLUDE         1
#DEFINE pRENAME          2
#DEFINE pMSG_LIST        3
#DEFINE pJVCLASS         4
#DEFINE pPARENT_CLASS    5
#DEFINE pRECREATE        6
#DEFINE pMETHODVAR_POS   7
#DEFINE pCHILD_CLASS     8
#DEFINE pSUBCLASSPOS     9
#DEFINE pSUPERPOS       10

#DEFINE pEXCLUDE_MSG         1
#DEFINE pEXCLUDE_TYPE        2

// Self Types
#DEFINE pMETHOD_BLOCK        1
#DEFINE pMETHOD_VALTYPE      2

#DEFINE pMETHOD_VAR_DATA     1
#DEFINE pMETHOD_VAR_TYPE     2
#DEFINE pMETHOD_VAR_GETBLOCK 3
#DEFINE pMETHOD_VAR_SETBLOCK 4
#DEFINE pMETHOD_VAR_VALTYPE  5

#DEFINE pVAR_DATA            1
#DEFINE pVAR_TYPE            2
#DEFINE pVAR_VALTYPE         3

#DEFINE pSTATIC_VARS_POS     1
#DEFINE pSTATIC_VARS_DATA    2

#DEFINE pRENAME_OLD          1
#DEFINE pRENAME_NEW          2


// I don't want to type this where I need it
// CLASSic methods only supports 70 parameters :(
#DEFINE pParm     _a1,_b1,_c1,_d1,_e1,_f1,_g1,_h1,_i1,_j1,_k1,_l1,_m1,_n1,_o1,_p1,_q1,_r1,_s1,_t1,_u1,_v1,_w1,_x1,_y1,_z1,_a2,_b2,_c2,_d2,_e2,_f2,_g2,_h2,_i2,_j2,_k2,_l2,_m2,_n2,_o2,_p2,_q2,_r2,_s2,_t2,_u2,_v2,_w2,_x2,_y2,_z2,_a3,_b3,_c3,_d3,_e3,_f3,_g3,_h3,_i3,_j3,_k3,_l3,_m3,_n3,_o3,_p3,_q3,_r3,_s3,_t3,_u3,_v3,_w3,_x3,_y3,_z3
#DEFINE pcParm   " _a1,_b1,_c1,_d1,_e1,_f1,_g1,_h1,_i1,_j1,_k1,_l1,_m1,_n1,_o1,_p1,_q1,_r1,_s1,_t1,_u1,_v1,_w1,_x1,_y1,_z1,_a2,_b2,_c2,_d2,_e2,_f2,_g2,_h2,_i2,_j2,_k2,_l2,_m2,_n2,_o2,_p2,_q2,_r2,_s2,_t2,_u2,_v2,_w2,_x2,_y2,_z2,_a3,_b3,_c3,_d3,_e3,_f3,_g3,_h3,_i3,_j3,_k3,_l3,_m3,_n3,_o3,_p3,_q3,_r3,_s3,_t3,_u3,_v3,_w3,_x3,_y3,_z3"
#DEFINE pParmp    @_a1,@_b1,@_c1,@_d1,@_e1,@_f1,@_g1,@_h1,@_i1,@_j1,@_k1,@_l1,@_m1,@_n1,@_o1,@_p1,@_q1,@_r1,@_s1,@_t1,@_u1,@_v1,@_w1,@_x1,@_y1,@_z1,@_a2,@_b2,@_c2,@_d2,@_e2,@_f2,@_g2,@_h2,@_i2,@_j2,@_k2,@_l2,@_m2,@_n2,@_o2,@_p2,@_q2,@_r2,@_s2,@_t2,@_u2,@_v2,@_w2,@_x2,@_y2,@_z2,@_a3,@_b3,@_c3,@_d3,@_e3,@_f3,@_g3,@_h3,@_i3,@_j3,@_k3,@_l3,@_m3,@_n3,@_o3,@_p3,@_q3,@_r3,@_s3,@_t3,@_u3,@_v3,@_w3,@_x3,@_y3,@_z3
#DEFINE pParmp16  @_a1,@_b1,@_c1,@_d1,@_e1,@_f1,@_g1,@_h1,@_i1,@_j1,@_k1,@_l1,@_m1,@_n1,@_o1,@_p1
#DEFINE pcParmp " @_a1,@_b1,@_c1,@_d1,@_e1,@_f1,@_g1,@_h1,@_i1,@_j1,@_k1,@_l1,@_m1,@_n1,@_o1,@_p1,@_q1,@_r1,@_s1,@_t1,@_u1,@_v1,@_w1,@_x1,@_y1,@_z1,@_a2,@_b2,@_c2,@_d2,@_e2,@_f2,@_g2,@_h2,@_i2,@_j2,@_k2,@_l2,@_m2,@_n2,@_o2,@_p2,@_q2,@_r2,@_s2,@_t2,@_u2,@_v2,@_w2,@_x2,@_y2,@_z2,@_a3,@_b3,@_c3,@_d3,@_e3,@_f3,@_g3,@_h3,@_i3,@_j3,@_k3,@_l3,@_m3,@_n3,@_o3,@_p3,@_q3,@_r3,@_s3,@_t3,@_u3,@_v3,@_w3,@_x3,@_y3,@_z3"

#DEFINE aKill( aArray, nPlace )    aSize( aDel( aArray, nPlace ), Len( aArray) - 1 )

// No Need to recreate these in a function every time!
Static nPlace
Static oError
Static xRet
Static xRecover
Static lBreak := .f.

Function _oJVClass( cFunc, aHandle, aInherit )
  Static Object := pCRC // Comment out ':= pCRC' to add registration screen
  Local nCount
  Local lNew := .f.
  Local lReMake := .f.
  Local oInherit
  Local cMessage

  if Object == NIL // Call Registration Screen
    _oJVMake( @Object )
  endif

  If cFunc == NIL
    cFunc := aHandle[ pCLASS_NAME ]
    aHandle := NIL
  Endif

  cFunc := Upper( alltrim( cFunc ))

  If "(" $ cFunc
    cFunc := Left( cFunc, at( "(", cFunc ) - 1 )
  Endif

  if aHandle == NIL
    lNew := .t.
    aHandle := {}
  endif

  For nCount := 1 to Len( aInherit )
    oInherit := aInherit[ nCount ][ 1 ]
    If IsClassic( oInherit )
      if oInherit[ pSELFINFO ][ pRECREATE ] .or. ; // Recreated Object!
          !"(" $ aInherit[ nCount ][ 2 ] // Passed Inherited Object!
        lReMake := .t.
        exit
      endif
    Endif
  Next

  if empty( aHandle ) // New Class
    If object == pCRC
      aadd( aHandle, .f. )
      aadd( aHandle, __ClassNew( cFunc, 2 ) )
      aadd( aHandle, 1 )
      // The len of this array must be entered above!!!!!!!!!!!!!!!!!!
      aadd( aHandle, { {{},{}}, {}, {{},{}}, "J.V. Object", NIL, .t., 0, NIL, 0, 0 })
      aadd( aHandle, { NIL } )
      aadd( aHandle, __ClassNew( cFunc, 2 ) )
      aadd( aHandle, .t. )
      aadd( aHandle, {} )
      aadd( aHandle, NIL )
      aadd( aHandle, {} )
      aadd( aHandle, cFunc )
      aadd( aHandle, {} )

      For nCount := 1 to Len( aInherit ) // Build Rename Array
        cMessage := Upper( Alltrim( aInherit[ nCount ][ 2 ] ))
        aadd( aHandle[ pINFO ][ pRENAME ], {{},{}} )
        aadd( aHandle[ pINHERIT_NAMES ], cMessage )
      Next
    endif
  elseif lReMake //Regenerate because inherited class changed!
    aHandle[ pDONE ]     := .f.
    aHandle[ pHANDLE ]   := __ClassNew( cFunc, 2 )
    aHandle[ pINFO ]     :=  { {{},{}}, aHandle[ 4 ][ 2 ], {{},{}},;
                               "J.V. Object", NIL, .t., 0, NIL, 0, 0 }
    aHandle[ pSAVENEW ]  := { NIL }
    aHandle[ pPARENT ]   := __ClassNew( cFunc, 2 )
    aHandle[ pREMAKE ]   := .f.
    aHandle[ pVARTYPE ]  := NIL
    aHandle[ pDATA ]     := {}
  else // Same Class
    aHandle[ pDONE ] := .t.
    aHandle[ pINFO ] :=  { aHandle[ 4 ][ 1 ], aHandle[ 4 ][ 2 ], ;
                           aHandle[ 4 ][ 3 ], "J.V. Object", ;
                           aHandle[ 4 ][ 5 ], lNew, 0, ;
                           aHandle[ 4 ][ 8 ], aHandle[ 4 ][ 9 ], ;
                           aHandle[ 4 ][ 10 ] }
    aHandle[ pREMAKE ]  := .f.
    aHandle[ pVARTYPE ] := NIL
  Endif
Return ( aHandle )

Function _oJVAddVar( aHandle, aVar, bSetFunc, bFunc, lClass, lReadonly, cValType, xValue )
  Local cType    := aHandle[ pVARTYPE ]
  Local cVar
  Local nCount

  if !aHandle[ pDONE ]
    if cValType != NIL
      cValType := Upper( left( cValType, 1 ))
    endif

    Default lReadOnly to .f.
    Default lClass to .f.

    If lReadOnly
      Default cType to "R"
    Endif

    if bSetFunc == NIL
      For nCount := 1 to len( aVar )
        cVar := aVar[ nCount ]
        if cType == NIL .or. cType == "R"
          AddMessage( aHandle, cVar, len( aHandle[ pDATA ] ) + 1 )
          AddMessage( aHandle, "_" + cVar, len( aHandle[ pDATA ] ) + 1 )
        Else
          AddExclude( aHandle, cVar, cType )
          AddExclude( aHandle, "_" + cVar, cType )
          AddMessage( aHandle, cVar, len( aHandle[ pDATA ] ) + 1, .f. )
          AddMessage( aHandle, "_" + cVar, len( aHandle[ pDATA ] ) + 1, .f. )
        endif

        aadd( aHandle[ pDATA ], { xValue, cType, cValtype })
        if lClass .and. aHandle[ pREMAKE ]
          aadd( aHandle[ pSTATIC_VARS ], { len( aHandle[ pDATA ]), { xValue }})
        endif
      Next
    else
      For nCount := 1 to len( aVar )
        cVar := aVar[ nCount ]
        if cType == NIL .or. cType == "R"
          AddMessage( aHandle, cVar, len( aHandle[ pDATA ] ) + 1 )
          AddMessage( aHandle, "_" + cVar, len( aHandle[ pDATA ] ) + 1 )
        Else
          AddExclude( aHandle, cVar, cType )
          AddExclude( aHandle, "_" + cVar, cType )
          AddMessage( aHandle, cVar, len( aHandle[ pDATA ] ) + 1, .t. )
          AddMessage( aHandle, "_" + cVar, len( aHandle[ pDATA ] ) + 1, .t. )
        endif
        aadd( aHandle[ pDATA ], { ,cType, bFunc, bSetFunc, cValType })
      Next
    endif
  endif
Return( Len( aHandle[ pDATA ] ) + 1 )

Function _oJVAddMethod( aHandle, cFunc, bFunc, lConstruct, lGetParms, cValtype )
  Local cType   := aHandle[ pVARTYPE ]

  if !aHandle[ pDONE ]
    if cValType != NIL
      if upper( cValType ) == "NIL"
        cValtype := "U"
      else
        cValType := Upper( left( cValType, 1 ))
      endif
    endif

    if !aHandle[ pSAVENEW ][ 1 ] == "NEW"
      if upper( alltrim( cFunc )) == "NEW" .and. cType == NIL
        aHandle[ pSAVENEW ] := { "NEW", len( aHandle[ pDATA ] ) + 1 }
      elseif ( upper( alltrim( cFunc )) == "INIT" .and. ;
           aHandle[ pSAVENEW ][ 1 ] == NIL .and. cType == NIL ) .or. lConstruct
        aHandle[ pSAVENEW ] := { cFunc, len( aHandle[ pDATA ] ) + 1 }
        cType := NIL
      endif
    endif

    if cType == NIL
      AddMessage( aHandle, cFunc, len( aHandle[ pDATA ] ) + 1 )
    Else
      AddExclude( aHandle, cFunc, cType )
      AddMessage( aHandle, cFunc, len( aHandle[ pDATA ] ) + 1, .f. )
    endif

    If lGetParms
      // Get Parm List
      lBreak := .t.
      Begin Sequence
        Eval( bFunc )
      Recover Using bFunc
        // Done
      End Sequence
      lBreak := .f.
    Endif

    aadd( aHandle[ pDATA ], { bFunc, cValType } )
  endif
Return (NIL)

Function _oJVParent( err )
  Local Self := qSelf()

  if pcount() == 1
    _oJVError()
  endif
Return( Self[ pSELFINFO ][ pPARENT_CLASS ] )

Function _oJVAddClass( aHandle, aInherit )
  Local Self
  Local Class
  Local nVars
  Local aVars      := aHandle[ pINFO ]
  Local nPlace2    := 1
  Local aExclude   := { {} }
  Local lExact     := Set( _SET_EXACT, .t. )
  Local cPass
  Local oInherit
  Local nInherit
  Local nCount
  Local aMsg
  Local aUsed
  Local cMessage
  Local lSelect := .f.
  Local nSuper

  if !aHandle[ pDONE ]
    __ClassAdd( aHandle[ pHANDLE ], "PARENT", "_oJVParent")
    __ClassAdd( aHandle[ pHANDLE ], "_PARENT", "_oJVParent")

    aHandle[ pVARTYPE ] := NIL // Make New Stuff Global

    //Add Symbol Class support
    _oJVAddMethod( aHandle, "Symbol", {|s,x| oSymbol(s, x) }, .f., .f. )

    If aHandle[ pSAVENEW ][ 1 ] != NIL
      if aHandle[ pSAVENEW ][1] != "NEW"
        AddMessage( aHandle, "NEW", aHandle[ pSAVENEW ][ 2 ] )
      endif
    else
      _oJVAddMethod( aHandle, "NEW", {|s| s }, .f., .f. )
    Endif

    // Get Message List
    aUsed := __Classsel( aHandle[ pPARENT ])
    For nInherit := len( aInherit ) to 1 Step -1
      cPass := "_oJVPass" + ltrim( str( nInherit, 2, 0 ))
      oInherit := aInherit[ nInherit ][ 1 ]

      // Inherited Message List
      // Note:  ClassH is automaticaly created by Clipper
      aMsg := __Classsel( oInherit:ClassH )
      aExclude   := { {} }

      If IsClassic( oInherit ) // Is is a CLASSic Class?
        aMsg     := __Classsel( oInherit[ pSELFINFO ][ pPARENT_CLASS ]:ClassH )
        aExclude := oInherit[ pSELFINFO ][ pEXCLUDE ]
      Endif

      // INHERIT!!!!
      if Len( aInherit[ nInherit ] ) == 3  // Selective Inheriting
        For nCount := 1 to len( aHandle[ pINFO ][ pRENAME ][ nInherit ][ pRENAME_NEW ] )
          cMessage := aHandle[ pINFO ][ pRENAME ][ nInherit ][ pRENAME_NEW ][ nCount ]
          if 0 == aScan( aUsed, cMessage )
            nPlace := aScan( aExclude[ 1 ], cMessage )
            If nPlace == 0 // Global Var
              __ClassAdd( aHandle[ pPARENT ], cMessage, cPass )
              __ClassAdd( aHandle[ pHANDLE ], cMessage, cPass )
            Elseif aExclude[ 2 ][ nPlace ] == "P" // Class Var
              __ClassAdd( aHandle[ pPARENT ], cMessage, cPass )
            Endif
          Endif
        Next
      else // Full Inherit
        For nCount := 1 to len( aMsg )
          cMessage := Rename( aMsg[ nCount ], aHandle[ pINFO ][ pRENAME ], nInherit )
          if 0 == aScan( aUsed, cMessage )
            nPlace := aScan( aExclude[ 1 ], cMessage )
            If nPlace == 0 // Global Var
              __ClassAdd( aHandle[ pPARENT ], cMessage, cPass )
              __ClassAdd( aHandle[ pHANDLE ], cMessage, cPass )
            Elseif aExclude[ 2 ][ nPlace ] == "P" // Class Var
              __ClassAdd( aHandle[ pPARENT ], cMessage, cPass )
            Endif
          Endif
        Next
      endif

      if nInherit == 1 // add the super only once!
        aHandle[ pINFO ][ pSUPERPOS ] := _oJVAddVar( aHandle, {"SUPER"},,,, .t. )
      endif
    Next

    aHandle[ pINFO ][ pSUBCLASSPOS ] := _oJVAddVar( aHandle, {"SUBCLASS"},,,, .t. ) // Child Object
  endif

  nVars := Len( aHandle[ pDATA ] )

  // Create Class
  Self  := __ClassIns( aHandle[ pHANDLE ] )
  Self  := aSize( Self, nVars + 1 )               // Var Data

  // Parent Class (Has Hidden and protected messages included.)
  Class := __ClassIns( aHandle[ pPARENT ])
  Class := aSize( Class, nVars + 1 )             // Var Data

  nPlace := 1

  For nCount := 1 to nVars
    If nPlace <= len( aHandle[ pSTATIC_VARS ] ) .and. ;
       aHandle[ pSTATIC_VARS ][ nPlace ][ pSTATIC_VARS_POS ] == nCount
      // Static Var
      Self[ nCount + 1 ] := { aHandle[ pSTATIC_VARS ][ nPlace ][ pSTATIC_VARS_DATA ],;
                              aHandle[ pDATA ];
                                     [ aHandle[ pSTATIC_VARS ];
                                              [ nPlace ];
                                              [ pSTATIC_VARS_POS ]];
                                     [ pVAR_TYPE ],;
                              aHandle[ pDATA ];
                                     [ aHandle[ pSTATIC_VARS ];
                                              [ nPlace ];
                                              [ pSTATIC_VARS_POS ]];
                                     [ pVAR_VALTYPE ] }

      nPlace++
    Elseif len( aHandle[ pDATA ][ nCount ] ) == 2
      // Method
      Self[ nCount + 1 ] := { aHandle[ pDATA ][ nCount ][ pMETHOD_BLOCK ], ;
                              aHandle[ pDATA ][ nCount ][ pMETHOD_VALTYPE ] }
    Elseif len( aHandle[ pDATA ][ nCount ] ) == 3
      // Inst. Var
      Self[ nCount + 1 ] := { { aHandle[ pDATA ][ nCount ][ pVAR_DATA ] } , ;
                              aHandle[ pDATA ][ nCount ][ pVAR_TYPE ], ;
                              aHandle[ pDATA ][ nCount ][ pVAR_VALTYPE ] }
    Else
      // Method Var
      Self[ nCount + 1 ] := { NIL, ;
                              aHandle[ pDATA ][ nCount ][ pMETHOD_VAR_TYPE ], ;
                              aHandle[ pDATA ][ nCount ][ pMETHOD_VAR_GETBLOCK ], ;
                              aHandle[ pDATA ][ nCount ][ pMETHOD_VAR_SETBLOCK ], ;
                              aHandle[ pDATA ][ nCount ][ pMETHOD_VAR_VALTYPE ] }
    Endif
    Class[ nCount + 1 ] := Self[ nCount + 1 ]
  Next

  Self[ pSELFINFO ]    := aVars
  Class[ pSELFINFO ]   := aVars

  Self[ pSELFINFO ][ pPARENT_CLASS ] := Class

  For nInherit := 1 to Len( aInherit ) // Set the Super Class
    oInherit := aInherit[ nInherit ][ 1 ]

    // Set CHILD Object
    if isClassic( oInherit )
      oInherit[ oInherit[ pSELFINFO ][ pSUBCLASSPOS ] ][ 1 ][ 1 ] := Self
    endif

    // Set SUPER Object(s)
    If Len( aInherit ) == 1
      Self[ aHandle[ pINFO ][ pSUPERPOS ] ][ 1 ][ 1 ] := oInherit
    Else
      If nInherit == 1
        Self[ aHandle[ pINFO ][ pSUPERPOS ] ][ 1 ][ 1 ] := array( len( aInherit ))
      Endif
      Self[ aHandle[ pINFO ][ pSUPERPOS ] ][ 1 ][ 1 ][ nInherit ] := oInherit
    Endif
  Next

  if !aHandle[ pDONE ]  // ADDED?
    If 0 != ascan( aUsed, "INITCLASS" ) .and. 0 == ascan( aUsed, "_INITCLASS" )
      // Call InitClass the first time the Class is created.
      Class:InitClass()
    Endif
  endif

  Set( _SET_EXACT, lExact )
Return( Self )

// Mark messages for renameing
Function _oJVAddRename( aHandle, cVar, cName, lVar, cInherit )
  Local lExact := Set( _SET_EXACT, .t. )

  if !aHandle[ pDONE ]
    Default cVar to cName
    cVar  := Upper( alltrim( cVar ))
    cName := Upper( alltrim( cName ))

    If Empty( cInherit )
      nPlace := 1
    else
      cInherit := Upper( alltrim( cInherit ))
      nPlace := aScan( aHandle[ pINHERIT_NAMES ], cInherit )
    Endif

    If nPlace != 0
      aadd( aHandle[ pINFO ][ pRENAME ][ nPlace ][ pRENAME_OLD ], cVar )
      aadd( aHandle[ pINFO ][ pRENAME ][ nPlace ][ pRENAME_NEW ], cName )
      if lVar
        aadd( aHandle[ pINFO ][ pRENAME ][ nPlace ][ pRENAME_OLD ], ;
              left("_" + cVar, 10 ) )
        aadd( aHandle[ pINFO ][ pRENAME ][ nPlace ][ pRENAME_NEW ], ;
              left("_" + cName, 10 ) )
      endif
    Endif
  endif

  Set( _SET_EXACT, lExact )
Return (NIL)

Static Function IsClassic( oObj )
  Local lClassic := .f.

  If valtype( oObj ) == "O" .and. ;
     Len( oObj ) >= pSELFINFO .and. ;
     valtype( oObj[ pSELFINFO ] ) == "A"
    if ( len( oObj[ pSELFINFO ] ) >= pJVCLASS .and. ;
          Valtype( oObj[ pSELFINFO ][ pJVCLASS ] ) == "C" .and. ;
          oObj[ pSELFINFO ][ pJVCLASS ] == "J.V. Object" )
      lClassic := .t.
    endif
  Endif
Return( lClassic )

// Mark Hidden and protected messages
Static Function AddExclude( aHandle, cVar, cType )
  aadd( aHandle[ pINFO ][ pEXCLUDE ][ pEXCLUDE_MSG ], ;
        Upper( Left( cVar, 10 )))
  aadd( aHandle[ pINFO ][ pEXCLUDE ][ pEXCLUDE_TYPE ], cType )
Return( NIL )

// Rename a Var
Static Function Rename( cMessage, aRename, nInherit )
  Local nFind := aScan( aRename[ nInherit ][ pRENAME_OLD ], cMessage )

  if nFind != 0
    cMessage := aRename[ nInherit ][ pRENAME_NEW ][ nFind ]
  endif
Return( cMessage )

// Un-Rename a Var
Static Function Unname( cMessage, aUnname, nInherit )
  Local lExact := Set( _SET_EXACT, .t. )
  Local nFind := ascan( aUnName[ nInherit ][ pRENAME_NEW ], cMessage )

  if nFind != 0
    cMessage := aUnname[ nInherit ][ pRENAME_OLD ][ nFind ]
  endif
  Set( _SET_EXACT, lExact )
Return( cMessage )

// CLassic Errors
Function _oJVError( nError, cOperation, cMsg )
  oError := ErrorNew()

  oError:SubSystem   := "CLASSic"
  oError:operation   := CallingMsg( 1 )
  oError:severity    := ES_ERROR
  if nError == NIL
    oError:GenCode     := EG_READONLY
    oError:description := "Instance Variable is Readonly!"
    oError:SubCode     := 1001
  elseif nError == 1
    oError:severity    := ES_WARNING
    oError:GenCode     := EG_DATATYPE
    oError:description := "Invalid Assignment Type!"
    oError:CanDefault  := .t.
    oError:SubCode     := 1002
  elseif nError == 2
    Default cMsg to "Check Failure!"

    oError:SubSystem   := "CLASSic Assumption"
    oError:CanDefault  := .t.
    oError:severity    := ES_WARNING
    oError:GenCode     := EG_DATATYPE
    oError:description := cMsg
    oError:SubCode     := 1003
    oError:operation   := cOperation
  elseif nError == 3
    oError:severity    := ES_WARNING
    oError:GenCode     := EG_DATATYPE
    oError:description := "Invalid Return Value!"
    oError:CanDefault  := .t.
    oError:SubCode     := 1002
  endi

  Eval( ErrorBlock(), oError )
Return (NIL)

// Get a methods code block!
Function _oJVParms( bFunc )
  If lBreak
    Break bFunc
  Endif
Return( NIL )

// Returns Message
Function CallingMsg( nLevel := 2, bFunc )
  nLevel++
Return( Substr( ProcName( nLevel ), at( ":", ProcName( nLevel ) ) + 1 ))

// Add a message to a class
Static Function AddMessage( aHandle, cMsg, nNum, lVisible := .t. )
  Local cCall := "_oJMsg" + lTrim( str( min( nNum, pMESSAGES + 1 ), 2, 0 ))

  If nNum > pMESSAGES
    cCall := "_oJVLrg"
    cMsg := Upper( Left( cMsg, 10 ))
  else
    aadd( aHandle[ pINFO ][ pMSG_LIST ][ 1 ], cMsg )
    aadd( aHandle[ pINFO ][ pMSG_LIST ][ 2 ], nNum )
  Endif

  If lVisible
    __ClassAdd( aHandle[ pHANDLE ], cMsg, cCall )
  Endif
  __ClassAdd( aHandle[ pPARENT ], cMsg, cCall )
Return( NIL )

// Get the array element where a inst var is located based on
// the message called
Static Function FindPlace( aMsg )
  nPlace := aScan( aMsg[ 1 ], CallingMsg(1) )
  nPlace := aMsg[ 2 ][ nPlace ]
Return( nPlace )

// When more than 89 messages are used in a class this function
// handles the messages 90 and up.
// It scans an array for the message to determin the array element
// that contains that message's info.
Function _oJVLrg( xSet, pParm )
  Local Self := QSelf()
  Local nPlace := FindPlace( Self[ pSELFINFO ][ pMSG_LIST ] )
  Local xType := Self[ nPlace + 1 ]

  Do Case
  Case Len( xType ) == 2
    Self := eval( xType[ pMETHOD_BLOCK ], Self, xSet, pParm )
    if !xType[2] == NIL .and. !xType[2] == Valtype( Self )
      _oJVError(3)
    endif
  Case Len( xType ) == 2
    Do Case
    Case pCount() == 1
      Do Case
      Case !Self == Self[ pSELFINFO ][ pPARENT_CLASS ] .and.  ;
           xType[2] == "R"
        _oJVError()
      Case !xType[3] == NIL .and. !xSet == NIL .and.         ;
           !xType[3] == Valtype( xSet )
        _oJVError(1)
      Otherwise
        xType[ 1 ][ 1 ] := xSet
      End
    Otherwise
      Self := xType[ 1 ][ 1 ]
    End
  Otherwise
    Self[ pSELFINFO ][ pMETHODVAR_POS ] := nPlace + 1
    Do Case
    Case pCount() == 1
      if !xType[5] == NIL .and. !xSet == NIL .and.         ;
         !xType[5] == Valtype( xSet )
        _oJVError(1)
      else
        eval( xType[ pMETHOD_VAR_SETBLOCK ], Self, xSet )
      endif
    Otherwise
      Self := eval( xType[ pMETHOD_VAR_GETBLOCK ], Self )
    End
  End
Return( Self )

// Check that typed inst var and method have the correct data type
Function _oJVType( xType, xSet, Self, xFunc )
  Do Case
  case pcount() == 2
    if ( !( xType[5] == NIL .or. xSet == NIL .or. ;
            xType[5] == Valtype( xSet )))
      _oJVError(1)
    endif
  case pcount() == 3
    if !( xType[2] == NIL .or. xType[2] == Valtype( Self ) )
      _oJVError(3)
    endif
  Case xType[2] == "R" .and. ;
       !Self == Self[pSELFINFO][pPARENT_CLASS]
    _oJVError()
  Case ! ( xType[3] == NIL .or. xSet == NIL .or. ;
           xType[3] == Valtype( xSet ))
    _oJVError(1)
  Endcase
Return( NIL )

// the first 89 messages use these functions that have hard coded array
// elements that point to the message's info.
#Command VarFunc <cFunc> <nNum>                                         ;
      => Func <cFunc>(xSet,pParm)                                       ;
       ;   Local Self := QSelf()                                        ;
       ;   Local xType := Self\[ <nNum> + 1 \]                          ;
       ;   do Case                                                      ;
       ;   Case Len( xType ) == 3                                       ;
       ;     if pCount() == 1                                           ;
       ;       _oJVType( xType, xSet, Self, 1 )                         ;
       ;       xType\[ 1 \]\[ 1 \] := xSet                              ;
       ;     else                                                       ;
       ;       Self := xType\[ 1 \]\[ 1 \]                              ;
       ;     End                                                        ;
       ;   Case Len( xType ) == 2                                       ;
       ;     if pCount() <= 17                                          ;
       ;       Self := eval( xType\[pMETHOD_BLOCK\], Self, @xSet, pParmp16 );
       ;     else                                                           ;
       ;       Self := eval( xType\[pMETHOD_BLOCK\], Self, @xSet, pParmp )  ;
       ;     end                                                        ;
       ;     _oJVType( xType, NIL, Self )                               ;
       ;   Otherwise                                                    ;
       ;     Self\[ pSELFINFO \]\[ pMETHODVAR_POS \] := <nNum> + 1      ;
       ;     if pCount() == 1                                           ;
       ;       _oJVType( xType, xSet )                                  ;
       ;       eval( xType\[pMETHOD_VAR_SETBLOCK\], Self, @xSet )       ;
       ;     else                                                       ;
       ;       Self := eval( xType\[pMETHOD_VAR_GETBLOCK\], Self )      ;
       ;     End                                                        ;
       ;   End                                                          ;
       ; Return( Self )

VarFunc _oJMsg1 1
VarFunc _oJMsg2 2
VarFunc _oJMsg3 3
VarFunc _oJMsg4 4
VarFunc _oJMsg5 5
VarFunc _oJMsg6 6
VarFunc _oJMsg7 7
VarFunc _oJMsg8 8
VarFunc _oJMsg9 9
VarFunc _oJMsg10 10
VarFunc _oJMsg11 11
VarFunc _oJMsg12 12
VarFunc _oJMsg13 13
VarFunc _oJMsg14 14
VarFunc _oJMsg15 15
VarFunc _oJMsg16 16
VarFunc _oJMsg17 17
VarFunc _oJMsg18 18
VarFunc _oJMsg19 19
VarFunc _oJMsg20 20
VarFunc _oJMsg21 21
VarFunc _oJMsg22 22
VarFunc _oJMsg23 23
VarFunc _oJMsg24 24
VarFunc _oJMsg25 25
VarFunc _oJMsg26 26
VarFunc _oJMsg27 27
VarFunc _oJMsg28 28
VarFunc _oJMsg29 29
VarFunc _oJMsg30 30
VarFunc _oJMsg31 31
VarFunc _oJMsg32 32
VarFunc _oJMsg33 33
VarFunc _oJMsg34 34
VarFunc _oJMsg35 35
VarFunc _oJMsg36 36
VarFunc _oJMsg37 37
VarFunc _oJMsg38 38
VarFunc _oJMsg39 39
VarFunc _oJMsg40 40
VarFunc _oJMsg41 41
VarFunc _oJMsg42 42
VarFunc _oJMsg43 43
VarFunc _oJMsg44 44
VarFunc _oJMsg45 45
VarFunc _oJMsg46 46
VarFunc _oJMsg47 47
VarFunc _oJMsg48 48
VarFunc _oJMsg49 49
VarFunc _oJMsg50 50
VarFunc _oJMsg51 51
VarFunc _oJMsg52 52
VarFunc _oJMsg53 53
VarFunc _oJMsg54 54
VarFunc _oJMsg55 55
VarFunc _oJMsg56 56
VarFunc _oJMsg57 57
VarFunc _oJMsg58 58
VarFunc _oJMsg59 59
VarFunc _oJMsg60 60
VarFunc _oJMsg61 61
VarFunc _oJMsg62 62
VarFunc _oJMsg63 63
VarFunc _oJMsg64 64
VarFunc _oJMsg65 65
VarFunc _oJMsg66 66
VarFunc _oJMsg67 67
VarFunc _oJMsg68 68
VarFunc _oJMsg69 69
VarFunc _oJMsg70 70
VarFunc _oJMsg71 71
VarFunc _oJMsg72 72
VarFunc _oJMsg73 73
VarFunc _oJMsg74 74
VarFunc _oJMsg75 75
VarFunc _oJMsg76 76
VarFunc _oJMsg77 77
VarFunc _oJMsg78 78
VarFunc _oJMsg79 79
VarFunc _oJMsg80 80
VarFunc _oJMsg81 81
VarFunc _oJMsg82 82
VarFunc _oJMsg83 83
VarFunc _oJMsg84 84
VarFunc _oJMsg85 85
VarFunc _oJMsg86 86
VarFunc _oJMsg87 87
VarFunc _oJMsg88 88
VarFunc _oJMsg89 89

// The 16 inherited routines
Func _oJVPass1
  Parameters pParm
  Local cParm := Left( pcParm, pCount() * 4 )
  Local xMessage := CallingMsg( 0 )
  Local Self  := qSelf()
  // qself() is a Clipper function that returns the calling class

  If Valtype( self:Super ) == "O" // Only one inheritance
    Private _oInherit := Self:Super
  Else // Multiple inheritance
    Private _oInherit := Self:Super[ 1 ]
  End

  // Un-Rename the inherited message
  xMessage := UnName( xMessage, Self[ pSELFINFO ][ pRENAME ], 1 )

  // force clipper to call the un-renamed message
  xMessage := &( "_oInherit:" + xMessage + "( " + cParm + " )" )

  // If the inherited class returns the parent class then
  // return the standard class
  if valtype( xMessage ) == "O" .and. xMessage == _oInherit
    xMessage := Self
  endif
Return(xMessage)

#xCommand PassFunc <func> <num>                                         ;
       => Function <func>                                               ;
        ;   Parameters pParm                                            ;
        ;   Local xMessage := CallingMsg( 0 )                           ;
        ;   Local cParm := Left( pcParm, pCount() * 4 )                 ;
        ;   Local Self  := qSelf()                                      ;
        ;   Private _oInherit := Self:Super\[ <num> \]                  ;
        ;   xMessage := UnName( xMessage,                               ;
                                Self\[ pSELFINFO \]\[ pRENAME \],       ;
                                <num> )                                 ;
        ;   xMessage := &( "_oInherit:" + xMessage + "( " + cParm + " )" )  ;
        ;   if valtype( xMessage ) == "O"  .and. xMessage == _oInherit  ;
        ;     xMessage := Self                                          ;
        ;   endif                                                       ;
        ; Return(xMessage)

PassFunc _oJVPass2 2
PassFunc _oJVPass3 3
PassFunc _oJVPass4 4
PassFunc _oJVPass5 5
PassFunc _oJVPass6 6
PassFunc _oJVPass7 7
PassFunc _oJVPass8 8
PassFunc _oJVPass9 9
PassFunc _oJVPass10 10
PassFunc _oJVPass11 11
PassFunc _oJVPass12 12
PassFunc _oJVPass13 13
PassFunc _oJVPass14 14
PassFunc _oJVPass15 15
PassFunc _oJVPass16 16