// CLASSic Menu Class
// By John D. Van Etten
// Written in CLASSic

// Use this class with the Item Class

#include "Classic.ch"
#include "Inkey.ch"
#include "Set.ch"
#include "Menu.ch"

Begin Class oMenu Select From oWin()
  Method Init

  Global:
    Var Items        Type Array         // a, Array of choices
    Var Choice       Type Numeric       // n, The selected choice
    Var AutoRestore  Type Logical       // l, Closes the box when choice is made
    Var Confirm      Type Logical       // l, Force user to press enter?
    Var Wrap         Type Logical       // l, Like Clipper's SET WRAP
    Var MsgLine      Type Numeric       // n, Like Clipper's SET MESSAGE
    Var ClsMsgLine   Type Logical       // l, Clear the whole message line?
    Var MsgCenter    Type Logical       // l, Like Clipper's SET MESSAGE CENTER
    Var Cargo                           //    Whatever you want!
    Var Width        Type Numeric       // n, What is the width of the options?
    Var InBox        Type Logical       // l, Is it in a box?
    Var CodeBlock    Type Block         // b, Runs when key is pressed

    // Menu Window
    Method MenuTo     Type Numeric      // Draw the box and do the menu
    Method Open                         // Draw the box and show the menu
    Method CloseMenu Message Close      // Close the box
    Method Move                         // Move the box to somewhere
    Method Configure                    // Re-evaluate color string

    // Menu Prompts
    Method Prompt     Type Object       // New Item using screen coord.
    Method NewItem    Type Object       // New Item and put it in the box
    Method AddItem    Type Numeric               // Add a item to the menu
    Method AddItem Message AddText Type Numeric  // Add Text to the box
    Method DelItem    Type Object       // Remove an item from the menu
    Method AddNewItem Type Object       // New Item and add it to the menu

    // Let's ONLY inherit these from oWin! ( See oWIN.PRG )
    Var Top         Inherits nTop         From oWin()
    Var Left        Inherits nLeft        From oWin()
    Var Bottom      Inherits nBottom      From oWin()
    Var Right       Inherits nRight       From oWin()
    Var Color       Inherits cColor       From oWin()
    Var Opened      Inherits lOpened      From oWin()
    Var Header      Inherits              From oWin()
    Var Footer      Inherits              From oWin()
    Var HeadColor   Inherits cHeaderColor From oWin()
    Var FootColor   Inherits cFooterColor From oWin()

  Local:
    Var aKeys                           // List of hot keys
    Method Process                      // Main menu loop
    Method Settle                       // Moves to the next menu choice
    Method Pos2Choice                   // Converts array pos. to Choice #
    Method Choice2Pos                   // Converts Choice # to Array pos.
end class

Method Init( nTop, nLeft, nBottom, nRight, ;
             cColor := "w+/gb, gr+/b, , r/n,n+/gb", ;
             cHeader, cFooter, cHeadColor, cFootColor ),()

  :::Move( nTop, nLeft, nBottom, nRight )
  ::Color     := cColor
  ::Header    := cHeader
  ::Footer    := cFooter
  ::HeadColor := cHeadColor
  ::FootColor := cFootColor

  ::Color := cColor
  :::lAutoFormat := .f.
  ::Items := {}
  ::Choice := 0
  ::InBox := .f.
  ::AutoRestore := .t.

Return( Self )

Method Prompt( nRow, nCol, cChoice, nHiPos, cMsg, bMenuBlock, cColor, ;
               cMsgColor )
Return( oMenuItem():New( Self, nRow, nCol, cChoice, nHiPos, cMsg, ;
                         bMenuBlock, cColor, cMsgColor) )

Method NewItem( cChoice, nHiPos, cMsg, bMenuBlock, cColor, cMsgColor )
Return( oMenuItem():New( Self, NIL, NIL, cChoice, nHiPos, cMsg, ;
                         bMenuBlock, cColor, cMsgColor) )

Method AddNewItem( cChoice, nHiPos, cMsg, bMenuBlock, cColor, cMsgColor )
  Local oItem := oMenuItem():New( Self, NIL, NIL, cChoice, nHiPos, cMsg, ;
                                  bMenuBlock, cColor, cMsgColor)
  ::AddItem( oItem )
Return( oItem )

Method AddItem( oItem, nPlace )
  DispBegin()
  If nPlace == NIL
    aadd( ::Items, oItem )
    nPlace := Len( ::Items )
  elseif nPlace > len( ::Items )
    aSize( ::Items, nPlace )
    ::Items[ nPlace ] := oItem
  else
    aPush( ::Items, nPlace, oItem )
  Endif

  if ::Opened
    ::Open()
  endif
  DispEnd()
Return( nPlace )

Method DelItem( xDel )
  Local nCount
  Local oItem

  Check xDel is Object, Numeric

  DispBegin()
  If valtype( xDel ) == "O"
    For nCount := 1 to Len( ::Items )
      If valtype( ::Items[ nCount ] ) == "O"
        If ::Items[ nCount ] == xDel
          aKill( ::Items, nCount-- )
        Endif
      Endif
    Next
    oItem := xDel
  else
    oItem := ::Items[ xDel ]
    aKill( ::Items, xDel )
  Endif
  if ::opened
    ::Open()
  endif
  DispEnd()
Return( oItem )

Method CloseMenu()
  Local nChoice := ::Choice
  Local nPos
  Local oItem

  DispBegin()
  If full( nChoice )
    If ( nPos := ::Choice2Pos( nChoice )) > 0
      If valtype( oItem := ::Items[ ::Choice2Pos( nChoice ) ]) == "O"
        if oItem:HasFocus
          oItem:KillFocus()
        endif
      Endif
    Endif
  Endif
  :::Close()
  DispEnd()
Return (Self)

Method Open()
  Local nCount
  Local xItem
  Local cChoice
  Local aText := {}

  ::InBox := .f.
  ::Width := 0
  ::aKeys := {}
  For nCount := 1 to Len( ::Items )
    xItem := ::Items[ nCount ]

    If valtype( xItem ) == "O"
      If xItem:SetRow == NIL .or. xItem:SetCol == NIL
        ::InBox := .t.
      Endif
      if full( xItem:Text )
        ::Width := Max( ::Width, len( xItem:Text ) + 2 )
      endif
      aadd( aText, "" )
    elseif valtype( xItem ) == "C"
      ::Width := Max( ::Width, len( xItem ))
      aadd( aText, xItem )
    Endif
  Next

  :::Begin()
  If ::InBox
    If Full( :::Header )
      ::Width := Max( ::Width, len( :::Header ) + 2 )
    Endif
    If Full( :::Footer )
      ::Width := Max( ::Width, len( :::Footer ) + 2 )
    Endif
    :::Close() : Size( ::Width, Len( ::Items )) : Open( aText )
    For nCount := 1 to len( ::Items )
      xItem := ::Items[ nCount ]
      If valtype( xItem ) == "O"
        aadd( ::aKeys, Upper( xItem:Display( :::Row( nCount ), ;
                                             :::Col( 1 ))))
      else
        aadd( ::aKeys, NIL )
      Endif
    Next
  Else
    For nCount := 1 to len( ::Items )
      xItem := ::Items[ nCount ]
      If valtype( xItem ) == "O"
        aadd( ::aKeys, Upper( xItem:Display() ))
      else
        aadd( ::aKeys, NIL )
      Endif
    Next
  Endif
  :::End()
Return( Self )

Method Move( nTop, nLeft )
  DispBegin()

  :::Move( nTop, nLeft )
  If ::Opened
    ::Open()
  Endif

  DispEnd()
Return( Self )

Method Process( aKeys )
  Local nChoice
  Local nKey := 0
  Local nGetKey := 0
  Local oItem
  Local bCode
  Local nCursor := SetCursor( 0 )
  Local bCodeBlock := ::CodeBlock

  If full( bCodeBlock )
    Eval( bCodeBlock, pMENUSTART, Self, NIL, 0 )
  Endif
  ::Settle()

  DispBegin()
  Do while ::Choice > 0 // A negitave number exits the loop
    oItem := ::Items[ ::Choice2Pos( ::Choice ) ]
    if !oItem:Enabled  // Someone disabled the current item!
      ::Settle()       // Re-Settle!
      if ::Choice == 0 // Are there any left!
        exit           // NON LEFT!!!
      else
        oItem := ::Items[ ::Choice2Pos( ::Choice ) ]
      endif
    endif

    oItem:SetFocus()
    If nChoice != ::Choice
      If full( bCodeBlock )
        SetCursor( nCursor )
        DispEnd()
        Eval( bCodeBlock, pGOTFOCUS, Self, oItem, 0 )
        DispBegin()
        nCursor := SetCursor( 0 )
      Endif
    Endif

    DispEnd()
    nChoice := ::Choice
    nKey := Inkey( 0 )

    If full( bCodeBlock )
      SetCursor( nCursor )
      nGetKey := Eval( bCodeBlock, pMENUKEY, Self, oItem, nKey )
      nCursor := SetCursor( 0 )
      if valtype( nGetKey ) == "N"
        nKey := nGetKey
      endif
    Endif

    if full( bCode := Setkey( nKey ) )
      SetCursor( nCursor )
      Eval( bCode, CLASSNAME(), CLASSLINE(), "obj:CHOICE" )
      nCursor := SetCursor( 0 )
    endif

    ::Settle( nKey )
    DispBegin()
    If nChoice != ::Choice
      If full( bCodeBlock )
        SetCursor( nCursor )
        DispEnd()
        Eval( bCodeBlock, pLOSTFOCUS, Self, oItem, 0 )
        DispBegin()
        nCursor := SetCursor( 0 )
      Endif
    Endif
    oItem:KillFocus()

    If ::Choice < 0 // The selection is a negitave
      oItem := ::Items[ ::Choice2Pos( -::Choice ) ]
      If Full( bCode := oItem:MenuBlock )
        If ::AutoRestore .or. oItem:AutoRestore
          ::Close()
          nChoice := NIL
        Endif
        DispEnd()
        Eval( bCode, Self, oItem )
        DispBegin()
        If ::AutoRestore .or. oItem:AutoRestore
          ::Open()
        Endif
        ::Choice := -::Choice
      Endif
    Endif
  Enddo
  DispEnd()
  If full( bCodeBlock )
    Eval( bCodeBlock, pMENUEND, Self, NIL, 0 )
  Endif
  SetCursor( nCursor )
  ::Choice := abs( ::Choice )
Return( Self )

Method Settle( nKey, nPos := ::Choice2Pos( ::Choice ) )
  Local lWrap := ::Wrap
  Local nLen := Len( ::Items )
  Local nTemp
  Local aItems := ::Items

  Default lWrap to set( _SET_WRAP )
  If nLen == 0
    nPos := 0
  else

    If nKey == NIL // Settle forward
      If nPos <= 0
        nPos := 1
      Endif

      nTemp := nPos
      Do while nPos <= nLen .and. ;
               ( valtype( aItems[ nPos ] ) != "O" .or. ;
                 !aItems[ nPos ]:Enabled )
        nPos++
      Enddo

      If nPos > nLen
        If !lWrap
          nPos := min( nTemp, len( aItems ) )
          Do while nPos > 0 .and. ;
                   ( valtype( aItems[ nPos ] ) != "O" .or. ;
                     !aItems[ nPos ]:Enabled )
            nPos--
          Enddo
        Else
          nPos := 1
          Do while nPos <= nTemp .and. ;
                   ( valtype( aItems[ nPos ] ) != "O" .or. ;
                     !aItems[ nPos ]:Enabled )
            nPos++
          Enddo
          If nPos > nTemp
            nPos := 0
          Endif
        Endif
      Endif
    ElseIf nKey == -1 //Settle backward
      If nPos > nLen
        nPos := nLen
      Endif
      nTemp := nPos
      Do while nPos > 0 .and. ;
               ( valtype( aItems[ nPos ] ) != "O" .or. ;
                 !aItems[ nPos ]:Enabled )
        nPos--
      Enddo

      If nPos == 0
        If !lWrap
          nPos := max( nTemp, 1 )
          Do while nPos <= nLen .and. ;
                   ( valtype( aItems[ nPos ] ) != "O" .or. ;
                     !aItems[ nPos ]:Enabled )
            nPos++
          Enddo
        Else
          nPos := Len( aItems )
          Do while nPos >= nTemp .and. ;
                   ( valtype( aItems[ nPos ] ) != "O" .or. ;
                     !aItems[ nPos ]:Enabled )
            nPos--
          Enddo
          If nPos < nTemp
            nPos := 0
          Endif
        Endif
      Endif
    Else
      If nPos > nLen
        nPos := nLen
      elseIf nPos <= 0
        nPos := 1
      Endif

      If < nKey == K_UP, K_LEFT >
        if --nPos <= 0 .and. lWrap
          nPos := nLen
        endif
        nPos := ::Settle( -1, nPos )
      ElseIf < nKey == K_DOWN, K_RIGHT >
        if ++nPos > nLen .and. lWrap
          nPos := 1
        endif
        nPos := ::Settle( NIL, nPos )
      ElseIf nKey == K_HOME
        nPos := 1
        nPos := ::Settle( NIL, 1 )
      ElseIf nKey == K_END
        nPos := Len( ::Items )
        nPos := ::Settle( -1, Len( ::Items ))
      ElseIf < nKey == K_PGUP, K_PGDN, K_ENTER, K_CTRL_W >
        nPos := -nPos
      ElseIf nKey == K_ESC
        nPos := 0
      ElseIf full( nKey )
        If ( nTemp := ascan( ::aKeys, {|x| x != NIL .and. x == upper( chr( nKey )) })) != 0
          if aItems[ nTemp ]:Enabled
            nPos := nTemp
            if ::Confirm == NIL .or. !::Confirm
              nPos := -nPos
            endif
          endif
        Endif
      Endif
    endif
  endif

  If nPos < 0
    ::Choice := -::Pos2Choice( -nPos )
  else
    ::Choice := ::Pos2Choice( nPos )
  Endif
Return( nPos )

Method MenuTo( nChoice )

  If full( nChoice )
    ::Choice := nChoice
  Endif

  ::Configure()
  if !::Opened
    ::Open()
  endif
  ::Process()
Return( ::Choice )

Method Choice2Pos( nChoice )
  Local nPos := 0
  Local nCount
  Local aItems := ::Items

  For nCount := 1 to nChoice
    nPos++
    Do while nPos <= Len( aItems ) .and. valtype( aItems[ nPos ] ) != "O"
      nPos++
    Enddo
  Next
  If nPos > len( aItems )
    nPos := 0
  Endif
Return( nPos )

Method Pos2Choice( nPos )
  Local nChoice := 0
  Local nCount
  Local aItems := ::Items

  For nCount := 1 to nPos
    if nCount > len( aItems )
      nChoice := 0
      exit
    endif
    if valtype( aItems[ nCount ] ) == "O"
      nChoice++
    endif
  Next
Return( nChoice )

Method Configure()
  Local nCount
  Local oItem

  For nCount := 1 to len( ::Items )
    oItem := ::Items[ nCount ]
    If valtype( oItem ) == "O"
      oItem:Configure()
    Endif
  Next

  if ::Opened
    ::Open()
  endif
Return( Self )
