#include "addon.ch"

Function ClassName( nLevel := 0, lGetLine := .f. )
  Local cProc := "CLASSNAME"
  Local nLine := 0
  Local nProc := 1
  Local cMethod
  Local cObject
  Local cMessage

  nLevel += 1 // Don't include this call to ClassName!

  Do while nLevel > 0
    nLine := ProcLine( nProc )
    if left( ProcName( nProc + 2 ), 4 ) == "obj:" .and. ;
        left( ProcName( nProc + 1 ), 3 ) == "(b)" .and. ;
        !ProcName( nProc + 1 ) $ "$"

      cMethod := ProcName( nProc )
      cObject := Substr( ProcName( nProc + 1 ), 4 )
      if cObject == cMethod
        cObject := "obj"
      Endif

      cMessage := cObject + ":" + Substr( ProcName( nProc + 2 ), 5)
      nProc++
      Do while left( ProcName( nProc + 2 ), 4 ) == "obj:"
       cMessage := "obj:" + Substr( ProcName( nProc + 2 ), 5) + "," + cMessage
        nProc++
      Enddo

      cProc := cMessage + "/" + cMethod
      nProc += 2
    else
      cProc := ProcName( nProc )
      nProc++
    endif
    nLevel--
  Enddo
Return( iif( lGetLine, nLine, cProc ))

Function ClassLine( nLevel := 0 )
  * Get Line
Return( CLASSNAME( nLevel + 1, .t. ))
