// CLASSic Stack Class
// By John D. Van Etten
// Written in CLASSic

// Usage:
//   oStack := oStack():New()
//   oStack:Stack := 10
//   oStack:Stack := 20
//
//   ?oStack:Stack    ->  20
//   ?oStack:Stack    ->  10

#include "Classic.ch"

Begin Class oStack
  Method Init                                     // New Stack

  Global:
    Method Init Message Clear                       // Clear Stack

    Method Var Stack                                // Push/Pop Values

    Block {|| Len( ::aStack ) }       Message Len   // Size of stack
    Block {|| aTail( ::aStack ) }     Message Next  // Get next w/o removing

    Var aStack READONLY                             // Stack Array

End Class:Init() // Just so you don't have too.

Method Init
  ::aStack := {}
Return( Self )

Method Var Stack( xValue )
  If Set
    aadd( ::aStack, xValue )
  Else
    xValue := atail( ::aStack )
    ::aStack := ::aSize( ::aStack, Len( ::aStack ) - 1 )
  Endif
Return( xValue )
